/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.border.EmptyBorder;
import novaworx.swing.XButton;
import novaworx.swing.XColor;
import novaworx.swing.XPanel;
import novaworx.swing.XPopup;

public class XColorPopup
extends XPopup {
    private Color moColor;
    private AutoSelectionHandler moAutoSelectionHandler;
    private static Color[] maColors = new Color[16];

    public XColorPopup() {
        AutoSelectionHandler moAutoSelectionHandler = new AutoSelectionHandler();
        Dimension oGridSize = new Dimension(8, 8);
        Dimension oButtonSize = new Dimension(12, 12);
        XPanel oSwatchPanel = new XPanel();
        oSwatchPanel.setLayout(new GridLayout(8, 8));
        for (int iColumn = 0; iColumn < oGridSize.width; ++iColumn) {
            for (int iRow = 0; iRow < oGridSize.height; ++iRow) {
                int iOpacity = 255 - iColumn * 34;
                XColor oColor = new XColor(maColors[iRow], iOpacity);
                XButton oButton = new XButton();
                oButton.setMinimumSize(new Dimension(oButtonSize));
                oButton.setPreferredSize(new Dimension(oButtonSize));
                oButton.setMaximumSize(new Dimension(oButtonSize));
                oButton.setBackground(oColor);
                oButton.setBorder(new EmptyBorder(0, 0, 0, 0));
                oButton.setMargin(new Insets(0, 0, 0, 0));
                oButton.setFocusPainted(false);
                oButton.addActionListener(moAutoSelectionHandler);
                oButton.setActionCommand(XColor.encode(oColor));
                oSwatchPanel.add(oButton);
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)oSwatchPanel, "West");
    }

    public void setColor(Color aoColor) {
        this.moColor = aoColor;
        this.repaint();
    }

    public Color getColor() {
        return this.moColor;
    }

    static {
        XColorPopup.maColors[0] = Color.BLACK;
        XColorPopup.maColors[1] = Color.RED;
        XColorPopup.maColors[2] = Color.ORANGE;
        XColorPopup.maColors[3] = Color.YELLOW;
        XColorPopup.maColors[4] = Color.GREEN;
        XColorPopup.maColors[5] = Color.BLUE;
        XColorPopup.maColors[6] = Color.MAGENTA;
        XColorPopup.maColors[7] = Color.WHITE;
        XColorPopup.maColors[8] = Color.BLACK;
        XColorPopup.maColors[9] = Color.RED;
        XColorPopup.maColors[10] = Color.ORANGE;
        XColorPopup.maColors[11] = Color.YELLOW;
        XColorPopup.maColors[12] = Color.GREEN;
        XColorPopup.maColors[13] = Color.BLUE;
        XColorPopup.maColors[14] = Color.MAGENTA;
        XColorPopup.maColors[15] = Color.WHITE;
    }

    private class AutoSelectionHandler
    implements ActionListener {
        private AutoSelectionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            XColorPopup.this.cancel();
            Color oColor = XColor.decode(aoEvent.getActionCommand());
            XColorPopup.this.setColor(oColor);
            XColorPopup.this.fireSelectionMade(oColor);
        }
    }
}

