/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.Color;

public class XColor
extends Color {
    public static final XColor CLEAR = new XColor(BLACK, 0);
    public static final XColor SEMI_BLACK = new XColor(BLACK, 64);
    public static final XColor SEMI_GRAY = new XColor(GRAY, 64);
    public static final XColor SEMI_WHITE = new XColor(WHITE, 64);

    public XColor(Color aoColor, int aiAlpha) {
        super(aoColor.getRed(), aoColor.getGreen(), aoColor.getBlue(), aiAlpha);
    }

    public XColor(int aiRed, int aiGreen, int aiBlue) {
        super(aiRed, aiGreen, aiBlue);
    }

    public XColor(int aiRed, int aiGreen, int aiBlue, int aiAlpha) {
        super(aiRed, aiGreen, aiBlue, aiAlpha);
    }

    public static String encode(Color aoColor) {
        return Integer.toHexString(aoColor.getRGB());
    }

    public static String encode(Color aoForeground, Color aoBackground) {
        return Integer.toHexString(aoForeground.getRGB()) + ":" + Integer.toHexString(aoBackground.getRGB());
    }

    public static Color decode(String asColor) {
        Color oColor = null;
        try {
            oColor = Color.decode(asColor);
        }
        catch (NumberFormatException aoException) {
            // empty catch block
        }
        if (asColor != null) {
            if ((asColor = asColor.toLowerCase()).startsWith("#")) {
                asColor = asColor.substring(1);
            } else if (asColor.startsWith("0x")) {
                asColor = asColor.substring(2);
            }
            if (asColor.length() <= 8) {
                int iIndex = Math.max(0, asColor.length() - 6);
                String sAlpha = null;
                if (iIndex > 0) {
                    sAlpha = asColor.substring(0, iIndex);
                    asColor = asColor.substring(iIndex);
                }
                int iAlpha = 0;
                int iColor = -1;
                try {
                    if (sAlpha != null) {
                        iAlpha = Integer.parseInt(sAlpha, 16);
                    }
                }
                catch (NumberFormatException aoException) {
                    // empty catch block
                }
                try {
                    if (asColor != null) {
                        iColor = Integer.parseInt(asColor, 16);
                    }
                }
                catch (NumberFormatException aoException) {
                    // empty catch block
                }
                if (iColor >= 0) {
                    return new Color(iColor + (iAlpha <<= 24), true);
                }
            }
        }
        return CLEAR;
    }

    public static Color decodeForeground(String asColorCombination) {
        int iIndex = asColorCombination.indexOf(58);
        if (iIndex >= 0) {
            return XColor.decode(asColorCombination.substring(0, iIndex));
        }
        return XColor.decode(asColorCombination);
    }

    public static Color decodeBackground(String asColorCombination) {
        int iIndex = asColorCombination.indexOf(58);
        if (iIndex >= 0) {
            return XColor.decode(asColorCombination.substring(iIndex + 1));
        }
        return CLEAR;
    }

    public static Color getGrayscaleOffset(Color aoColor) {
        int iRed = aoColor.getRed();
        int iGreen = aoColor.getGreen();
        int iBlue = aoColor.getBlue();
        int iAlpha = aoColor.getAlpha();
        int iIntensity = ((iRed + iGreen + iBlue) / 3 + 159) % 255;
        return new Color(iIntensity, iIntensity, iIntensity, iAlpha);
    }

    public static Color getGrayscaleOpposite(Color aoColor) {
        int iRed = aoColor.getRed();
        int iGreen = aoColor.getGreen();
        int iBlue = aoColor.getBlue();
        int iAlpha = aoColor.getAlpha();
        int iIntensity = 255 - (iRed + iGreen + iBlue) / 3;
        return new Color(iIntensity, iIntensity, iIntensity, iAlpha);
    }

    public static Color combine(Color aoColorOne, Color aoColorTwo) {
        int iRedOne = aoColorOne.getRed();
        int iGreenOne = aoColorOne.getGreen();
        int iBlueOne = aoColorOne.getBlue();
        int iAlphaOne = aoColorOne.getAlpha();
        int iRedTwo = aoColorTwo.getRed();
        int iGreenTwo = aoColorTwo.getGreen();
        int iBlueTwo = aoColorTwo.getBlue();
        int iAlphaTwo = aoColorTwo.getAlpha();
        int iRed = (iRedOne + iRedTwo) / 2;
        int iGreen = (iGreenOne + iGreenTwo) / 2;
        int iBlue = (iBlueOne + iBlueTwo) / 2;
        int iAlpha = (iAlphaOne + iAlphaTwo) / 2;
        return new Color(iRed, iGreen, iBlue, iAlpha);
    }

    public static final Color lighterColor(Color aoColor, double adFactor) {
        int r = aoColor.getRed();
        int g = aoColor.getGreen();
        int b = aoColor.getBlue();
        int i = (int)(1.0 / (1.0 - adFactor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / adFactor), 255), Math.min((int)((double)g / adFactor), 255), Math.min((int)((double)b / adFactor), 255), aoColor.getAlpha());
    }

    public static final Color darkerColor(Color aoColor, double adFactor) {
        return new Color(Math.max((int)((double)aoColor.getRed() * adFactor), 0), Math.max((int)((double)aoColor.getGreen() * adFactor), 0), Math.max((int)((double)aoColor.getBlue() * adFactor), 0), aoColor.getAlpha());
    }
}

