/*
 * Decompiled with CFR 0.152.
 */
package novaworx.resource.scheme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import novaworx.Utilities;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import novaworx.resource.Resource;
import novaworx.resource.ResourceException;
import novaworx.resource.ResourceFactory;
import novaworx.resource.ResourceScheme;
import novaworx.resource.scheme.DefaultScheme;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;

public class FileScheme
extends DefaultScheme {
    public static final String LINK_FILE = "scheme.file.link.file";
    public static final String CACHE_FILE = "scheme.file.cache.file";
    public static final int IO_BUFFER_SIZE = 4096;
    private static FileScheme moInstance;
    private Hashtable mhFileIcons = new Hashtable();
    private FileSystemView moFileSystemView;
    private SimpleDateFormat moDateFormat;
    static /* synthetic */ Class class$java$io$File;

    private FileScheme() {
        this.mhFileIcons.put("jar", "java.jar");
        this.mhFileIcons.put("dtd", "resource.type.dtd");
        this.mhFileIcons.put("java", "resource.type.java");
        this.mhFileIcons.put("png", "resource.type.png");
        this.mhFileIcons.put("properties", "resource.type.properties");
        this.mhFileIcons.put("shellscript", "resource.type.shell");
        this.mhFileIcons.put("xml", "resource.type.xml");
        this.moDateFormat = new SimpleDateFormat();
        this.moFileSystemView = FileSystemView.getFileSystemView();
    }

    public static ResourceScheme getInstance() {
        if (moInstance == null) {
            moInstance = new FileScheme();
        }
        return moInstance;
    }

    public String getSchemeName() {
        return "file";
    }

    public Class getSchemeClass() {
        return class$java$io$File == null ? (class$java$io$File = FileScheme.class$("java.io.File")) : class$java$io$File;
    }

    public Resource createResource(Object aoSource) {
        String sFilename;
        if (!(aoSource instanceof File)) {
            throw new RuntimeException("Can only create resource from File objects.");
        }
        File oFile = (File)aoSource;
        if (!this.moFileSystemView.isDrive(oFile)) {
            File oCanonicalFile = null;
            try {
                oCanonicalFile = oFile.getCanonicalFile();
            }
            catch (IOException aoException) {
                Log.write(3, (Throwable)aoException);
                return null;
            }
            oFile = oCanonicalFile;
        }
        if ((sFilename = FileScheme.uriEncode(oFile.toString())) == null) {
            return null;
        }
        String sURI = null;
        sURI = sFilename.startsWith("/") ? "file:" + sFilename : "file:/" + sFilename;
        Log.write(6, "URI: " + sURI);
        URI oURI = null;
        try {
            oURI = new URI(sURI);
        }
        catch (URISyntaxException aoException) {
            Log.write(2, (Throwable)aoException);
            return null;
        }
        Object oLinkFile = null;
        Object sLinkUri = null;
        Object sLinkIcon = null;
        Object sLinkName = null;
        Resource oResource = new Resource(oURI);
        if (aoSource instanceof File) {
            oResource.setResource(CACHE_FILE, aoSource);
        }
        return oResource;
    }

    public static String uriEncode(String asString) {
        String sString = asString;
        sString = sString.replace('\\', '/');
        sString = sString.replaceAll(" ", "%20");
        Log.write(6, "Encoded string: " + sString);
        return sString;
    }

    public void init(Resource aoResource) {
        aoResource.setResource("resource.first.line", null);
        aoResource.setResource(CACHE_FILE, null);
        this.updateInformation(aoResource);
    }

    public synchronized void open(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        if (this.isContainer(aoResource)) {
            return;
        }
        this.updateInformation(aoResource);
    }

    /*
     * Loose catch block
     */
    public synchronized void load(Resource aoResource) throws ResourceException {
        byte[] aBuffer;
        byte[] aData;
        int iSize;
        block14: {
            if (aoResource.isContainer()) {
                return;
            }
            Object sExtension = null;
            File oFile = this.getFile(aoResource);
            Log.write(6, "Loading file: " + oFile.toString());
            Log.writePart("Loading file: " + oFile.getName() + " ... ");
            int iExpectedSize = (int)oFile.length();
            iSize = 0;
            aData = null;
            aBuffer = new byte[Math.max(iExpectedSize, 4096)];
            byte[] aReadBuffer = new byte[4096];
            aoResource.setModifiedFlagEnabled(false);
            FileInputStream oInput = null;
            oInput = new FileInputStream(oFile);
            int iBytesRead = ((InputStream)oInput).read(aReadBuffer);
            while (iBytesRead >= 0) {
                if (iBytesRead > aBuffer.length - iSize) {
                    byte[] aNewBuffer = new byte[aBuffer.length * 2];
                    System.arraycopy(aBuffer, 0, aNewBuffer, 0, iSize);
                    aBuffer = aNewBuffer;
                }
                System.arraycopy(aReadBuffer, 0, aBuffer, iSize, iBytesRead);
                iSize += iBytesRead;
                iBytesRead = ((InputStream)oInput).read(aReadBuffer);
            }
            Object var13_15 = null;
            try {
                if (oInput != null) {
                    ((InputStream)oInput).close();
                }
                Log.write(6, "File handle closed after load.");
            }
            catch (IOException aoCloseException) {
                Log.write(2, (Throwable)aoCloseException);
            }
            break block14;
            {
                catch (IOException aoException) {
                    Log.write("failed.");
                    throw new ResourceException(aoResource, (Throwable)aoException);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (oInput != null) {
                        ((InputStream)oInput).close();
                    }
                    Log.write(6, "File handle closed after load.");
                }
                catch (IOException aoCloseException) {
                    Log.write(2, (Throwable)aoCloseException);
                }
                throw throwable;
            }
        }
        aData = new byte[iSize];
        System.arraycopy(aBuffer, 0, aData, 0, iSize);
        String sBuffer = new String(aData);
        sBuffer = sBuffer.replaceAll("[\\r]*\\n", "\n").replaceAll("\\n\\r", "\n");
        aoResource.set("resource.data.buffer", sBuffer);
        try {
            aoResource.setResource("resource.first.line", this.getFirstLine(sBuffer));
        }
        catch (IOException aoException) {
            throw new ResourceException(aoResource, (Throwable)aoException);
        }
        this.updateInformation(aoResource);
        aoResource.setModifiedFlagEnabled(true);
        aoResource.setModified(false);
        Log.write("successful.");
    }

    /*
     * Loose catch block
     */
    public synchronized void save(Resource aoResource) throws ResourceException {
        block11: {
            if (aoResource.isContainer()) {
                return;
            }
            File oFile = this.getFile(aoResource);
            Log.write(6, "Saving file: " + oFile.toString());
            Log.writePart("Saving file: " + oFile.getName() + " ... ");
            aoResource.setModifiedFlagEnabled(false);
            OutputStream oOutput = null;
            String sDataBuffer = aoResource.get("resource.data.buffer");
            if (sDataBuffer == null) {
                sDataBuffer = "";
            }
            String sData = sDataBuffer.replaceAll("[\\r]*\\n", "\n").replaceAll("\\n\\r", "\n");
            byte[] aBytes = sData.getBytes("ISO-8859-1");
            int iExpectedSize = aBytes.length;
            oOutput = new FileOutputStream(oFile);
            oOutput.write(aBytes, 0, aBytes.length);
            aoResource.setResource("resource.first.line", this.getFirstLine(sData));
            aoResource.setResource("resource.type", this.getResourceType(aoResource));
            Object var9_9 = null;
            try {
                if (oOutput != null) {
                    oOutput.close();
                }
                Log.write(6, "File handle closed after save.");
            }
            catch (IOException aoCloseException) {
                Log.write(2, (Throwable)aoCloseException);
            }
            break block11;
            {
                catch (IOException aoException) {
                    Log.write("failed.");
                    throw new ResourceException(aoResource, (Throwable)aoException);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (oOutput != null) {
                        oOutput.close();
                    }
                    Log.write(6, "File handle closed after save.");
                }
                catch (IOException aoCloseException) {
                    Log.write(2, (Throwable)aoCloseException);
                }
                throw throwable;
            }
        }
        this.updateInformation(aoResource);
        aoResource.setModifiedFlagEnabled(true);
        aoResource.setModified(false);
        Log.write("successful.");
    }

    public synchronized void close(Resource aoResource) throws ResourceException {
        aoResource.set("resource.data.buffer", null);
    }

    public synchronized void saveAs(Resource aoResource, Resource aoDestination) throws ResourceException {
        aoResource.setResource(CACHE_FILE, null);
        super.saveAs(aoResource, aoDestination);
    }

    public synchronized boolean rename(Resource aoResource, Resource aoDestination) throws ResourceException {
        aoResource.setResource("resource.uri", aoDestination.getResource("resource.uri"));
        try {
            return this.getFile(aoResource).renameTo(this.getFile(aoDestination));
        }
        catch (Exception aoException) {
            throw new ResourceException(aoResource, (Throwable)aoException);
        }
    }

    public boolean exists(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        return oFile.exists();
    }

    public synchronized boolean delete(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        try {
            return oFile.delete();
        }
        catch (SecurityException aoException) {
            throw new ResourceException(aoResource, (Throwable)aoException);
        }
    }

    public boolean isReadable(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        return oFile.canRead();
    }

    public boolean isWritable(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        return this.moFileSystemView.isFloppyDrive(oFile) ? true : oFile.canWrite();
    }

    public boolean isContainer(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        if (oFile.getParentFile() == null) {
            return true;
        }
        return oFile.isDirectory();
    }

    public synchronized Resource[] listResources(Resource aoResource) throws ResourceException {
        if (!this.isContainer(aoResource)) {
            return null;
        }
        File oFile = this.getFile(aoResource);
        Object[] aChildrenFiles = oFile.listFiles();
        if (aChildrenFiles == null) {
            return null;
        }
        Resource[] aChildrenResources = ResourceFactory.createResources(aChildrenFiles);
        return aChildrenResources;
    }

    public long getLastModified(Resource aoResource) throws ResourceException {
        File oFile = this.getFile(aoResource);
        if (this.isContainer(aoResource) || this.moFileSystemView.isDrive(oFile)) {
            throw new ResourceException(aoResource, "Containers have no modified date.");
        }
        return oFile.lastModified();
    }

    private File getFile(Resource aoResource) {
        File oFile = (File)aoResource.getResource(CACHE_FILE);
        if (oFile == null) {
            oFile = new File(aoResource.getUri());
            if (!this.moFileSystemView.isDrive(oFile)) {
                File oCanonicalFile = null;
                try {
                    oCanonicalFile = oFile.getCanonicalFile();
                }
                catch (IOException aoException) {
                    Log.write(3, (Throwable)aoException);
                    return null;
                }
                oFile = oCanonicalFile;
            }
            aoResource.setResource(CACHE_FILE, oFile);
        }
        return oFile;
    }

    private void updateInformation(Resource aoResource) {
        File oFile = this.getFile(aoResource);
        String sName = "";
        String sIcon = "";
        String sDescription = "";
        String sSize = "";
        String sModifiedDate = "";
        Icon oIcon = IconCache.getIcon("null");
        if (oFile.getParentFile() == null) {
            if (this.moFileSystemView.isFloppyDrive(oFile)) {
                sName = oFile.toString();
                sIcon = "disk";
            } else {
                sName = oFile.toString();
                sIcon = "filesystem";
                sDescription = this.moFileSystemView.getSystemDisplayName(oFile);
            }
            oIcon = IconCache.getIcon(sIcon);
        } else {
            sName = oFile.getName();
            String sResourceType = aoResource.getType();
            if (sResourceType == null) {
                sResourceType = Utilities.getFileExtension(this.getFile(aoResource));
            }
            String string = sIcon = sResourceType == null ? null : (String)this.mhFileIcons.get(sResourceType);
            if (sIcon == null) {
                sIcon = oFile.isFile() ? "file" : "folder";
            }
            String string2 = sSize = oFile.isFile() ? String.valueOf(oFile.length()) : null;
            if (oFile.exists()) {
                sDescription = this.moFileSystemView.getSystemTypeDescription(oFile);
                sModifiedDate = this.moDateFormat.format(new Date(oFile.lastModified()));
            }
        }
        aoResource.setResource("resource.icon", sIcon);
        aoResource.setResource("resource.name", sName);
        aoResource.setResource("resource.desc", sDescription);
        aoResource.setResource("display.size", sSize);
        aoResource.setResource("display.modified", sModifiedDate);
    }

    private String getFirstLine(String asBuffer) throws IOException {
        return this.getFirstLine(new StringReader(asBuffer));
    }

    private String getFirstLine(Reader aoReader) throws IOException {
        if (aoReader == null) {
            return null;
        }
        int iLength = 0;
        StringBuffer oBuffer = new StringBuffer();
        int iChar = aoReader.read();
        while (iChar >= 0 & (iChar == 10 || iChar == 13)) {
            iChar = aoReader.read();
        }
        while (iChar >= 0 & iLength < 256 & (iChar != 10 & iChar != 13)) {
            oBuffer.append((char)iChar);
            ++iLength;
            iChar = aoReader.read();
        }
        return oBuffer.toString();
    }

    private String getContentType(String asFileName) {
        Syntax[] aSyntaxes = SyntaxFactory.getSyntaxes();
        for (int iIndex = 0; iIndex < aSyntaxes.length; ++iIndex) {
            Syntax oSyntax = aSyntaxes[iIndex];
            if (!oSyntax.accept(asFileName, null)) continue;
            return oSyntax.getName();
        }
        return null;
    }

    private String getContentType(String asFileName, String asFirstLine) {
        Syntax[] aSyntaxes = SyntaxFactory.getSyntaxes();
        for (int iIndex = 0; iIndex < aSyntaxes.length; ++iIndex) {
            Syntax oSyntax = aSyntaxes[iIndex];
            if (!oSyntax.accept(asFileName, asFirstLine)) continue;
            return oSyntax.getName();
        }
        return null;
    }

    public String getResourceType(Resource aoResource) {
        try {
            if (this.isContainer(aoResource)) {
                return null;
            }
        }
        catch (ResourceException aoException) {
            return null;
        }
        String sResourceType = null;
        File oFile = this.getFile(aoResource);
        String sFileName = oFile.getName();
        sResourceType = this.getContentType(sFileName);
        if (sResourceType == null) {
            String sFirstLine = (String)aoResource.getResource("resource.first.line");
            if (sFirstLine == null && oFile.exists()) {
                try {
                    FileInputStream oInput = new FileInputStream(oFile);
                    sFirstLine = this.getFirstLine(new InputStreamReader(oInput));
                    aoResource.setResource("resource.first.line", sFirstLine);
                }
                catch (IOException aoException) {
                    Log.write(aoException);
                }
            }
            sResourceType = this.getContentType(sFileName, sFirstLine);
        }
        return sResourceType;
    }

    public String toString(Resource aoResource) {
        return this.getFile(aoResource).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

