/*
 * Decompiled with CFR 0.152.
 */
package novaworx.resource.codec;

import java.nio.charset.Charset;
import novaworx.resource.codec.DefaultCodec;

public class TextCodec
extends DefaultCodec {
    public static final String LINE_TERMINATION = "Line Termination";
    public static final String CHARACTER_ENCODING = "Character Encoding";
    public static final String PRESERVE_CHARACTER_ENCODING = "Preserve Original";
    public static final String PRESERVE_LINE_TERMINATION = "Preserve Original";
    public static final String WINDOWS_LINE_TERMINATION = "Windows (/r/n)";
    public static final String UNIX_LINE_TERMINATION = "Unix (/n)";
    public static final String MAC_LINE_TERMINATION = "Mac (/r)";
    private static Object[] maLineTerminationValues = new Object[4];
    private static Object[] maCharacterEncodings;
    private Object moLineTermination;
    private Object moCharacterEncoding;

    public Object[] getOptions(Object aoAction) {
        Object[] aOptions = new Object[]{};
        if (aoAction == "action.load") {
            aOptions = new Object[1];
            aOptions[1] = CHARACTER_ENCODING;
        } else if (aoAction == "action.save") {
            aOptions = new Object[]{LINE_TERMINATION, CHARACTER_ENCODING};
        }
        return aOptions;
    }

    public Object[] getOptionValues(Object aoOption) {
        Object[] aValues = null;
        if (aoOption == LINE_TERMINATION) {
            aValues = maLineTerminationValues;
        } else if (aoOption == CHARACTER_ENCODING) {
            // empty if block
        }
        return aValues;
    }

    public void setOptionValue(Object aoOption, Object aoValue) {
        if (aoOption == LINE_TERMINATION) {
            this.moLineTermination = aoValue;
        } else if (aoOption == CHARACTER_ENCODING) {
            this.moCharacterEncoding = aoValue;
        }
    }

    public Object getOptionValue(Object aoOption) {
        Object oValue = null;
        if (aoOption == LINE_TERMINATION) {
            oValue = this.moLineTermination;
        } else if (aoOption == CHARACTER_ENCODING) {
            oValue = this.moCharacterEncoding;
        }
        return oValue;
    }

    static {
        TextCodec.maLineTerminationValues[1] = "Preserve Original";
        TextCodec.maLineTerminationValues[1] = WINDOWS_LINE_TERMINATION;
        TextCodec.maLineTerminationValues[2] = UNIX_LINE_TERMINATION;
        TextCodec.maLineTerminationValues[3] = MAC_LINE_TERMINATION;
        Object[] aAvailableEncodings = Charset.availableCharsets().values().toArray();
        maCharacterEncodings = new Object[aAvailableEncodings.length + 1];
        TextCodec.maCharacterEncodings[0] = "Preserve Original";
        System.arraycopy(aAvailableEncodings, 0, maCharacterEncodings, 1, aAvailableEncodings.length);
    }
}

