/*
 * Decompiled with CFR 0.152.
 */
package novaworx.resource;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.filechooser.FileSystemView;
import novaworx.ResourceEngine;
import novaworx.log.Log;
import novaworx.resource.Resource;
import novaworx.resource.ResourceScheme;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class ResourceFactory {
    private static ResourceLinkHandler moResourceLinkHandler = new ResourceLinkHandler();
    private static FileSystemView moFileSystemView = FileSystemView.getFileSystemView();

    private ResourceFactory() {
    }

    private static Resource createResource(Object aoSource) {
        if (aoSource == null) {
            return null;
        }
        Resource oResource = null;
        oResource = aoSource instanceof String ? ResourceFactory.createResourceFromUri(ResourceFactory.createUriFromString((String)aoSource)) : (aoSource instanceof URI ? ResourceFactory.createResourceFromUri((URI)aoSource) : ResourceFactory.createResourceFromObject(aoSource));
        if (oResource == null) {
            return null;
        }
        Resource oOpenResource = ResourceEngine.get().getResource(oResource.getUri());
        if (oOpenResource != null) {
            return oOpenResource;
        }
        return oResource;
    }

    public static Resource[] createResources(Object[] aaSources) {
        Resource[] aResources = new Resource[aaSources.length];
        for (int iIndex = 0; iIndex < aaSources.length; ++iIndex) {
            aResources[iIndex] = ResourceFactory.createResource(aaSources[iIndex]);
        }
        return aResources;
    }

    private static Resource createResourceFromUri(Object aoSource) {
        if (aoSource == null) {
            return null;
        }
        if (aoSource == null) {
            return null;
        }
        Resource oResource = null;
        URI oURI = (URI)aoSource;
        oResource = new Resource(oURI);
        return oResource;
    }

    private static Resource createResourceFromObject(Object aoSource) {
        if (aoSource == null) {
            return null;
        }
        Resource oResource = null;
        ResourceScheme oScheme = null;
        Class<?> oSourceClass = aoSource.getClass();
        while (oSourceClass != null & oScheme == null) {
            oScheme = Resource.getSchemeByClass(oSourceClass);
            oSourceClass = oSourceClass.getSuperclass();
        }
        if (oScheme != null) {
            oResource = oScheme.createResource(aoSource);
        } else {
            Log.write(3, "Could not generate resource source: " + aoSource.toString());
        }
        return oResource;
    }

    public static URI createUriFromString(String asSource) {
        if (asSource == null) {
            return null;
        }
        String sSource = asSource.trim();
        if (sSource.length() == 0) {
            return null;
        }
        if (sSource.length() == 2 && sSource.charAt(1) == ':') {
            sSource = sSource + "/";
        }
        sSource = sSource.replace('\\', '/');
        if ((sSource = sSource.replaceAll(" ", "%20")).length() > 1 && sSource.charAt(1) == ':') {
            sSource = "/" + sSource;
        }
        if (sSource.length() > 0 && sSource.charAt(0) == '/') {
            sSource = "file:" + sSource;
        }
        URI oURI = null;
        try {
            oURI = new URI(sSource);
        }
        catch (URISyntaxException aoException) {
            Log.write(3, (Throwable)aoException);
            return null;
        }
        Log.write(6, "Generated URI: " + oURI.toString());
        return oURI;
    }

    public static String createResourceLinkData(Resource aoResource) {
        ByteArrayOutputStream oOutput = new ByteArrayOutputStream();
        OutputStreamWriter oStreamWriter = null;
        try {
            oStreamWriter = new OutputStreamWriter((OutputStream)oOutput, "UTF-8");
        }
        catch (UnsupportedEncodingException aoException) {
            Log.write(2, (Throwable)aoException);
            return null;
        }
        PrintWriter oWriter = new PrintWriter(oStreamWriter);
        String sIcon = (String)aoResource.getResource("display.icon.name");
        String sName = (String)aoResource.getResource("display.name");
        String sURI = ((URI)aoResource.getResource("uri")).toString();
        oWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        oWriter.println("");
        oWriter.println("<!DOCTYPE resourcelink SYSTEM \"resourcelink.dtd\">");
        oWriter.println("");
        oWriter.println("<resourcelink>");
        oWriter.print("\t<attribute name=\"name\" value=\"");
        oWriter.print(sName);
        oWriter.println("\"/>");
        oWriter.print("\t<attribute name=\"icon\" value=\"");
        oWriter.print(sIcon);
        oWriter.println("\"/>");
        oWriter.print("\t<attribute name=\"uri\" value=\"");
        oWriter.print(sURI);
        oWriter.println("\"/>");
        oWriter.println("</resourcelink>");
        oWriter.close();
        return new String(oOutput.toByteArray());
    }

    private static class ResourceLinkHandler
    extends DefaultHandler {
        private String msURI;
        private String msName;
        private String msIcon;

        public InputSource resolveEntity(String asPublicID, String asSystemID) {
            String sDTD = "resourcelink.dtd";
            if (asSystemID != null && asSystemID.endsWith(sDTD)) {
                try {
                    return new InputSource(this.getClass().getResourceAsStream(sDTD));
                }
                catch (Exception aoException) {
                    Log.write(2, "Error while loading DTD: " + sDTD);
                    Log.write(2, (Throwable)aoException);
                }
            }
            return null;
        }

        public void doctypeDecl(String asName, String asPublicID, String asSystemID) throws Exception {
            if ("resourcelink".equals(asName)) {
                return;
            }
            Log.write(2, "Loading catalog: DOCTYPE must be 'resourcelink'.");
        }

        public void startElement(String asNamespace, String asLocalName, String asQualifiedName, Attributes aoAttributes) {
            String sName = aoAttributes.getValue("name");
            String sValue = aoAttributes.getValue("value");
            if ("uri".equals(sName)) {
                this.msURI = sValue;
            }
            if ("name".equals(sName)) {
                this.msName = sValue;
            }
            if ("icon".equals(sName)) {
                this.msIcon = sValue;
            }
        }

        public void endElement(String asNamespace, String asLocalName, String asQualifiedName) {
        }

        public String getUri() {
            return this.msURI;
        }

        public String getIcon() {
            return this.msIcon;
        }

        public String getName() {
            return this.msName;
        }
    }
}

