/*
 * Decompiled with CFR 0.152.
 */
package novaworx.resource;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import novaworx.ResourceEngine;
import novaworx.data.DataNode;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import novaworx.resource.ResourceCodec;
import novaworx.resource.ResourceEvent;
import novaworx.resource.ResourceException;
import novaworx.resource.ResourceListener;
import novaworx.resource.ResourceScheme;
import novaworx.resource.ResourceUndoManager;
import novaworx.resource.codec.DefaultCodec;
import novaworx.resource.scheme.DefaultScheme;
import novaworx.resource.scheme.FileScheme;
import novaworx.resource.scheme.NewScheme;
import novaworx.resource.scheme.RootScheme;

public final class Resource
extends DataNode {
    public static final int FIRST_LINE_LIMIT = 256;
    public static final String URI = "resource.uri";
    public static final String TYPE = "resource.type";
    public static final String ICON = "resource.icon";
    public static final String NAME = "resource.name";
    public static final String DESC = "resource.desc";
    public static final String CODEC = "resource.codec";
    public static final String SCHEME = "resource.scheme";
    public static final String SOURCE = "resource.source";
    public static final String MIME_TYPE = "resource.mime.type";
    public static final String OPEN_DATE = "resource.date.open";
    public static final String LOAD_DATE = "resource.date.load";
    public static final String SAVE_DATE = "resource.date.save";
    public static final String CONTENT_SIZE = "resource.content.size";
    public static final String READABLE_FLAG = "resource.flag.readable";
    public static final String WRITABLE_FLAG = "resource.flag.writable";
    public static final String DATA_BUFFER = "resource.data.buffer";
    public static final String FIRST_LINE = "resource.first.line";
    public static final String OUTLINE_MODEL = "resource.outline.model";
    public static final String UNDO_MANAGER = "resource.undo.manager";
    private static Hashtable mhSchemes;
    private static Hashtable mhGenerators;
    private static ResourceScheme moDefaultScheme;
    private boolean mbOpen;
    private boolean mbLoaded;
    private boolean mbSaved;
    private ResourceCodec moCodec;
    private ResourceScheme moScheme;
    private ResourceMonitor moMonitor;
    private static Timer moMonitorTimer;
    private ArrayList moResourceListeners;

    public Resource(URI aoURI) {
        if (aoURI == null) {
            throw new IllegalArgumentException("Resource URI can not be null.");
        }
        this.setResource(URI, aoURI);
        this.setResource(UNDO_MANAGER, new ResourceUndoManager());
        this.moResourceListeners = new ArrayList();
    }

    public URI getUri() {
        return (URI)this.getResource(URI);
    }

    public String getType() {
        return (String)this.getResource(TYPE);
    }

    public String getIcon() {
        return (String)this.getResource(ICON);
    }

    public String getName() {
        return (String)this.getResource(NAME);
    }

    public ResourceCodec getCodec() {
        return this.moCodec;
    }

    public ResourceScheme getScheme() {
        return this.moScheme;
    }

    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        this.moScheme.open(this);
        this.mbOpen = true;
        this.setResource(OPEN_DATE, new Date());
        if (this.moMonitor == null) {
            this.moMonitor = new ResourceMonitor();
            moMonitorTimer.schedule((TimerTask)this.moMonitor, 0L, 1000L);
        }
        this.triggerResourceOpened();
    }

    public void load() throws ResourceException {
        this.mbLoaded = false;
        this.moScheme.load(this);
        this.mbLoaded = true;
        this.setResource(LOAD_DATE, new Date());
        this.setResource(SAVE_DATE, new Date(this.getLastModified()));
        this.setResource(CONTENT_SIZE, new Long(this.getSize()));
        this.triggerResourceLoaded();
    }

    public void save() throws ResourceException {
        this.mbSaved = false;
        this.moScheme.save(this);
        this.mbSaved = true;
        this.setResource(SAVE_DATE, new Date(this.getLastModified()));
        this.setResource(CONTENT_SIZE, new Long(this.getSize()));
        this.triggerResourceSaved();
    }

    public void close() throws ResourceException {
        if (!this.isOpen()) {
            return;
        }
        this.moMonitor.cancel();
        this.moMonitor = null;
        this.mbLoaded = false;
        this.mbSaved = false;
        this.mbOpen = false;
        this.setModifiedFlagEnabled(true);
        this.setModified(false);
        this.setModifiedFlagEnabled(false);
        this.moScheme.close(this);
        this.triggerResourceClosed();
    }

    public boolean exists() throws ResourceException {
        return this.moScheme.exists(this);
    }

    public boolean create() throws ResourceException {
        return this.moScheme.create(this);
    }

    public void saveAs(Resource aoResource) throws ResourceException {
        this.moScheme.saveAs(this, aoResource);
        this.setResource(SAVE_DATE, new Date(this.getLastModified()));
        this.setResource(CONTENT_SIZE, new Long(this.getSize()));
        this.triggerResourceSaved();
        this.triggerNodeChanged();
    }

    public boolean rename(Resource aoResource) throws ResourceException {
        boolean bResult = this.moScheme.rename(this, aoResource);
        if (bResult) {
            this.triggerNodeChanged();
        }
        return bResult;
    }

    public boolean delete() throws ResourceException {
        boolean bResult = this.moScheme.delete(this);
        if (bResult) {
            this.triggerNodeChanged();
        }
        return bResult;
    }

    public boolean isOpen() {
        return this.mbOpen;
    }

    public boolean isLoaded() {
        return this.mbLoaded;
    }

    public boolean isSaved() {
        return this.mbSaved;
    }

    public boolean isReadable() throws ResourceException {
        return this.moScheme.isReadable(this);
    }

    public boolean isWritable() throws ResourceException {
        return this.moScheme.isWritable(this);
    }

    public boolean isContainer() throws ResourceException {
        return this.moScheme.isContainer(this);
    }

    public Resource[] listResources() throws ResourceException {
        return this.moScheme.listResources(this);
    }

    public long getLastModified() throws ResourceException {
        return this.moScheme.getLastModified(this);
    }

    public long getSize() throws ResourceException {
        return this.moScheme.getSize(this);
    }

    public void updateCodec() {
        DefaultCodec oCodec = null;
        if (oCodec == null) {
            oCodec = new DefaultCodec();
        }
        this.setResource(CODEC, oCodec);
    }

    private void updateScheme() {
        String sScheme = this.getUri().getScheme();
        Log.write(6, "Resource scheme: " + sScheme + " : " + this.toString());
        if (sScheme != null) {
            ResourceScheme oScheme = (ResourceScheme)mhSchemes.get(sScheme);
            if (oScheme == null) {
                Log.write(3, "Unsupported resource scheme: " + sScheme);
                oScheme = moDefaultScheme;
            }
            Log.write(6, "Using resource scheme: " + oScheme.getSchemeName());
            this.setResource(TYPE, oScheme.getResourceType(this));
            this.setResource(SCHEME, oScheme);
        } else {
            Log.write(2, "Resource scheme not assigned: " + this.toString());
        }
    }

    private String getFirstLine(String asBuffer) throws IOException {
        return this.getFirstLine(new StringReader(asBuffer));
    }

    private String getFirstLine(Reader aoReader) throws IOException {
        if (aoReader == null) {
            return null;
        }
        int iLength = 0;
        StringBuffer oBuffer = new StringBuffer();
        int iChar = aoReader.read();
        while (iChar >= 0 & (iChar == 10 || iChar == 13)) {
            iChar = aoReader.read();
        }
        while (iChar >= 0 & iLength < 256 & (iChar != 10 & iChar != 13)) {
            oBuffer.append((char)iChar);
            ++iLength;
            iChar = aoReader.read();
        }
        return oBuffer.toString();
    }

    public void addResourceListener(ResourceListener aoListener) {
        this.addNodeListener(aoListener);
        this.moResourceListeners.add(aoListener);
    }

    public void removeResourceListener(ResourceListener aoListener) {
        this.moResourceListeners.remove(aoListener);
        this.removeNodeListener(aoListener);
    }

    public List getResourceListeners() {
        return Collections.unmodifiableList((List)this.moResourceListeners.clone());
    }

    protected void triggerNodeChanged() {
        super.triggerNodeChanged();
    }

    protected void triggerModifiedStateChanged(boolean abModified) {
        super.triggerModifiedStateChanged(abModified);
        if (abModified) {
            this.triggerResourceModified();
        } else {
            this.triggerResourceUnmodified();
        }
    }

    protected void triggerResourceActivated() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceActivated(aoEvent);
    }

    protected void triggerResourceDeactivated() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceDeactivated(aoEvent);
    }

    protected void triggerResourceModified() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceModified(aoEvent);
    }

    protected void triggerResourceUnmodified() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceUnmodified(aoEvent);
    }

    protected void triggerResourceOpened() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceOpened(aoEvent);
    }

    protected void triggerResourceLoaded() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceLoaded(aoEvent);
    }

    protected void triggerResourceChanged(int aiChangeFlags) {
        this.triggerNodeChanged();
        ResourceEvent aoEvent = new ResourceEvent(this, aiChangeFlags);
        this.fireResourceChanged(aoEvent);
    }

    protected void triggerResourceSaved() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceSaved(aoEvent);
    }

    protected void triggerResourceClosed() {
        ResourceEvent aoEvent = new ResourceEvent(this);
        this.fireResourceClosed(aoEvent);
    }

    void fireResourceActivated(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceActivated(aoEvent);
        }
    }

    void fireResourceDeactivated(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceDeactivated(aoEvent);
        }
    }

    void fireResourceModified(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceModified(aoEvent);
        }
    }

    void fireResourceUnmodified(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceUnmodified(aoEvent);
        }
    }

    void fireResourceOpened(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceOpened(aoEvent);
        }
    }

    void fireResourceLoaded(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceLoaded(aoEvent);
        }
    }

    protected void fireResourceChanged(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceChanged(aoEvent);
        }
    }

    void fireResourceSaved(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceSaved(aoEvent);
        }
    }

    void fireResourceClosed(ResourceEvent aoEvent) {
        if (this.moResourceListeners == null) {
            return;
        }
        List oListeners = (List)this.moResourceListeners.clone();
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ResourceListener)oListeners.get(iIndex)).resourceClosed(aoEvent);
        }
    }

    public void setResource(String asKey, Object aoValue) {
        super.setResource(asKey, aoValue);
        if (URI.equals(asKey)) {
            this.updateScheme();
            this.updateCodec();
        } else if (CODEC.equals(asKey)) {
            this.moCodec = (ResourceCodec)aoValue;
        } else if (SCHEME.equals(asKey)) {
            this.moScheme = (ResourceScheme)aoValue;
            this.moScheme.init(this);
        }
    }

    public Object getResource(String asKey) {
        if ("display.icon".equals(asKey)) {
            return IconCache.getIcon(this.getIcon());
        }
        if ("display.name".equals(asKey)) {
            return this.getName();
        }
        if ("display.foreground".equals(asKey)) {
            try {
                if (this.isWritable()) {
                    return this.moScheme != null && this.isModified() ? ResourceEngine.getModifiedResourceForeground() : null;
                }
                return ResourceEngine.getNotWritableResourceForeground();
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        } else if ("display.background".equals(asKey)) {
            try {
                if (this.isWritable()) {
                    return this.moScheme != null && this.isModified() ? ResourceEngine.getModifiedResourceBackground() : null;
                }
                return ResourceEngine.getNotWritableResourceBackground();
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        } else if ("display.selected.foreground".equals(asKey)) {
            try {
                if (this.isWritable()) {
                    return this.moScheme != null && this.isModified() ? ResourceEngine.getModifiedResourceSelectedForeground() : null;
                }
                return ResourceEngine.getNotWritableResourceSelectedForeground();
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        } else if ("display.selected.background".equals(asKey)) {
            try {
                if (this.isWritable()) {
                    return this.moScheme != null && this.isModified() ? ResourceEngine.getModifiedResourceSelectedBackground() : null;
                }
                return ResourceEngine.getNotWritableResourceSelectedBackground();
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
        return super.getResource(asKey);
    }

    public String toString() {
        String sString = null;
        if (sString == null) {
            String string = sString = this.moScheme == null ? null : this.moScheme.toString(this);
        }
        if (sString == null) {
            try {
                sString = URLDecoder.decode(this.getUri().toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException aoException) {
                Log.write(3, (Throwable)aoException);
            }
        }
        return sString;
    }

    public boolean equals(Object aoObject) {
        Resource oResource;
        if (aoObject == null || !(aoObject instanceof Resource)) {
            return false;
        }
        URI oURI = this.getUri();
        return oURI.equals((oResource = (Resource)aoObject).getUri());
    }

    public void finalize() {
        this.moMonitor.cancel();
    }

    public static void addScheme(ResourceScheme aoScheme) {
        String sName = aoScheme.getSchemeName();
        if (sName == null) {
            throw new IllegalArgumentException("ResourceScheme name cannot be null: " + aoScheme.getClass().getName());
        }
        mhSchemes.put(sName, aoScheme);
        Class oClass = aoScheme.getSchemeClass();
        if (oClass != null) {
            mhGenerators.put(oClass, aoScheme);
        }
    }

    public static void removeScheme(ResourceScheme aoScheme) {
        String sName = aoScheme.getSchemeName();
        Class oClass = aoScheme.getSchemeClass();
        if (sName != null) {
            mhSchemes.remove(sName);
        }
        if (oClass != null) {
            mhGenerators.remove(oClass);
        }
    }

    public static ResourceScheme getSchemeByName(String asName) {
        return (ResourceScheme)mhSchemes.get(asName);
    }

    public static ResourceScheme getSchemeByClass(Class aoClass) {
        return (ResourceScheme)mhGenerators.get(aoClass);
    }

    static {
        moDefaultScheme = DefaultScheme.getInstance();
        mhSchemes = new Hashtable();
        mhGenerators = new Hashtable();
        Resource.addScheme(RootScheme.getInstance());
        Resource.addScheme(NewScheme.getInstance());
        Resource.addScheme(FileScheme.getInstance());
        moMonitorTimer = new Timer(true);
    }

    private class ResourceMonitor
    extends TimerTask {
        private boolean mbWorking;

        private ResourceMonitor() {
        }

        public void run() {
            if (this.mbWorking) {
                return;
            }
            this.mbWorking = true;
            int iChangeFlags = 0;
            boolean bDateChanged = this.dateChanged();
            boolean bSizeChanged = this.sizeChanged();
            boolean bReadableFlagChanged = this.readableFlagChanged();
            boolean bWritableFlagChanged = this.writableFlagChanged();
            if (bDateChanged) {
                iChangeFlags |= 1;
            }
            if (bSizeChanged) {
                iChangeFlags |= 2;
            }
            if (bReadableFlagChanged) {
                iChangeFlags |= 4;
            }
            if (bWritableFlagChanged) {
                iChangeFlags |= 8;
            }
            if (iChangeFlags != 0) {
                Log.write(1, "Resource changed externally: " + Resource.this.getName());
                Resource.this.triggerResourceChanged(iChangeFlags);
            }
            this.mbWorking = false;
        }

        private boolean sizeChanged() {
            long lSize = 0L;
            boolean bResult = false;
            Long oSize = (Long)Resource.this.getResource(Resource.CONTENT_SIZE);
            try {
                lSize = Resource.this.getSize();
                if (oSize != null && lSize != oSize) {
                    bResult = true;
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
                return false;
            }
            Resource.this.setResource(Resource.CONTENT_SIZE, new Long(lSize));
            return bResult;
        }

        private boolean dateChanged() {
            long lDate = 0L;
            boolean bResult = false;
            Date oDate = (Date)Resource.this.getResource(Resource.SAVE_DATE);
            try {
                lDate = Resource.this.getLastModified();
                if (oDate != null && lDate != oDate.getTime()) {
                    bResult = true;
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
                return false;
            }
            Resource.this.setResource(Resource.SAVE_DATE, new Date(lDate));
            return bResult;
        }

        private boolean readableFlagChanged() {
            boolean bResult = false;
            boolean bReadable = false;
            Boolean oReadable = (Boolean)Resource.this.getResource(Resource.READABLE_FLAG);
            try {
                bReadable = Resource.this.isReadable();
                if (oReadable != null && bReadable != oReadable) {
                    bResult = true;
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
                return false;
            }
            Resource.this.setResource(Resource.READABLE_FLAG, bReadable ? Boolean.TRUE : Boolean.FALSE);
            return bResult;
        }

        private boolean writableFlagChanged() {
            boolean bResult = false;
            boolean bWritable = false;
            Boolean oWritable = (Boolean)Resource.this.getResource(Resource.WRITABLE_FLAG);
            try {
                bWritable = Resource.this.isWritable();
                if (oWritable != null && bWritable != oWritable) {
                    bResult = true;
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
                return false;
            }
            Resource.this.setResource(Resource.WRITABLE_FLAG, bWritable ? Boolean.TRUE : Boolean.FALSE);
            return bResult;
        }
    }
}

