/*
 * Decompiled with CFR 0.152.
 */
package novaworx.resource;

import novaworx.log.Log;
import novaworx.resource.Resource;
import novaworx.resource.ResourceComparator;
import novaworx.resource.ResourceException;

public class DefaultResourceComparator
implements ResourceComparator {
    private boolean mbCaseSensitive = true;
    private boolean mbContainersFirst = true;

    public void setCaseSensitive(boolean abCaseSensitive) {
        this.mbCaseSensitive = abCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.mbCaseSensitive;
    }

    public void setContainersFirst(boolean abContainersFirst) {
        this.mbContainersFirst = abContainersFirst;
    }

    public boolean isContainersFirst() {
        return this.mbContainersFirst;
    }

    public String getDescription() {
        return "Standard Comparator";
    }

    public int compare(Resource aoResource1, Resource aoResource2) {
        try {
            if (aoResource1.isContainer() & !aoResource2.isContainer() & this.mbContainersFirst) {
                return -1;
            }
            if (!aoResource1.isContainer() & aoResource2.isContainer() & this.mbContainersFirst) {
                return 1;
            }
        }
        catch (ResourceException aoException) {
            Log.write(2, (Throwable)aoException);
            return 0;
        }
        String sName1 = aoResource1.getName();
        String sName2 = aoResource2.getName();
        if (sName1 == null & sName2 == null) {
            return 0;
        }
        if (sName1 == null & sName2 != null) {
            return -1;
        }
        if (sName1 != null & sName2 == null) {
            return 1;
        }
        if (this.mbCaseSensitive) {
            return sName1.compareTo(sName2);
        }
        return sName1.compareToIgnoreCase(sName2);
    }
}

