/*
 * Decompiled with CFR 0.152.
 */
package novaworx.plaf.novaworx;

import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import novaworx.plaf.novaworx.GradientTheme;
import novaworx.plaf.novaworx.NovaworxGradientTheme;
import novaworx.plaf.novaworx.NovaworxTheme;
import novaworx.plaf.novaworx.NovaworxUtilities;

public class NovaworxLookAndFeel
extends MetalLookAndFeel {
    private static GradientTheme gradientTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    public NovaworxLookAndFeel() {
        if (!isInstalled) {
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("Novaworx", "novaworx.plaf.novaworx.NovaworxLookAndFeel"));
            isInstalled = true;
        }
    }

    public String getID() {
        return "Novaworx";
    }

    public String getName() {
        return "Novaworx";
    }

    public String getDescription() {
        return "Look and Feel giving a plastic effect. Developed by INCORS GmbH, 2001and contributors. Published under the Lesser GNU Public Licence.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "ComboBoxUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TextFieldUI");
        this.putDefault(table, "PasswordFieldUI");
        this.putDefault(table, "ListUI");
        this.putDefault(table, "TreeUI");
        this.putDefault(table, "ToolBarUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "MenuUI");
        this.putDefault(table, "ScrollBarUI");
        this.putDefault(table, "ProgressBarUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "InternalFrameUI");
    }

    protected void putDefault(UIDefaults table, String uiKey) {
        try {
            String className = "novaworx.plaf.novaworx.Novaworx" + uiKey;
            table.put(uiKey, className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            NovaworxLookAndFeel.setCurrentTheme(new NovaworxTheme());
        }
        if (gradientTheme == null) {
            gradientTheme = new NovaworxGradientTheme();
        }
    }

    public static void setCurrentGradientTheme(GradientTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Gradient Theme cannot have null value");
        }
        gradientTheme = theme;
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", NovaworxUtilities.getTranslucentColorUIResource(NovaworxLookAndFeel.getTextHighlightColor(), 128));
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
    }

    public static ColorUIResource getComponentGradientColorReflection() {
        return gradientTheme.getComponentGradientColorReflection();
    }

    public static ColorUIResource getComponentGradientColorShadow() {
        return gradientTheme.getComponentGradientColorShadow();
    }

    public static ColorUIResource getTextComponentGradientColorReflection() {
        return gradientTheme.getTextComponentGradientColorReflection();
    }

    public static ColorUIResource getTextComponentGradientColorShadow() {
        return gradientTheme.getTextComponentGradientColorShadow();
    }

    public static int getBackgroundGradientShadow() {
        return gradientTheme.getBackgroundGradientShadow();
    }

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }
}

