/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import novaworx.log.AbstractLogger;
import novaworx.log.Log;

public class SocketLogger
extends AbstractLogger {
    Socket moSocket;
    PrintStream moStream;
    protected boolean mbPartialFlag;

    public SocketLogger(Socket aoSocket) throws IOException {
        this.moSocket = aoSocket;
        this.moStream = new PrintStream(this.moSocket.getOutputStream(), true);
    }

    public void writeBlank() {
        this.moStream.println("");
        this.checkStream();
    }

    public void writeTimestamp() {
        Date oNow = new Date();
        this.moStream.println(oNow.toString());
        this.checkStream();
    }

    public void writeHeader(Object aoSource, String asMode, int aiLevel) {
        String sHeader = this.createHeader(aoSource, asMode, aiLevel);
        this.moStream.println(sHeader);
        this.checkStream();
    }

    public void write(Object aoSource, String asMode, int aiLevel, String asMessage, boolean abPartial) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        if (abPartial) {
            if (this.mbPartialFlag) {
                this.moStream.print(asMessage);
            } else {
                this.moStream.print(this.format(aoSource, asMode, aiLevel, asMessage));
            }
            this.mbPartialFlag = true;
        } else {
            this.moStream.println(this.format(aoSource, asMode, aiLevel, asMessage));
            this.mbPartialFlag = false;
        }
        this.checkStream();
    }

    public void write(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        this.moStream.println(this.format(aoSource, asMode, aiLevel, aoThrowable));
        this.checkStream();
    }

    private void checkStream() {
        if (!this.moStream.checkError()) {
            return;
        }
        try {
            this.moSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Log.removeLogger(this);
    }
}

