/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.util.Date;
import novaworx.log.LogSettings;

public final class LogEntry
implements LogSettings {
    public static final int BLANK_ENTRY = 0;
    public static final int MESSAGE_ENTRY = 1;
    public static final int THROWABLE_ENTRY = 2;
    public static final int TIMESTAMP_ENTRY = 3;
    public static final int HEADER_ENTRY = 4;
    public static final int PARTIAL_ENTRY = 5;
    private int miType;
    private Date moTimestamp;
    private Object moSource;
    private String msMode;
    private int miLevel;
    private String msMessage;
    private Throwable moThrowable;

    private LogEntry() {
        this.miType = 0;
        this.moTimestamp = new Date();
    }

    private LogEntry(int aiType) {
        this.miType = aiType;
        this.moTimestamp = new Date();
    }

    private LogEntry(Object aoSource, String asMode, int aiLevel) {
        this.miType = 4;
        this.moTimestamp = new Date();
        this.moSource = aoSource;
        this.msMode = asMode;
        this.miLevel = aiLevel;
    }

    private LogEntry(Object aoSource, String asMode, int aiLevel, String asMessage) {
        this.miType = 1;
        this.moTimestamp = new Date();
        this.moSource = aoSource;
        this.msMode = asMode;
        this.miLevel = aiLevel;
        this.msMessage = asMessage;
    }

    private LogEntry(Object aoSource, String asMode, int aiLevel, String asMessage, boolean abPartial) {
        this.miType = !abPartial ? 1 : 5;
        this.moTimestamp = new Date();
        this.moSource = aoSource;
        this.msMode = asMode;
        this.miLevel = aiLevel;
        this.msMessage = asMessage;
    }

    private LogEntry(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        this.miType = 2;
        this.moTimestamp = new Date();
        this.moSource = aoSource;
        this.msMode = asMode;
        this.miLevel = aiLevel;
        this.moThrowable = aoThrowable;
    }

    public static LogEntry create() {
        return new LogEntry(0);
    }

    public static LogEntry create(Object aoSource, String asMode, int aiLevel) {
        return new LogEntry(aoSource, asMode, aiLevel);
    }

    public static LogEntry create(Object aoSource, String asMode, int aiLevel, String asMessage) {
        return new LogEntry(aoSource, asMode, aiLevel, asMessage);
    }

    public static LogEntry create(Object aoSource, String asMode, int aiLevel, String asMessage, boolean abPartial) {
        return new LogEntry(aoSource, asMode, aiLevel, asMessage, abPartial);
    }

    public static LogEntry create(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        return new LogEntry(aoSource, asMode, aiLevel, aoThrowable);
    }

    public static LogEntry timestamp() {
        return new LogEntry(3);
    }

    public int getType() {
        return this.miType;
    }

    public Date getTimestamp() {
        return this.moTimestamp;
    }

    public Object getSource() {
        return this.moSource;
    }

    public String getMode() {
        return this.msMode;
    }

    public int getLevel() {
        return this.miLevel;
    }

    public String getMessage() {
        return this.msMessage;
    }

    public Throwable getThrowable() {
        return this.moThrowable;
    }
}

