/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import novaworx.log.LogEntry;
import novaworx.log.LogSettings;
import novaworx.log.Logger;
import novaworx.util.thread.BlockingQueue;

public final class Log
implements Runnable,
LogSettings {
    private static final Log moLog = new Log();
    private static final Vector mvLoggers = new Vector();
    private static final BlockingQueue moEntries = new BlockingQueue();
    private static Thread moWorker;

    private Log() {
        moWorker = new Thread(this);
        moWorker.start();
    }

    public void run() {
        LogEntry oEntry = (LogEntry)moEntries.get();
        while (oEntry != null) {
            List vLoggers = Collections.unmodifiableList(mvLoggers);
            int iCount = vLoggers.size();
            block9: for (int nIndex = 0; nIndex < vLoggers.size(); ++nIndex) {
                Logger oLogger = (Logger)vLoggers.get(nIndex);
                switch (oEntry.getType()) {
                    case 0: {
                        oLogger.writeBlank();
                        continue block9;
                    }
                    case 1: {
                        oLogger.write(oEntry.getSource(), oEntry.getMode(), oEntry.getLevel(), oEntry.getMessage(), false);
                        continue block9;
                    }
                    case 5: {
                        oLogger.write(oEntry.getSource(), oEntry.getMode(), oEntry.getLevel(), oEntry.getMessage(), true);
                        continue block9;
                    }
                    case 2: {
                        oLogger.write(oEntry.getSource(), oEntry.getMode(), oEntry.getLevel(), oEntry.getThrowable());
                        continue block9;
                    }
                    case 3: {
                        oLogger.writeTimestamp();
                        continue block9;
                    }
                    case 4: {
                        oLogger.writeHeader(oEntry.getSource(), oEntry.getMode(), oEntry.getLevel());
                    }
                }
            }
            oEntry = (LogEntry)moEntries.get();
        }
    }

    public static void waitFor() {
        moEntries.close();
        try {
            moWorker.join();
        }
        catch (InterruptedException aoException) {
            aoException.printStackTrace();
        }
    }

    public static final void addLogger(Logger aoLogger) {
        mvLoggers.add(aoLogger);
    }

    public static final void removeLogger(Logger aoLogger) {
        mvLoggers.remove(aoLogger);
    }

    public static final void write(String asMessage) {
        Log.write(null, null, 4, asMessage);
    }

    public static final void write(int aiLevel, String asMessage) {
        Log.write(null, null, aiLevel, asMessage);
    }

    public static final void write(String asMode, String asMessage) {
        Log.write(null, asMode, 4, asMessage);
    }

    public static final void write(Object aoSource, String asMessage) {
        Log.write(aoSource, null, 4, asMessage);
    }

    public static final void write(String asMode, int aiLevel, String asMessage) {
        Log.write(null, asMode, aiLevel, asMessage);
    }

    public static final void write(Object aoSource, int aiLevel, String asMessage) {
        Log.write(aoSource, null, aiLevel, asMessage);
    }

    public static final void write(Object aoSource, String asMode, String asMessage) {
        Log.write(aoSource, asMode, 4, asMessage);
    }

    public static final void write(Object aoSource, String asMode, int aiLevel, String asMessage) {
        LogEntry oEntry = LogEntry.create(aoSource, asMode, aiLevel, asMessage);
        moEntries.add(oEntry);
    }

    public static final void writePart(String asMessage) {
        Log.writePart(null, null, 4, asMessage);
    }

    public static final void writePart(int aiLevel, String asMessage) {
        Log.writePart(null, null, aiLevel, asMessage);
    }

    public static final void writePart(String asMode, String asMessage) {
        Log.writePart(null, asMode, 4, asMessage);
    }

    public static final void writePart(Object aoSource, String asMessage) {
        Log.writePart(aoSource, null, 4, asMessage);
    }

    public static final void writePart(String asMode, int aiLevel, String asMessage) {
        Log.writePart(null, asMode, aiLevel, asMessage);
    }

    public static final void writePart(Object aoSource, int aiLevel, String asMessage) {
        Log.writePart(aoSource, null, aiLevel, asMessage);
    }

    public static final void writePart(Object aoSource, String asMode, String asMessage) {
        Log.writePart(aoSource, asMode, 4, asMessage);
    }

    public static final void writePart(Object aoSource, String asMode, int aiLevel, String asMessage) {
        LogEntry oEntry = LogEntry.create(aoSource, asMode, aiLevel, asMessage, true);
        moEntries.add(oEntry);
    }

    public static final void write(Throwable aoThrowable) {
        Log.write(null, null, 2, aoThrowable);
    }

    public static final void write(int aiLevel, Throwable aoThrowable) {
        Log.write(null, null, aiLevel, aoThrowable);
    }

    public static final void write(String asMode, Throwable aoThrowable) {
        Log.write(null, asMode, 2, aoThrowable);
    }

    public static final void write(Object aoSource, Throwable aoThrowable) {
        Log.write(aoSource, null, 2, aoThrowable);
    }

    public static final void write(String asMode, int aiLevel, Throwable aoThrowable) {
        Log.write(null, asMode, aiLevel, aoThrowable);
    }

    public static final void write(Object aoSource, int aiLevel, Throwable aoThrowable) {
        Log.write(aoSource, null, aiLevel, aoThrowable);
    }

    public static final void write(Object aoSource, String asMode, Throwable aoThrowable) {
        Log.write(aoSource, asMode, 2, aoThrowable);
    }

    public static final void write(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        LogEntry oEntry = LogEntry.create(aoSource, asMode, aiLevel, aoThrowable);
        moEntries.add(oEntry);
    }

    public static final void writeBlank() {
        LogEntry oEntry = LogEntry.create();
        moEntries.add(oEntry);
    }

    public static final void writeHeader(Object aoSource, String asMode, int aiLevel) {
        LogEntry oEntry = LogEntry.create(aoSource, asMode, aiLevel);
        moEntries.add(oEntry);
    }

    public static final void writeTimestamp() {
        LogEntry oEntry = LogEntry.timestamp();
        moEntries.add(oEntry);
    }

    public static final int parseLevel(String asLevel) {
        int iLevel = 4;
        if (asLevel == null) {
            return iLevel;
        }
        String sLevel = asLevel.toUpperCase();
        if (sLevel.equals("ALWAYS")) {
            iLevel = -100;
        } else if (sLevel.equals("NONE")) {
            iLevel = 0;
        } else if (sLevel.equals("FATAL")) {
            iLevel = 1;
        } else if (sLevel.equals("ERROR")) {
            iLevel = 2;
        } else if (sLevel.equals("WARN")) {
            iLevel = 3;
        } else if (sLevel.equals("INFO")) {
            iLevel = 4;
        } else if (sLevel.equals("CONFIG")) {
            iLevel = 5;
        } else if (sLevel.equals("DEBUG")) {
            iLevel = 6;
        } else if (sLevel.equals("ALL")) {
            iLevel = 100;
        }
        return iLevel;
    }

    public static final String valueOf(int aiLevel) {
        switch (aiLevel) {
            case -100: {
                return "ALWAYS";
            }
            case -1: {
                return "DEVEL";
            }
            case 0: {
                return "NONE";
            }
            case 1: {
                return "FATAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARN";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "CONFIG";
            }
            case 6: {
                return "DEBUG";
            }
            case 100: {
                return "ALL";
            }
        }
        return Integer.toString(aiLevel);
    }
}

