/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import novaworx.log.AbstractLogger;

public class FileLogger
extends AbstractLogger {
    private File moFile;
    private boolean mbPartialFlag;

    public FileLogger(File aoFile) {
        if (aoFile == null) {
            throw new IllegalArgumentException();
        }
        this.moFile = aoFile;
    }

    public FileLogger(String asFilename) {
        this(new File(asFilename));
    }

    public void writeBlank() {
        this.fileWrite("\n");
    }

    public void writeTimestamp() {
        Date oNow = new Date();
        this.fileWrite(oNow.toString() + "\n");
    }

    public void writeHeader(Object aoSource, String asMode, int aiLevel) {
        String sHeader = this.createHeader(aoSource, asMode, aiLevel);
        this.fileWrite(sHeader + "\n");
    }

    public void write(Object aoSource, String asMode, int aiLevel, String asMessage, boolean abPartial) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        String sEntry = null;
        if (abPartial) {
            sEntry = this.mbPartialFlag ? asMessage : this.format(aoSource, asMode, aiLevel, asMessage);
            this.mbPartialFlag = true;
        } else {
            sEntry = this.format(aoSource, asMode, aiLevel, asMessage) + "\n";
            this.mbPartialFlag = false;
        }
        this.fileWrite(sEntry);
    }

    public void write(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        this.fileWrite(this.format(aoSource, asMode, aiLevel, aoThrowable));
    }

    private void fileWrite(String asEntry) {
        if (this.moFile == null) {
            return;
        }
        File oParent = this.moFile.getAbsoluteFile().getParentFile();
        if (oParent == null) {
            System.out.println("File parent is null. File is: " + this.moFile.getAbsolutePath());
            return;
        }
        if (!oParent.exists()) {
            oParent.mkdirs();
        }
        RandomAccessFile oDataFile = null;
        try {
            oDataFile = new RandomAccessFile(this.moFile, "rw");
            oDataFile.seek(oDataFile.length());
            oDataFile.writeBytes(asEntry);
            oDataFile.close();
        }
        catch (IOException aoException) {
            aoException.printStackTrace();
            return;
        }
    }
}

