/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.io.PrintStream;
import java.util.Date;
import novaworx.log.AbstractLogger;

public class ConsoleLogger
extends AbstractLogger {
    private boolean mbAnsiColor;
    private PrintStream moPrintStream;

    public ConsoleLogger() {
        this(System.out);
    }

    public ConsoleLogger(PrintStream aoPrintStream) {
        this.moPrintStream = aoPrintStream;
    }

    public void setAnsiColor(boolean abAnsiColor) {
        this.mbAnsiColor = abAnsiColor;
    }

    public boolean getAnsiColor() {
        return this.mbAnsiColor;
    }

    public void writeBlank() {
        this.write("", 4, false);
    }

    public void writeTimestamp() {
        Date oNow = new Date();
        this.write(oNow.toString(), 4, false);
    }

    public void writeHeader(Object aoSource, String asMode, int aiLevel) {
        String sHeader = this.createHeader(aoSource, asMode, aiLevel);
        this.write(sHeader, aiLevel, false);
    }

    public void write(Object aoSource, String asMode, int aiLevel, String asMessage, boolean abPartial) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        String sMessage = this.format(aoSource, asMode, aiLevel, asMessage);
        this.write(sMessage, aiLevel, abPartial);
    }

    public void write(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        if (!this.canWrite(asMode, aiLevel)) {
            return;
        }
        String sMessage = this.format(aoSource, asMode, aiLevel, aoThrowable);
        this.write(sMessage, aiLevel, false);
    }

    private void write(String asMessage, int aiLevel, boolean abPartial) {
        if (this.mbAnsiColor) {
            asMessage = this.colorize(asMessage, aiLevel);
        }
        if (abPartial) {
            this.moPrintStream.print(asMessage);
        } else {
            this.moPrintStream.println(asMessage);
        }
    }

    private String colorize(String asMessage, int aiLevel) {
        StringBuffer oBuffer = new StringBuffer();
        switch (aiLevel) {
            case -1: {
                oBuffer.append("\u001b[1m\u001b[33m");
                break;
            }
            case 1: {
                oBuffer.append("\u001b[1m\u001b[31m");
                break;
            }
            case 2: {
                oBuffer.append("\u001b[31m");
                break;
            }
            case 3: {
                oBuffer.append("\u001b[33m");
                break;
            }
            case 4: {
                oBuffer.append("\u001b[37m");
                break;
            }
            case 5: {
                oBuffer.append("\u001b[1m\u001b[30m");
                break;
            }
            case 6: {
                oBuffer.append("\u001b[34m");
            }
        }
        oBuffer.append(asMessage);
        oBuffer.append("\u001b[0m");
        return oBuffer.toString();
    }
}

