/*
 * Decompiled with CFR 0.152.
 */
package novaworx.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import novaworx.log.Log;
import novaworx.log.Logger;
import novaworx.util.text.Indenter;

public abstract class AbstractLogger
implements Logger {
    private int miLevel = 4;
    private String msMode;
    private boolean mbUseNull;
    private boolean mbShowTimestamp;
    private boolean mbShowSource;
    private boolean mbShowMode;
    private boolean mbShowLevel;

    public void setLevel(String asLevel) {
        this.setLevel(Log.parseLevel(asLevel));
    }

    public void setLevel(int aiLevel) {
        if (aiLevel < 0 | aiLevel > 100) {
            aiLevel = 4;
        }
        this.miLevel = aiLevel;
    }

    public int getLevel() {
        return this.miLevel;
    }

    public void setMode(String asMode) {
        this.setMode(asMode, false);
    }

    public void setMode(String asMode, boolean abUseNull) {
        this.mbUseNull = abUseNull;
        this.msMode = asMode;
    }

    public String getMode() {
        return this.msMode;
    }

    public void setShowTimestamp(boolean abShow) {
        this.mbShowTimestamp = abShow;
    }

    public boolean getShowTimestamp() {
        return this.mbShowTimestamp;
    }

    public void setShowSource(boolean abShow) {
        this.mbShowSource = abShow;
    }

    public boolean getShowSource() {
        return this.mbShowSource;
    }

    public void setShowMode(boolean abShow) {
        this.mbShowMode = abShow;
    }

    public boolean getShowMode() {
        return this.mbShowMode;
    }

    public void setShowLevel(boolean abShow) {
        this.mbShowLevel = abShow;
    }

    public boolean getShowLevel() {
        return this.mbShowLevel;
    }

    protected boolean canWrite(String asMode, int aiLevel) {
        boolean bMode = false;
        boolean bLevel = false;
        if (this.msMode == null) {
            if (asMode == null) {
                bMode = true;
            }
        } else if (asMode == null) {
            if (this.mbUseNull) {
                bMode = true;
            }
        } else if (this.msMode.indexOf(asMode) >= 0) {
            bMode = true;
        }
        if (aiLevel <= this.miLevel) {
            bLevel = true;
        }
        return bMode & bLevel;
    }

    protected String createHeader(Object aoSource, String asMode, int aiLevel) {
        StringBuffer oBuffer = new StringBuffer();
        Date oNow = new Date();
        if (this.mbShowTimestamp) {
            oBuffer.append(oNow.toString());
            oBuffer.append(" : ");
        }
        if (this.mbShowSource) {
            if (aoSource == null) {
                oBuffer.append("Not Specified");
            } else {
                oBuffer.append(aoSource.toString());
            }
            oBuffer.append(" : ");
        }
        if (this.mbShowMode) {
            if (asMode == null) {
                oBuffer.append("Not Specified");
            } else {
                oBuffer.append(asMode);
            }
            oBuffer.append(" : ");
        }
        if (this.mbShowLevel) {
            oBuffer.append(Log.valueOf(aiLevel));
            oBuffer.append(" : ");
        }
        return oBuffer.toString().trim();
    }

    protected String format(Object aoSource, String asMode, int aiLevel, String asMessage) {
        if (asMessage == null) {
            return "";
        }
        StringBuffer oBuffer = new StringBuffer();
        String sHeader = this.createHeader(aoSource, asMode, aiLevel);
        if (sHeader.length() > 0) {
            oBuffer.append(sHeader);
            oBuffer.append("\n");
            oBuffer.append(Indenter.indent(asMessage, 2, ' '));
            oBuffer.append("\n");
        } else {
            oBuffer.append(asMessage);
        }
        return oBuffer.toString();
    }

    protected String format(Object aoSource, String asMode, int aiLevel, Throwable aoThrowable) {
        if (aoThrowable == null) {
            return "";
        }
        StringWriter oStringWriter = new StringWriter();
        PrintWriter oPrintWriter = new PrintWriter(oStringWriter);
        aoThrowable.printStackTrace(oPrintWriter);
        StringBuffer oBuffer = new StringBuffer();
        String sHeader = this.createHeader(aoSource, asMode, aiLevel);
        if (sHeader.length() > 0) {
            oBuffer.append(sHeader);
            oBuffer.append("\n");
            oBuffer.append(Indenter.indent(oStringWriter.toString().trim(), 2, ' '));
            oBuffer.append("\n");
        } else {
            oBuffer.append(oStringWriter.toString().trim());
        }
        return oBuffer.toString();
    }
}

