/*
 * Decompiled with CFR 0.152.
 */
package novaworx.icon;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import novaworx.icon.FileIcon;

public class FileTypeIcon
extends FileIcon {
    private Point2D.Float moPointA;
    private Point2D.Float moPointB;
    private Point2D.Float moPointC;
    private Point2D.Float moPointD;
    private String msText;

    public FileTypeIcon(String asText) {
        this.msText = asText == null ? "" : asText.toUpperCase();
        this.moPointA = new Point2D.Float(24.0f, 88.0f);
        this.moPointB = new Point2D.Float(24.0f, 184.0f);
        this.moPointC = new Point2D.Float(232.0f, 184.0f);
        this.moPointD = new Point2D.Float(232.0f, 88.0f);
    }

    public void paintIcon(Component aoComponent, Graphics aoGraphics, int aiX, int aiY) {
        super.paintIcon(aoComponent, aoGraphics, aiX, aiY);
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        this.paintIconBanner(aoComponent, aoGraphics, aiX, aiY);
        this.paintIconText(aoComponent, aoGraphics, aiX, aiY);
    }

    public void paintIconBanner(Component aoComponent, Graphics aoGraphics, int aiX, int aiY) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        GeneralPath oBannerPath = new GeneralPath();
        oBannerPath.moveTo(this.moPointA.x, this.moPointA.y);
        oBannerPath.lineTo(this.moPointB.x, this.moPointB.y);
        oBannerPath.lineTo(this.moPointC.x, this.moPointC.y);
        oBannerPath.lineTo(this.moPointD.x, this.moPointD.y);
        oBannerPath.closePath();
        oGraphics.setPaint(new GradientPaint(this.moPointA.x, this.moPointA.y, FileTypeIcon.getIconColor("gradient.light.begin"), this.moPointA.x + (float)FileTypeIcon.getGridSize(), this.moPointA.y + (float)FileTypeIcon.getGridSize(), FileTypeIcon.getIconColor("gradient.light.end")));
        oGraphics.fill(oBannerPath);
        oGraphics.setColor(FileTypeIcon.getIconColor("outline"));
        oGraphics.setStroke(new BasicStroke(FileTypeIcon.getOutlineSize(), 1, 1));
        oGraphics.draw(oBannerPath);
    }

    public void paintIconText(Component aoComponent, Graphics aoGraphics, int aiX, int aiY) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        float fHCenterLine = this.moPointA.x + (this.moPointD.x - this.moPointA.x) / 2.0f;
        float fVCenterLine = this.moPointA.y + (this.moPointB.y - this.moPointA.y) / 2.0f;
        float fBannerHeight = (this.moPointB.y - this.moPointA.y) * 0.5f;
        Font oFont = this.findFontForHeight(oGraphics, oGraphics.getFont(), fBannerHeight);
        FontMetrics oFontMetrics = oGraphics.getFontMetrics(oFont);
        oGraphics.setFont(oFont);
        Rectangle2D oTextBounds = oFontMetrics.getStringBounds(this.msText, oGraphics);
        float fX = fHCenterLine - (float)oTextBounds.getWidth() / 2.0f;
        float fY = fVCenterLine + (float)(oFontMetrics.getAscent() - oFontMetrics.getLeading() - oFontMetrics.getDescent()) / 2.0f;
        Line2D.Float oX = new Line2D.Float(fX, this.moPointA.y, fX, this.moPointB.y);
        Line2D.Float oY = new Line2D.Float(this.moPointA.x, fY, this.moPointD.x, fY);
        Line2D.Float oHCenterLine = new Line2D.Float(this.moPointA.x, fVCenterLine, this.moPointD.x, fVCenterLine);
        Line2D.Float oVCenterLine = new Line2D.Float(fHCenterLine, this.moPointA.y, fHCenterLine, this.moPointB.y);
        oGraphics.setColor(FileTypeIcon.getIconColor("outline"));
        oGraphics.drawString(this.msText, fX, fY);
    }
}

