/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import novaworx.PreferenceEngine;
import novaworx.swing.XColor;

public class XButtonModifier
implements ActionListener,
MouseListener {
    private boolean mbMouseOver = false;
    private Border moNormalBorder = NO_BORDER;
    private Border moRolloverBorder = new LineBorder(Color.GRAY, 1);
    private Border moPressedBorder = new LineBorder(Color.DARK_GRAY, 1);
    public static final Border NO_BORDER = new EmptyBorder(1, 1, 1, 1);
    private PreferenceChangeHandler moPreferenceChangeHandler = new PreferenceChangeHandler();

    public XButtonModifier() {
        this.moPreferenceChangeHandler.init();
    }

    public void setNormalBorder(Border aoBorder) {
        this.moNormalBorder = aoBorder;
    }

    public Border getNormalBorder() {
        return this.moNormalBorder;
    }

    public void setRolloverBorder(Border aoBorder) {
        this.moRolloverBorder = aoBorder;
    }

    public Border getRolloverBorder() {
        return this.moRolloverBorder;
    }

    public void setPressedBorder(Border aoBorder) {
        this.moPressedBorder = aoBorder;
    }

    public Border getPressedBorder() {
        return this.moPressedBorder;
    }

    public void actionPerformed(ActionEvent aoEvent) {
        if (!(aoEvent.getSource() instanceof JButton)) {
            return;
        }
        JButton oButton = (JButton)aoEvent.getSource();
        oButton.setBorder(this.moNormalBorder);
    }

    public void mouseMoved(MouseEvent aoEvent) {
    }

    public void mouseEntered(MouseEvent aoEvent) {
        this.mbMouseOver = true;
        JButton oButton = this.getButton(aoEvent);
        if (oButton == null) {
            return;
        }
        if (oButton.isEnabled()) {
            oButton.setContentAreaFilled(false);
            oButton.setBorder(oButton.getModel().isPressed() ? this.moPressedBorder : this.moRolloverBorder);
        } else {
            oButton.setContentAreaFilled(false);
            oButton.setBorder(this.moNormalBorder);
        }
    }

    public void mouseExited(MouseEvent aoEvent) {
        this.mbMouseOver = false;
        JButton oButton = this.getButton(aoEvent);
        if (oButton == null) {
            return;
        }
        oButton.setContentAreaFilled(false);
        oButton.setBorder(this.moNormalBorder);
    }

    public void mouseClicked(MouseEvent aoEvent) {
    }

    public void mousePressed(MouseEvent aoEvent) {
        JButton oButton = this.getButton(aoEvent);
        if (oButton == null) {
            return;
        }
        oButton.setBorder(oButton.isEnabled() ? this.moPressedBorder : this.moNormalBorder);
    }

    public void mouseReleased(MouseEvent aoEvent) {
        JButton oButton = this.getButton(aoEvent);
        if (oButton == null) {
            return;
        }
        oButton.setBorder(oButton.isEnabled() && this.mbMouseOver ? this.moRolloverBorder : this.moNormalBorder);
    }

    private JButton getButton(AWTEvent aoEvent) {
        if (!(aoEvent.getSource() instanceof JButton)) {
            return null;
        }
        JButton oButton = (JButton)aoEvent.getSource();
        return oButton;
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences && "default".equals(sKey)) {
                Color oForeground = XColor.decodeForeground(sValue);
                Color oBackground = XColor.decodeBackground(sValue);
                Color oRolloverColor = XColor.getGrayscaleOffset(oBackground);
                Color oPressedColor = XColor.getGrayscaleOffset(oRolloverColor);
                XButtonModifier.this.moRolloverBorder = new LineBorder(oRolloverColor, 1);
                XButtonModifier.this.moPressedBorder = new LineBorder(oPressedColor, 1);
            }
        }
    }
}

