/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import novaworx.gui.ActionLibrary;
import novaworx.gui.InputListener;
import novaworx.gui.ProgramAction;
import novaworx.log.Log;
import novaworx.swing.XPanel;

public class UtilityBar
extends JPanel {
    private JLabel moPrompt;
    private JTextField moInput;
    private JLabel moStatus;
    private String msCommandPrompt = "Ready";
    private InputListener moInputListener;
    private AcceptHandler moAcceptHandler = new AcceptHandler();
    private CancelHandler moCancelHandler = new CancelHandler();

    public UtilityBar() {
        Color oControlColor = UIManager.getColor("control");
        Color oBorderColor = UIManager.getColor("controlDkShadow");
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBackground(oControlColor);
        this.moPrompt = new JLabel("");
        this.moPrompt.setOpaque(true);
        this.moPrompt.setBackground(oControlColor);
        this.moPrompt.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.moInput = new JTextField();
        this.moInput.setBackground(oControlColor);
        this.moInput.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moInput.setDisabledTextColor(this.moInput.getForeground());
        this.moInput.setEnabled(false);
        XPanel oInputPanel = new XPanel();
        oInputPanel.setBackground(oControlColor);
        oInputPanel.setLayout(new BorderLayout(2, 2));
        oInputPanel.add((Component)this.moPrompt, "West");
        oInputPanel.add((Component)this.moInput, "Center");
        this.add((Component)oInputPanel, "Center");
        this.moStatus = new JLabel("     ");
        this.moStatus.setBackground(oControlColor);
        this.moStatus.setOpaque(true);
        this.add((Component)this.moStatus, "East");
        this.setLookAndFeelValues();
        this.reset();
    }

    public void reset() {
        this.moPrompt.setText(this.msCommandPrompt);
        this.moInput.setText("");
        this.moInput.setEnabled(false);
        this.moInputListener = null;
        ((ProgramAction)ActionLibrary.get("accept")).pullListener(this.moAcceptHandler);
        ((ProgramAction)ActionLibrary.get("cancel")).pullListener(this.moCancelHandler);
    }

    public void showInput(String asPrompt, InputListener aoListener) {
        this.showInput(asPrompt, "", aoListener);
    }

    public void showInput(String asPrompt, String asInitialValue, InputListener aoListener) {
        this.moPrompt.setText(asPrompt);
        this.moInput.setText(asInitialValue);
        this.moInputListener = aoListener;
        ((ProgramAction)ActionLibrary.get("accept")).pushListener(this.moAcceptHandler);
        ((ProgramAction)ActionLibrary.get("cancel")).pushListener(this.moCancelHandler);
        this.moInput.setEnabled(true);
        this.moInput.requestFocusInWindow();
    }

    public void showMessage(String asText) {
        this.moPrompt.setText("");
        this.moInput.setText(asText);
    }

    public void showWarning(String asText) {
        this.moPrompt.setText("Warning: ");
        this.moInput.setText(asText);
    }

    public void showConfirm(String asPrompt) {
        this.moPrompt.setText(asPrompt);
        this.moInput.setText("");
    }

    public void showStatus(String asText) {
        new ShowStatus(asText);
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        if (this.moPrompt != null) {
            this.moPrompt.setForeground(aoColor);
        }
        if (this.moInput != null) {
            this.moInput.setForeground(aoColor);
        }
        if (this.moStatus != null) {
            this.moStatus.setForeground(aoColor);
        }
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
        if (this.moPrompt != null) {
            this.moPrompt.setBackground(aoColor);
        }
        if (this.moInput != null) {
            this.moInput.setBackground(aoColor);
        }
        if (this.moStatus != null) {
            this.moStatus.setBackground(aoColor);
        }
    }

    public void setSelectionForeground(Color aoColor) {
        this.moInput.setSelectedTextColor(aoColor);
    }

    public void setSelectionBackground(Color aoColor) {
        this.moInput.setSelectionColor(aoColor);
    }

    public void setCaretColor(Color aoColor) {
        this.moInput.setCaretColor(aoColor);
    }

    public void updateUI() {
        this.setLookAndFeelValues();
    }

    private void setLookAndFeelValues() {
        if (this.moStatus != null) {
            this.moStatus.setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, UIManager.getColor("controlDkShadow")), new EmptyBorder(0, 2, 0, 2)));
        }
    }

    public void paint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        Boolean oAntiAlias = (Boolean)this.getRootPane().getClientProperty("anti.alias.text");
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oAntiAlias != null && oAntiAlias != false ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        super.paint(aoGraphics);
    }

    private class CancelHandler
    implements ActionListener {
        private CancelHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            UtilityBar.this.moInput.setText("");
            UtilityBar.this.moInput.setEnabled(false);
            if (UtilityBar.this.moInputListener != null) {
                UtilityBar.this.moInputListener.cancel();
            }
            UtilityBar.this.reset();
        }
    }

    private class AcceptHandler
    implements ActionListener {
        private AcceptHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            String sData = UtilityBar.this.moInput.getText();
            UtilityBar.this.moInput.setText("");
            UtilityBar.this.moInput.setEnabled(false);
            if (UtilityBar.this.moInputListener != null) {
                UtilityBar.this.moInputListener.accept(sData);
            }
            UtilityBar.this.reset();
        }
    }

    private class ShowStatus
    implements Runnable {
        private String msText;

        public ShowStatus(String asText) {
            this.msText = asText;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InvocationTargetException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
                catch (InterruptedException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
            }
        }

        public void run() {
            if (this.msText == null || this.msText == "") {
                UtilityBar.this.moStatus.setText("");
            } else {
                UtilityBar.this.moStatus.setText(this.msText);
            }
        }
    }
}

