/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;

public class TablePanel
extends JPanel
implements Scrollable {
    private GridBagLayout moGridBag = new GridBagLayout();
    private GridBagConstraints moConstraints;
    private Component moPreviousComponent;
    private int miSpacing;
    private int miPadding;
    private int miColspan;
    private int miRowspan;
    private int miPreviousColspan;
    private int miPreviousRowspan;
    private int miWidth;
    private int miHeight;
    private int miPreviousWidth;
    private int miPreviousHeight;
    private int miColCount;
    private int miRowHeight;
    private int miTotalCols;
    private int miTotalRows;

    public TablePanel() {
        super.setLayout(this.moGridBag);
        this.moConstraints = new GridBagConstraints();
        this.moConstraints.fill = 2;
        this.miWidth = 1;
        this.miHeight = 1;
        this.miColspan = 1;
        this.miRowspan = 1;
        this.miRowHeight = 1;
    }

    public void setBorderSize(int aiBorder) {
        this.setBorder(new EmptyBorder(aiBorder, aiBorder, aiBorder, aiBorder));
    }

    public void setBorderSize(int aiTop, int aiLeft, int aiBottom, int aiRight) {
        this.setBorder(new EmptyBorder(aiTop, aiLeft, aiBottom, aiRight));
    }

    public void setCellPadding(int aiPadding) {
        this.miPadding = aiPadding;
    }

    public void setCellSpacing(int aiSpacing) {
        this.miSpacing = aiSpacing;
    }

    public void width(int aiWidth) {
        this.miWidth = aiWidth;
    }

    public void height(int aiHeight) {
        this.miHeight = aiHeight;
    }

    public void colspan(int aiSpan) {
        this.miColspan = aiSpan;
    }

    public void rowspan(int aiSpan) {
        this.miRowspan = aiSpan;
    }

    public void row() {
        if (this.moPreviousComponent != null) {
            this.miPreviousColspan = 0;
        }
        this.miTotalRows += Math.max(1, this.miRowHeight);
        this.miTotalCols = Math.max(this.miTotalCols, this.miColCount);
        this.miRowHeight = 1;
        this.miColCount = 0;
    }

    public void done() {
        this.miPreviousColspan = 0;
        this.addPrevious();
        this.miTotalRows += Math.max(1, this.miRowHeight);
        this.miTotalCols = Math.max(this.miTotalCols, this.miColCount);
    }

    public Component add(Component aoComponent) {
        if (aoComponent == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        this.addPrevious();
        this.moPreviousComponent = aoComponent;
        this.miPreviousWidth = this.miWidth;
        this.miPreviousHeight = this.miHeight;
        this.miPreviousColspan = this.miColspan;
        this.miPreviousRowspan = this.miRowspan;
        this.miColCount = this.moConstraints.gridwidth != 0 ? (this.miColCount += Math.max(1, this.moConstraints.gridwidth)) : ++this.miColCount;
        this.miWidth = 1;
        this.miHeight = 1;
        this.miColspan = 1;
        this.miRowspan = 1;
        return aoComponent;
    }

    private void addPrevious() {
        if (this.moPreviousComponent == null) {
            return;
        }
        this.moConstraints.weightx = this.miPreviousWidth;
        this.moConstraints.weighty = this.miPreviousHeight;
        this.moConstraints.gridwidth = this.miPreviousColspan;
        this.moConstraints.gridheight = this.miPreviousRowspan;
        this.moConstraints.insets = new Insets(this.miSpacing, this.miSpacing, this.miSpacing, this.miSpacing);
        this.moConstraints.ipadx = this.miPadding;
        this.moConstraints.ipady = this.miPadding;
        this.miRowHeight = Math.max(this.miRowHeight, this.moConstraints.gridheight);
        this.moGridBag.setConstraints(this.moPreviousComponent, this.moConstraints);
        super.add(this.moPreviousComponent);
    }

    public void setLayout(LayoutManager aoLayout) {
    }

    public int getRowCount() {
        return this.miTotalRows;
    }

    public int getColumnCount() {
        return this.miTotalCols;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle aoArea, int aiOrientation, int aiDirection) {
        return this.getPreferredSize().height / this.miTotalRows;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle aoArea, int aiOrientation, int aiDirection) {
        return aoArea.getSize().height;
    }
}

