/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import novaworx.Version;
import novaworx.log.Log;

public class SplashScreen
extends Canvas {
    private int miBarSize = 12;
    private Window moWindow;
    private BufferedImage moImage;
    private Image moOffScreenImage;
    private BufferedImage moProgressBackground;
    private Graphics moOffScreenGraphics;
    private boolean mbInit;
    private int miProgress;
    private int miProgressSteps;
    private Color moFontColor;
    private Color moBarColor;
    private Color moTrayColor;
    private Color moBorderColor;
    private int miH;
    private int miW;
    private int miX;
    private int miY;
    private int miBorder = 2;
    private double mdRealProgress;
    private double mdProgress;
    private double mdPull;
    private double mdStepSize;
    private Thread moThread;
    boolean mbExecuting;
    boolean mbDisposed;
    private MediaTracker moMediaTracker;
    private long mlStartTime;
    private long mlStopTime;

    public SplashScreen(int aiProgressSteps) {
        this.miProgressSteps = aiProgressSteps;
        this.mdStepSize = 1.0 / (double)aiProgressSteps;
        this.setCursor(Cursor.getPredefinedCursor(3));
        Image oImage = this.getToolkit().getImage(this.getClass().getResource("/novaworx/images/splash.png"));
        this.moMediaTracker = new MediaTracker(this);
        this.moMediaTracker.addImage(oImage, 0);
        try {
            this.moMediaTracker.waitForID(0);
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
        }
        Dimension oScreen = this.getToolkit().getScreenSize();
        Dimension oSize = new Dimension(oImage.getWidth(this), oImage.getHeight(this));
        this.setSize(oSize);
        this.moImage = new BufferedImage(oSize.width, oSize.height, 1);
        this.moImage.createGraphics().drawImage(oImage, 0, 0, this);
        this.miH = this.miBarSize;
        this.miW = oSize.width - this.miH * 2;
        this.miX = this.miH;
        this.miY = oSize.height - this.miH * 2;
        this.moProgressBackground = this.moImage.getSubimage(this.miX - (this.miBorder + 1), this.miY - (this.miBorder + 1), this.miW + this.miBorder * 2 + 2, this.miH + this.miBorder * 2 + 2);
        this.moFontColor = Color.GRAY.brighter();
        this.moBarColor = Color.GRAY.brighter();
        this.moTrayColor = Color.GRAY.darker();
        this.moBorderColor = Color.GRAY;
        this.moWindow = new Window(new Frame());
        this.moWindow.setLayout(new BorderLayout());
        this.moWindow.add("Center", this);
        this.moWindow.setSize(oSize);
        this.moWindow.setLocation((oScreen.width - oSize.width) / 2, (oScreen.height - oSize.height) / 2);
        this.moWindow.pack();
        this.moOffScreenImage = this.createImage(oSize.width, oSize.height);
        this.moMediaTracker.addImage(this.moOffScreenImage, 0);
        try {
            this.moMediaTracker.waitForID(0);
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
        }
        this.moOffScreenGraphics = this.moOffScreenImage.getGraphics();
        this.prepaint(this.moOffScreenGraphics);
        this.moWindow.validate();
        this.moWindow.show();
        this.fireSplashScreenShown();
        this.moThread = new Thread(new SplashScreenRunner());
        this.moThread.start();
    }

    public void prepaint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        oGraphics.drawImage((Image)this.moImage, 0, 0, this);
        oGraphics.setFont(oGraphics.getFont().deriveFont(1, 16.0f));
        FontMetrics oMetrics = oGraphics.getFontMetrics();
        String sVersionText = "Version: " + Version.getVersion() + " " + Version.getState();
        int iX = this.miX + this.miBorder;
        int iY = this.miY - oMetrics.getDescent() - this.miBorder;
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        oGraphics.setColor(this.moFontColor);
        oGraphics.drawString(sVersionText, iX, iY);
    }

    public void dispose() {
        this.mbDisposed = true;
        if (this.moThread != null) {
            try {
                this.moThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fireSplashScreenHidden();
    }

    public synchronized void advance() {
        ++this.miProgress;
        this.mdRealProgress = (double)this.miProgress / (double)this.miProgressSteps;
    }

    public int getProgress() {
        return this.miProgress;
    }

    public void update(Graphics aoGraphics) {
        this.paint(aoGraphics);
    }

    public synchronized void paint(Graphics aoGraphics) {
        this.mbInit = true;
        Dimension oSize = this.getSize();
        int iProgress = (int)((double)(this.miW - this.miH) * this.mdProgress) + this.miH;
        if (iProgress > this.miW) {
            iProgress = this.miW;
        }
        Graphics2D oGraphics = (Graphics2D)this.moOffScreenGraphics;
        oGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        oGraphics.drawImage((Image)this.moProgressBackground, this.miX - (this.miBorder + 1), this.miY - (this.miBorder + 1), this);
        oGraphics.setColor(this.moBorderColor);
        oGraphics.fillRoundRect(this.miX - this.miBorder, this.miY - this.miBorder, this.miW + this.miBorder * 2, this.miH + this.miBorder * 2, this.miH + this.miBorder * 2, this.miH + this.miBorder * 2);
        oGraphics.setColor(this.moTrayColor);
        oGraphics.fillRoundRect(this.miX, this.miY, this.miW, this.miH, this.miH, this.miH);
        oGraphics.setColor(this.moBarColor);
        oGraphics.fillRoundRect(this.miX, this.miY, iProgress, this.miH, this.miH, this.miH);
        aoGraphics.drawImage(this.moOffScreenImage, 0, 0, this);
        this.notify();
    }

    private void fireSplashScreenShown() {
        this.mlStartTime = System.currentTimeMillis();
    }

    private void fireSplashScreenHidden() {
        this.moWindow.dispose();
        this.mlStopTime = System.currentTimeMillis();
    }

    private class SplashScreenRunner
    implements Runnable {
        private int miTimeSlice = 20;

        private SplashScreenRunner() {
        }

        public void run() {
            double dPix = 1.0 / (double)SplashScreen.this.miW;
            double dStep = 0.0;
            double dPull = 0.0;
            double dDamp = 2.0;
            SplashScreen.this.mbExecuting = true;
            while (!SplashScreen.this.mbDisposed && SplashScreen.this.mdProgress < 1.0) {
                dPull = SplashScreen.this.mdRealProgress - SplashScreen.this.mdProgress;
                dStep = SplashScreen.this.mdStepSize * dPull;
                SplashScreen.this.mdProgress += dStep > dPix ? dStep : dPix;
                SplashScreen.this.repaint();
                Thread.yield();
                try {
                    Thread.sleep(this.miTimeSlice);
                }
                catch (InterruptedException aoException) {}
            }
            while (SplashScreen.this.mdProgress < 1.0) {
                SplashScreen.this.mdProgress += dPix;
                SplashScreen.this.repaint();
                Thread.yield();
            }
            SplashScreen.this.mbExecuting = false;
        }
    }
}

