/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import novaworx.PreferenceEngine;
import novaworx.gui.ActionLibrary;
import novaworx.gui.ProgramAction;
import novaworx.gui.ShortcutListener;
import novaworx.log.Log;
import novaworx.swing.XAction;

public class ShortcutGrabber
implements KeyEventDispatcher {
    private String msCurrentSequence;
    private Vector mvMatches;
    private ShortcutListener moListener;
    private String msAccept;
    private String msCancel;
    private PreferenceChangeHandler moPreferenceChangeHandler = new PreferenceChangeHandler();
    private boolean mbBlockKeyEvents;

    public ShortcutGrabber() {
        this.moPreferenceChangeHandler.init();
        this.reinit();
    }

    public void update() {
        this.mvMatches = ActionLibrary.getShortcuts();
    }

    private void reinit() {
        this.msCurrentSequence = null;
        this.update();
    }

    public boolean dispatchKeyEvent(KeyEvent aoEvent) {
        if (aoEvent.getID() == 401) {
            int iKeyCode = aoEvent.getKeyCode();
            if (iKeyCode == 17 || iKeyCode == 16 || iKeyCode == 18 || iKeyCode == 157) {
                return false;
            }
            if (this.msCurrentSequence == null) {
                this.reinit();
            }
            String sKeystroke = XAction.encodeKeyEvent(aoEvent);
            if (this.moListener == null) {
                this.msCurrentSequence = this.msCurrentSequence == null ? sKeystroke : this.msCurrentSequence + " " + sKeystroke;
                switch (this.match(this.msCurrentSequence)) {
                    case 2: {
                        this.mbBlockKeyEvents = this.processShortcut(this.msCurrentSequence);
                        return this.mbBlockKeyEvents;
                    }
                    case 1: {
                        if (aoEvent.getKeyCode() == 27) {
                            this.reinit();
                        }
                        return false;
                    }
                }
            } else {
                if (sKeystroke.equals(this.msAccept)) {
                    this.acceptShortcut();
                } else if (sKeystroke.equals(this.msCancel)) {
                    this.cancelShortcut();
                } else {
                    this.msCurrentSequence = this.msCurrentSequence == null ? sKeystroke : this.msCurrentSequence + " " + sKeystroke;
                    this.moListener.shortcutTyped(this.msCurrentSequence);
                }
                return true;
            }
            this.reinit();
        } else if (this.mbBlockKeyEvents) {
            if (aoEvent.getID() == 402) {
                this.mbBlockKeyEvents = false;
            }
            return true;
        }
        return false;
    }

    public void acceptShortcut() {
        if (this.moListener == null) {
            return;
        }
        this.moListener.shortcutAccept(this.msCurrentSequence);
        this.moListener = null;
        this.reinit();
    }

    public void cancelShortcut() {
        if (this.moListener == null) {
            return;
        }
        this.moListener.shortcutCancel(this.msCurrentSequence);
        this.moListener = null;
        this.reinit();
    }

    private int match(String asSequence) {
        if (asSequence == null) {
            return 0;
        }
        int iIndex = Collections.binarySearch(this.mvMatches, asSequence);
        if (iIndex >= 0) {
            return 2;
        }
        iIndex = -iIndex - 1;
        Vector<String> vMatches = new Vector<String>();
        String sCheck = null;
        while (iIndex < this.mvMatches.size()) {
            if (this.sequenceStartsWith(sCheck = (String)this.mvMatches.get(iIndex++), asSequence)) {
                vMatches.add(sCheck);
                continue;
            }
            iIndex = this.mvMatches.size();
        }
        if (vMatches.size() > 0) {
            this.mvMatches = vMatches;
            return 1;
        }
        return 0;
    }

    private boolean sequenceStartsWith(String asSequenceOne, String asSequenceTwo) {
        StringTokenizer oTokenizerOne = new StringTokenizer(asSequenceOne);
        StringTokenizer oTokenizerTwo = new StringTokenizer(asSequenceTwo);
        String sTokenOne = null;
        String sTokenTwo = null;
        while (oTokenizerTwo.hasMoreTokens()) {
            if (!oTokenizerOne.hasMoreTokens()) {
                return false;
            }
            sTokenOne = oTokenizerOne.nextToken();
            if (sTokenOne.equals(sTokenTwo = oTokenizerTwo.nextToken())) continue;
            return false;
        }
        return true;
    }

    private boolean processShortcut(String asShortcut) {
        Log.write(6, "Shortcut typed: " + asShortcut);
        ActionEvent oEvent = new ActionEvent(this, 1001, null);
        ProgramAction oAction = (ProgramAction)ActionLibrary.getForShortcut(asShortcut);
        this.reinit();
        if (oAction == null) {
            return false;
        }
        boolean bResult = oAction.performAction(oEvent);
        Log.write(6, (bResult ? "Shortcut used:  " : "Shortcut not used: ") + asShortcut);
        return bResult;
    }

    public boolean setListener(ShortcutListener aoListener) {
        if (this.moListener != null) {
            return false;
        }
        this.moListener = aoListener;
        return true;
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moShortcutPreferences = PreferenceEngine.get().getPreferences("/keymap");
        private Preferences moProgramShortcutPreferences;

        public PreferenceChangeHandler() {
            this.moShortcutPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moShortcutPreferences, "accept", this);
            PreferenceEngine.get().initPreference(this.moShortcutPreferences, "cancel", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moShortcutPreferences) {
                if ("accept".equals(sKey)) {
                    ShortcutGrabber.this.msAccept = sValue;
                } else if ("cancel".equals(sKey)) {
                    ShortcutGrabber.this.msCancel = sValue;
                }
            }
        }
    }
}

