/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class RecessedBorder
extends AbstractBorder {
    public static final int LOWERED = 0;
    public static final int RAISED = 1;
    protected int miBevelType = 0;
    protected Color moHighlight;
    protected Color moShadow;

    public RecessedBorder(int aiBevelType) {
        this(aiBevelType, null, null);
    }

    public RecessedBorder(int aiBevelType, Color aoHighlight, Color aoShadow) {
        this.miBevelType = aiBevelType;
        this.moHighlight = aoHighlight;
        this.moShadow = aoShadow;
    }

    public void paintBorder(Component aoComponent, Graphics aoGraphics, int aiX, int aiY, int aiWidth, int aiHeight) {
        switch (this.miBevelType) {
            case 1: {
                this.paintRaisedBevel(aoComponent, aoGraphics, aiX, aiY, aiWidth, aiHeight);
                break;
            }
            case 0: {
                this.paintLoweredBevel(aoComponent, aoGraphics, aiX, aiY, aiWidth, aiHeight);
            }
        }
    }

    public Insets getBorderInsets(Component aoComponent) {
        return new Insets(1, 1, 1, 1);
    }

    public Insets getBorderInsets(Component aoComponent, Insets aoInsets) {
        aoInsets.bottom = 1;
        aoInsets.right = 1;
        aoInsets.top = 1;
        aoInsets.left = 1;
        return aoInsets;
    }

    public Color getHighlightColor(Component aoComponent) {
        return this.moHighlight != null ? this.moHighlight : aoComponent.getBackground().brighter();
    }

    public Color getShadowColor(Component aoComponent) {
        return this.moShadow != null ? this.moShadow : aoComponent.getBackground().darker();
    }

    public int getBevelType() {
        return this.miBevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component aoComponent, Graphics aoGraphics, int aiX, int aiY, int aiWidth, int aiHeight) {
        Color oOldColor = aoGraphics.getColor();
        aoGraphics.translate(aiX, aiY);
        aoGraphics.setColor(this.getHighlightColor(aoComponent));
        aoGraphics.drawLine(0, 0, 0, aiHeight - 1);
        aoGraphics.drawLine(1, 0, aiWidth - 1, 0);
        aoGraphics.setColor(this.getShadowColor(aoComponent));
        aoGraphics.drawLine(1, aiHeight - 1, aiWidth - 1, aiHeight - 1);
        aoGraphics.drawLine(aiWidth - 1, 1, aiWidth - 1, aiHeight - 2);
        aoGraphics.translate(-aiX, -aiY);
        aoGraphics.setColor(oOldColor);
    }

    protected void paintLoweredBevel(Component aoComponent, Graphics aoGraphics, int aiX, int aiY, int aiWidth, int aiHeight) {
        Color oOldColor = aoGraphics.getColor();
        aoGraphics.translate(aiX, aiY);
        aoGraphics.setColor(this.getShadowColor(aoComponent));
        aoGraphics.drawLine(0, 0, 0, aiHeight - 2);
        aoGraphics.drawLine(0, 0, aiWidth - 2, 0);
        aoGraphics.setColor(this.getHighlightColor(aoComponent));
        aoGraphics.drawLine(0, aiHeight - 1, aiWidth - 1, aiHeight - 1);
        aoGraphics.drawLine(aiWidth - 1, 0, aiWidth - 1, aiHeight - 1);
        aoGraphics.translate(-aiX, -aiY);
        aoGraphics.setColor(oOldColor);
    }
}

