/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Color;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.swing.XColor;

public class ProgramTheme
extends DefaultMetalTheme {
    private ColorUIResource moBlack = new ColorUIResource(Color.decode("#000000"));
    private ColorUIResource moWhite = new ColorUIResource(Color.decode("#FFFFFF"));
    private ColorUIResource moPrimaryColor1 = new ColorUIResource(Color.decode("#4060A0"));
    private ColorUIResource moPrimaryColor2 = new ColorUIResource(Color.decode("#6080C0"));
    private ColorUIResource moPrimaryColor3 = new ColorUIResource(Color.decode("#80A0E0"));
    private ColorUIResource moSecondaryColor1 = new ColorUIResource(Color.decode("#A0A0A0"));
    private ColorUIResource moSecondaryColor2 = new ColorUIResource(Color.decode("#C0C0C0"));
    private ColorUIResource moSecondaryColor3 = new ColorUIResource(Color.decode("#E0E0E0"));
    private FontUIResource moControlFont = new FontUIResource("Dialog", 0, 12);
    private PreferenceChangeHandler moPreferenceChangeHandler = new PreferenceChangeHandler();

    public ProgramTheme() {
        this.moPreferenceChangeHandler.init();
    }

    public String getName() {
        return "Custom Theme";
    }

    private void setBlack(Color aoColor) {
        this.moBlack = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getBlack() {
        return this.moBlack;
    }

    private void setWhite(Color aoColor) {
        this.moWhite = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getWhite() {
        return this.moWhite;
    }

    private void setPrimary1(Color aoColor) {
        this.moPrimaryColor1 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getPrimary1() {
        return this.moPrimaryColor1;
    }

    private void setPrimary2(Color aoColor) {
        this.moPrimaryColor2 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getPrimary2() {
        return this.moPrimaryColor2;
    }

    private void setPrimary3(Color aoColor) {
        this.moPrimaryColor3 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getPrimary3() {
        return this.moPrimaryColor3;
    }

    private void setSecondary1(Color aoColor) {
        this.moSecondaryColor1 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getSecondary1() {
        return this.moSecondaryColor1;
    }

    private void setSecondary2(Color aoColor) {
        this.moSecondaryColor2 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getSecondary2() {
        return this.moSecondaryColor2;
    }

    private void setSecondary3(Color aoColor) {
        this.moSecondaryColor3 = new ColorUIResource(aoColor);
    }

    protected ColorUIResource getSecondary3() {
        return this.moSecondaryColor3;
    }

    public ColorUIResource getAcceleratorSelectedForeground() {
        return this.getWhite();
    }

    public ColorUIResource getMenuSelectedForeground() {
        return this.getWhite();
    }

    public FontUIResource getControlTextFont() {
        return this.moControlFont;
    }

    public FontUIResource getMenuTextFont() {
        return this.moControlFont;
    }

    public FontUIResource getWindowTitleFont() {
        return this.moControlFont;
    }

    public void updateColors() {
        UIManager.put("OptionPane.questionDialog.titlePane.background", this.getWindowTitleBackground());
        UIManager.put("OptionPane.questionDialog.titlePane.foreground", this.getWindowTitleForeground());
        UIManager.put("OptionPane.questionDialog.titlePane.shadow", this.getPrimaryControlDarkShadow());
        UIManager.put("OptionPane.questionDialog.border.background", this.getPrimaryControlDarkShadow());
        UIManager.put("OptionPane.warningDialog.titlePane.background", this.getWindowTitleBackground());
        UIManager.put("OptionPane.warningDialog.titlePane.foreground", this.getWindowTitleForeground());
        UIManager.put("OptionPane.warningDialog.titlePane.shadow", this.getPrimaryControlDarkShadow());
        UIManager.put("OptionPane.warningDialog.border.background", this.getPrimaryControlDarkShadow());
        UIManager.put("OptionPane.errorDialog.titlePane.background", this.getWindowTitleBackground());
        UIManager.put("OptionPane.errorDialog.titlePane.foreground", this.getWindowTitleForeground());
        UIManager.put("OptionPane.errorDialog.titlePane.shadow", this.getPrimaryControlDarkShadow());
        UIManager.put("OptionPane.errorDialog.border.background", this.getPrimaryControlDarkShadow());
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moAppearancePreferences = PreferenceEngine.get().getPreferences("/program/appearance");

        public PreferenceChangeHandler() {
            this.moAppearancePreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "black", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "white", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "primary1", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "primary2", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "primary3", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "secondary1", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "secondary2", this);
            PreferenceEngine.get().initPreference(this.moAppearancePreferences, "secondary3", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moAppearancePreferences) {
                if ("black".equals(sKey)) {
                    ProgramTheme.this.setBlack(XColor.decode(sValue));
                } else if ("white".equals(sKey)) {
                    ProgramTheme.this.setWhite(XColor.decode(sValue));
                } else if ("primary1".equals(sKey)) {
                    ProgramTheme.this.setPrimary1(XColor.decode(sValue));
                } else if ("primary2".equals(sKey)) {
                    ProgramTheme.this.setPrimary2(XColor.decode(sValue));
                } else if ("primary3".equals(sKey)) {
                    ProgramTheme.this.setPrimary3(XColor.decode(sValue));
                } else if ("secondary1".equals(sKey)) {
                    ProgramTheme.this.setSecondary1(XColor.decode(sValue));
                } else if ("secondary2".equals(sKey)) {
                    ProgramTheme.this.setSecondary2(XColor.decode(sValue));
                } else if ("secondary3".equals(sKey)) {
                    ProgramTheme.this.setSecondary3(XColor.decode(sValue));
                }
                ProgramTheme.this.updateColors();
                GuiEngine.get().updateUI();
            }
        }
    }
}

