/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import novaworx.swing.XAction;

public class ProgramAction
extends XAction {
    public static final int NONE = -1;
    private String msCommand;
    private Stack moListenerStack;

    public ProgramAction(String sCommand, String sName) {
        this(sCommand, sName, null);
    }

    public ProgramAction(String sCommand, String sName, Icon cIcon) {
        this(sCommand, sName, cIcon, -1);
    }

    public ProgramAction(String sCommand, String sName, Icon cIcon, int nMnemonic) {
        this(sCommand, sName, cIcon, nMnemonic, -1);
    }

    public ProgramAction(String sCommand, String sName, Icon cIcon, int nMnemonic, int nKey) {
        this(sCommand, sName, cIcon, nMnemonic, nKey, -1);
    }

    public ProgramAction(String sCommand, String sName, Icon cIcon, int nMnemonic, int nKey, int nMask) {
        super(sName, cIcon);
        this.msCommand = sCommand;
        this.moListenerStack = new Stack();
        this.setEnabled(false);
        if (nMnemonic != -1) {
            this.putValue("MnemonicKey", new Integer(nMnemonic));
        }
        if (nKey != -1 & nMask == -1) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(nKey, 0));
        }
        if (nKey != -1 & nMask != -1) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(nKey, nMask));
        }
    }

    public ProgramAction(String sCommand, String sName, Icon cIcon, int nMnemonic, String asKeySequence) {
        super(sName, cIcon);
        this.msCommand = sCommand;
        this.moListenerStack = new Stack();
        this.setEnabled(false);
        if (nMnemonic != -1) {
            this.putValue("MnemonicKey", new Integer(nMnemonic));
        }
        if (asKeySequence != null) {
            this.putValue("shortcut.key.sequence", asKeySequence);
        }
    }

    public String getCommand() {
        return this.msCommand;
    }

    public boolean performAction(ActionEvent aoEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        ActionListener oListener = null;
        if (this.moListenerStack.size() > 0) {
            oListener = (ActionListener)this.moListenerStack.peek();
        }
        if (oListener != null) {
            ActionEvent oNewEvent = new ActionEvent(aoEvent.getSource(), aoEvent.getID(), this.msCommand);
            oListener.actionPerformed(oNewEvent);
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent aoEvent) {
        boolean bResult = this.performAction(aoEvent);
    }

    public void setEnabled(boolean abEnabled) {
        new SetEnabled(abEnabled);
    }

    public void pushListener(ActionListener aoListener) {
        this.pushListener(aoListener, true);
    }

    public void pushListener(ActionListener aoListener, boolean abEnabled) {
        if (aoListener == null) {
            throw new IllegalArgumentException("Null ActionListener not allowed.");
        }
        if (!this.moListenerStack.contains(aoListener)) {
            this.moListenerStack.push(aoListener);
        }
        this.setEnabled(aoListener != null & abEnabled);
    }

    public ActionListener peekListener() {
        return (ActionListener)this.moListenerStack.peek();
    }

    public ActionListener pullListener(ActionListener aoListener) {
        this.moListenerStack.remove(aoListener);
        if (this.moListenerStack.isEmpty()) {
            this.setEnabled(false);
        }
        return aoListener;
    }

    public ActionListener pullListener(ActionListener aoListener, boolean abEnabled) {
        this.moListenerStack.remove(aoListener);
        if (!this.moListenerStack.isEmpty()) {
            this.setEnabled(abEnabled);
        }
        return aoListener;
    }

    public ActionListener getListener() {
        return this.peekListener();
    }

    private class SetEnabled
    implements Runnable {
        private boolean mbEnabled;

        public SetEnabled(boolean abEnabled) {
            this.mbEnabled = abEnabled;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            ProgramAction.super.setEnabled(this.mbEnabled);
        }
    }
}

