/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import novaworx.gui.ProgramImageFilter;

public class PressedImageFilter
extends RGBImageFilter
implements ProgramImageFilter {
    private double mdPercent = 0.8;

    public PressedImageFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int aiX, int aiY, int aiRGB) {
        int iRed = (aiRGB & 0xFF0000) >> 16;
        int iGreen = (aiRGB & 0xFF00) >> 8;
        int iBlue = (aiRGB & 0xFF) >> 0;
        if ((iRed = (int)((double)iRed * this.mdPercent)) < 0) {
            iRed = 0;
        }
        if (iRed > 255) {
            iRed = 255;
        }
        if ((iGreen = (int)((double)iGreen * this.mdPercent)) < 0) {
            iGreen = 0;
        }
        if (iGreen > 255) {
            iGreen = 255;
        }
        if ((iBlue = (int)((double)iBlue * this.mdPercent)) < 0) {
            iBlue = 0;
        }
        if (iBlue > 255) {
            iBlue = 255;
        }
        return aiRGB & 0xFF000000 | iRed << 16 | iGreen << 8 | iBlue << 0;
    }

    public Image filterImage(Image aoImage) {
        FilteredImageSource oProducer = new FilteredImageSource(aoImage.getSource(), this);
        Image oFilteredImage = Toolkit.getDefaultToolkit().createImage(oProducer);
        return oFilteredImage;
    }
}

