/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MemoryLabel
extends JLabel {
    private static final int ONE_MEG = 0x100000;
    static Thread moCheckerThread;
    static MemoryChecker moMemoryChecker;
    static Runtime moRuntime;
    static DecimalFormat moFormatter;
    static long mlMaximumMemory;
    static long mlTotalMemory;
    static long mlFreeMemory;
    static long mlUsedMemory;
    static float mfTotalPercent;
    static float mfFreePercent;
    static float mfUsedPercent;
    static int miDelay;
    static boolean mbGarbage;
    StringBuffer moMemory = new StringBuffer();
    boolean mbMaximum;
    boolean mbTotal;
    boolean mbTotalPercent;
    boolean mbUsed;
    boolean mbUsedPercent;
    boolean mbFree;
    boolean mbFreePercent;

    public MemoryLabel() {
        moMemoryChecker.addLabel(this);
    }

    public MemoryLabel(boolean abMaximum, boolean abTotal, boolean abTotalPercent, boolean abUsed, boolean abUsedPercent, boolean abFree, boolean abFreePercent) {
        this();
        this.mbUsedPercent = true;
        this.mbMaximum = abMaximum;
        this.mbTotal = abTotal;
        this.mbTotalPercent = abTotalPercent;
        this.mbUsed = abUsed;
        this.mbUsedPercent = abUsedPercent;
        this.mbFree = abFree;
        this.mbFreePercent = abFreePercent;
        this.updateInfo();
    }

    public static void setUpdateInterval(int aiInterval) {
        miDelay = aiInterval;
    }

    public static int getUpdateInterval() {
        return miDelay;
    }

    public static void setGarbageCollect(boolean abGarbage) {
        mbGarbage = abGarbage;
    }

    public static boolean isGarbageCollect() {
        return mbGarbage;
    }

    private void updateInfo() {
        long lMaxMemory = mlMaximumMemory;
        long lTotalMemory = mlTotalMemory;
        long lUsedMemory = mlTotalMemory - mlFreeMemory;
        long lFreeMemory = lTotalMemory - lUsedMemory;
        mfTotalPercent = (float)lTotalMemory / (float)lMaxMemory * 100.0f;
        mfUsedPercent = (float)lUsedMemory / (float)lTotalMemory * 100.0f;
        mfFreePercent = (float)lFreeMemory / (float)lTotalMemory * 100.0f;
        this.moMemory.setLength(0);
        if (this.mbMaximum) {
            this.moMemory.append(moFormatter.format((float)lMaxMemory / 1048576.0f) + " MB");
        }
        if (this.mbTotal) {
            this.moMemory.append(moFormatter.format((float)lTotalMemory / 1048576.0f) + " MB");
        }
        if (this.mbTotalPercent) {
            this.moMemory.append(moFormatter.format(mfTotalPercent) + "%");
        }
        if (this.mbUsed) {
            this.moMemory.append(moFormatter.format((float)lUsedMemory / 1048576.0f) + " MB");
        }
        if (this.mbUsedPercent) {
            this.moMemory.append(moFormatter.format(mfUsedPercent) + "%");
        }
        if (this.mbFree) {
            this.moMemory.append(moFormatter.format((float)lFreeMemory / 1048576.0f) + " MB");
        }
        if (this.mbFreePercent) {
            this.moMemory.append(moFormatter.format(mfFreePercent) + "%");
        }
        new SetText(this.moMemory.toString());
    }

    private void showText(String asText) {
        new SetText(asText);
    }

    public void destroy() {
        moMemoryChecker.removeLabel(this);
    }

    static {
        miDelay = 1000;
        mbGarbage = false;
        moRuntime = Runtime.getRuntime();
        moFormatter = new DecimalFormat("#,##0.00");
        moMemoryChecker = new MemoryChecker();
        moCheckerThread = new Thread(moMemoryChecker);
        moCheckerThread.setDaemon(true);
        moCheckerThread.start();
    }

    private static class MemoryChecker
    implements Runnable {
        private Vector mvLabels = new Vector();

        public void addLabel(MemoryLabel aoLabel) {
            this.mvLabels.add(aoLabel);
        }

        public void removeLabel(MemoryLabel aoLabel) {
            this.mvLabels.remove(aoLabel);
        }

        public void fireUpdateInfo() {
            int iCount = this.mvLabels.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                ((MemoryLabel)this.mvLabels.get(iIndex)).updateInfo();
            }
        }

        public void fireShowText(String asText) {
            int iCount = this.mvLabels.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                ((MemoryLabel)this.mvLabels.get(iIndex)).showText(asText);
            }
        }

        public void run() {
            try {
                while (moCheckerThread == Thread.currentThread()) {
                    if (mbGarbage) {
                        moRuntime.gc();
                    }
                    mlMaximumMemory = moRuntime.maxMemory();
                    mlTotalMemory = moRuntime.totalMemory();
                    mlFreeMemory = moRuntime.freeMemory();
                    this.fireUpdateInfo();
                    Thread.sleep(miDelay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class SetText
    implements Runnable {
        private String msText;

        public SetText(String asText) {
            this.msText = asText;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            MemoryLabel.this.setText(this.msText);
        }
    }
}

