/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Color;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import novaworx.gui.TablePanel;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;

public class InformationPage
extends TablePanel {
    private int miRowNum = 0;
    private Color moTextCaretForeground = XColor.YELLOW;
    private Color moTextCaretBackground = XColor.CLEAR;
    private Color moTextEntryForeground = XColor.WHITE;
    private Color moTextEntryBackground = XColor.SEMI_WHITE;
    private Color moSelectionForeground = XColor.WHITE;
    private Color moSelectionBackground = XColor.decode("808080FF");
    private Color moSeparatorForeground = XColor.WHITE;
    private Color moSeparatorBackground = XColor.SEMI_WHITE;
    private Color moDisabledForeground = XColor.WHITE;
    private Color moDisabledBackground = XColor.SEMI_WHITE;

    public InformationPage() {
        this.setOpaque(false);
        this.setBorderSize(2);
        this.setCellSpacing(1);
    }

    public void addSeparator(String asLabel) {
        XLabel oLabel;
        if (this.miRowNum > 0) {
            this.row();
            oLabel = new XLabel(" ");
            oLabel.setBackground(XColor.CLEAR);
            oLabel.setHorizontalAlignment(0);
            this.add(oLabel);
        }
        this.row();
        oLabel = new XLabel(" " + asLabel);
        oLabel.setAntialias(true);
        oLabel.setBackground(XColor.CLEAR);
        oLabel.putClientProperty("separator.type", "true");
        oLabel.setFont(oLabel.getFont().deriveFont(1, (float)oLabel.getFont().getSize() * 1.25f));
        this.add(oLabel);
    }

    public JLabel rowLabel(String asLabel) {
        return this.rowLabel(asLabel, 1);
    }

    public JLabel rowLabel(String asLabel, int aiSpan) {
        return this.addLabel(asLabel, aiSpan, 0, true);
    }

    public JLabel addLabel(String asLabel) {
        return this.addLabel(asLabel, 1);
    }

    public JLabel addLabel(String asLabel, int aiSpan) {
        return this.addLabel(asLabel, aiSpan, 0, false);
    }

    private JLabel addLabel(String asLabel, int aiSpan, int aiWidth, boolean abRow) {
        XLabel oLabel = new XLabel(asLabel);
        oLabel.setBackground(XColor.CLEAR);
        if (abRow) {
            this.row();
        }
        this.width(aiWidth);
        this.colspan(aiSpan);
        this.add(oLabel);
        return oLabel;
    }

    public void row() {
        super.row();
        ++this.miRowNum;
    }

    public void addFocusListener(FocusListener aoListener) {
        super.addFocusListener(aoListener);
        int iCount = this.getComponentCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            JComponent oComponent = (JComponent)this.getComponent(iIndex);
            oComponent.addFocusListener(aoListener);
        }
    }

    public void removeFocusListener(FocusListener aoListener) {
        super.removeFocusListener(aoListener);
        int iCount = this.getComponentCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            JComponent oComponent = (JComponent)this.getComponent(iIndex);
            oComponent.removeFocusListener(aoListener);
        }
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        this.updateColors();
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
        this.updateColors();
    }

    public void setTextCaretForeground(Color aoColor) {
        this.moTextCaretForeground = aoColor;
        this.updateColors();
    }

    public void setTextCaretBackground(Color aoColor) {
        this.moTextCaretBackground = aoColor;
        this.updateColors();
    }

    public void setTextEntryForeground(Color aoColor) {
        this.moTextEntryForeground = aoColor;
        this.updateColors();
    }

    public void setTextEntryBackground(Color aoColor) {
        this.moTextEntryBackground = aoColor;
        this.updateColors();
    }

    public void setSelectionForeground(Color aoColor) {
        this.moSelectionForeground = aoColor;
        this.updateColors();
    }

    public void setSelectionBackground(Color aoColor) {
        this.moSelectionBackground = aoColor;
        this.updateColors();
    }

    public void setSeparatorForeground(Color aoColor) {
        this.moSeparatorForeground = aoColor;
        this.updateColors();
    }

    public void setSeparatorBackground(Color aoColor) {
        this.moSeparatorBackground = aoColor;
        this.updateColors();
    }

    public void setDisabledForeground(Color aoColor) {
        this.moDisabledForeground = aoColor;
        this.updateColors();
    }

    public void setDisabledBackground(Color aoColor) {
        this.moDisabledBackground = aoColor;
        this.updateColors();
    }

    private void updateColors() {
        int iCount = this.getComponentCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            JComponent oComponent = (JComponent)this.getComponent(iIndex);
            this.updateColors(oComponent);
        }
    }

    private void updateColors(JComponent aoComponent) {
        Color oForeground = this.getForeground();
        Color oBackground = this.getBackground();
        XColor oBorderColor = new XColor(this.moTextEntryBackground, 255);
        XColor oExemptBorderColor = new XColor(this.moTextEntryBackground, 64);
        boolean bSeparator = aoComponent.getClientProperty("separator.type") != null;
        boolean bForegroundExempt = aoComponent.getClientProperty("foreground.exempt") != null;
        boolean bBackgroundExempt = aoComponent.getClientProperty("background.exempt") != null;
        String sBackgroundOverride = (String)aoComponent.getClientProperty("background.override");
        if (bSeparator) {
            if (!bForegroundExempt) {
                aoComponent.setForeground(this.moSeparatorForeground);
            }
            if (!bBackgroundExempt) {
                aoComponent.setBackground(this.moSeparatorBackground);
            }
        } else if (aoComponent instanceof JTextComponent) {
            JTextComponent oTextComponent = (JTextComponent)aoComponent;
            if (!bForegroundExempt) {
                oTextComponent.setForeground(oForeground);
            }
            if (!bBackgroundExempt) {
                oTextComponent.setBackground(this.moTextEntryBackground);
            }
            oTextComponent.setCaretColor(this.moTextCaretForeground);
            oTextComponent.setSelectedTextColor(this.moSelectionForeground);
            oTextComponent.setSelectionColor(this.moSelectionBackground);
            oTextComponent.setDisabledTextColor(this.moDisabledForeground);
            oTextComponent.setBorder(new LineBorder(new XColor(oBackground, 255), 1));
            if (bBackgroundExempt) {
                aoComponent.setBorder(new LineBorder(oExemptBorderColor, 1));
            } else {
                aoComponent.setBorder(new LineBorder(oBorderColor, 1));
            }
        } else {
            if (!bForegroundExempt) {
                aoComponent.setForeground(oForeground);
            }
            if (!bBackgroundExempt) {
                aoComponent.setBackground(XColor.CLEAR);
            }
        }
        if (sBackgroundOverride != null) {
            aoComponent.setBackground(XColor.decode(sBackgroundOverride));
        }
    }
}

