/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.gui.DisabledImageFilter;
import novaworx.gui.PressedImageFilter;
import novaworx.gui.ProgramImageFilter;
import novaworx.icon.AboutIcon;
import novaworx.icon.AreaCloseIcon;
import novaworx.icon.AreaIcon;
import novaworx.icon.AreaNewIcon;
import novaworx.icon.BackwardIcon;
import novaworx.icon.BannerIcon;
import novaworx.icon.BlankIcon;
import novaworx.icon.BrokenIcon;
import novaworx.icon.BuildAllIcon;
import novaworx.icon.BuildIcon;
import novaworx.icon.BuildStopIcon;
import novaworx.icon.CheckboxIcon;
import novaworx.icon.CheckboxSelectedIcon;
import novaworx.icon.CompileIcon;
import novaworx.icon.CopyIcon;
import novaworx.icon.CutIcon;
import novaworx.icon.DatabaseIcon;
import novaworx.icon.DebugIcon;
import novaworx.icon.DeleteIcon;
import novaworx.icon.DiscIcon;
import novaworx.icon.DiskIcon;
import novaworx.icon.DropDownIcon;
import novaworx.icon.ErrorIcon;
import novaworx.icon.FileCloseAllIcon;
import novaworx.icon.FileCloseIcon;
import novaworx.icon.FileIcon;
import novaworx.icon.FileSystemIcon;
import novaworx.icon.FileTypeIcon;
import novaworx.icon.FolderIcon;
import novaworx.icon.FolderOpenIcon;
import novaworx.icon.ForwardIcon;
import novaworx.icon.FrameCloseIcon;
import novaworx.icon.FrameIcon;
import novaworx.icon.FrameNewIcon;
import novaworx.icon.IndentIcon;
import novaworx.icon.JavaClassIcon;
import novaworx.icon.JavaConstructorIcon;
import novaworx.icon.JavaFieldIcon;
import novaworx.icon.JavaImportIcon;
import novaworx.icon.JavaInitializerIcon;
import novaworx.icon.JavaInterfaceIcon;
import novaworx.icon.JavaJarIcon;
import novaworx.icon.JavaMethodIcon;
import novaworx.icon.JavaNestedClassIcon;
import novaworx.icon.JavaNestedInterfaceIcon;
import novaworx.icon.JavaPackageIcon;
import novaworx.icon.JumpToLineIcon;
import novaworx.icon.KeyMapIcon;
import novaworx.icon.KeyStrokeIcon;
import novaworx.icon.MenuBarIcon;
import novaworx.icon.NewIcon;
import novaworx.icon.NovaworxIcon;
import novaworx.icon.NullIcon;
import novaworx.icon.OpenIcon;
import novaworx.icon.OutlineIcon;
import novaworx.icon.PaneCloseIcon;
import novaworx.icon.PaneDefaultIcon;
import novaworx.icon.PaneIcon;
import novaworx.icon.PaneMaximizeIcon;
import novaworx.icon.PaneMergeEastIcon;
import novaworx.icon.PaneMergeNorthIcon;
import novaworx.icon.PaneMergeSouthIcon;
import novaworx.icon.PaneMergeWestIcon;
import novaworx.icon.PaneRestoreIcon;
import novaworx.icon.PaneSplitHorizontalIcon;
import novaworx.icon.PaneSplitVerticalIcon;
import novaworx.icon.ParentIcon;
import novaworx.icon.PasteIcon;
import novaworx.icon.PreferenceIcon;
import novaworx.icon.PreferencesIcon;
import novaworx.icon.PrintIcon;
import novaworx.icon.PrintPreviewIcon;
import novaworx.icon.ProgramImageIcon;
import novaworx.icon.PropertiesIcon;
import novaworx.icon.QuestionMarkIcon;
import novaworx.icon.RedoIcon;
import novaworx.icon.RefreshIcon;
import novaworx.icon.ResourceIcon;
import novaworx.icon.RunIcon;
import novaworx.icon.SaveAllIcon;
import novaworx.icon.SaveAsIcon;
import novaworx.icon.SaveCopyAsIcon;
import novaworx.icon.SaveIcon;
import novaworx.icon.SearchIcon;
import novaworx.icon.SearchNextIcon;
import novaworx.icon.SearchPreviousIcon;
import novaworx.icon.SelectAllIcon;
import novaworx.icon.StepIntoIcon;
import novaworx.icon.StepLineIcon;
import novaworx.icon.StepOutIcon;
import novaworx.icon.StepOverIcon;
import novaworx.icon.StopIcon;
import novaworx.icon.TerminalIcon;
import novaworx.icon.TextEditorIcon;
import novaworx.icon.ToolBarIcon;
import novaworx.icon.UmlClassIcon;
import novaworx.icon.UmlFieldIcon;
import novaworx.icon.UmlInterfaceIcon;
import novaworx.icon.UmlMethodIcon;
import novaworx.icon.UmlPackageIcon;
import novaworx.icon.UndoIcon;
import novaworx.icon.UnindentIcon;
import novaworx.icon.ViewCloseIcon;
import novaworx.icon.ViewIcon;
import novaworx.icon.ViewOptionsIcon;
import novaworx.icon.WorkspaceIcon;

public final class IconCache {
    public static final ProgramImageFilter PRESSED_FILTER = new PressedImageFilter();
    public static final ProgramImageFilter DISABLED_FILTER = new DisabledImageFilter();
    private static IconCache moIconCache;
    private static int miSize;
    private static final Hashtable mhIcons;
    private static final Hashtable mhProxies;
    private static PreferenceChangeHandler moPreferenceChangeHandler;

    private IconCache() {
    }

    public static final Icon getIcon(String asName) {
        if (asName == null) {
            return IconCache.getIcon("broken");
        }
        CacheIcon oProxy = (CacheIcon)mhProxies.get(asName);
        if (oProxy == null) {
            return IconCache.getIcon("broken");
        }
        return oProxy;
    }

    public static final Icon getIcon(String asName, int aiSize) {
        CacheIcon oProxy = null;
        String sKey = asName + ":" + aiSize;
        if (asName != null) {
            oProxy = (CacheIcon)mhProxies.get(sKey);
        }
        if (oProxy != null) {
            return oProxy;
        }
        oProxy = (CacheIcon)mhProxies.get(asName);
        if (oProxy == null) {
            oProxy = (CacheIcon)IconCache.getIcon("broken", aiSize);
        }
        CacheIcon oScaledProxy = new CacheIcon(oProxy.getRenderer(), aiSize);
        mhProxies.put(sKey, oScaledProxy);
        return oScaledProxy;
    }

    public static Icon filterIcon(Icon aoIcon, ProgramImageFilter aoFilter) {
        return new CacheIcon(aoIcon, aoFilter);
    }

    public static Icon filterIcon(Icon aoIcon, ProgramImageFilter aoFilter, int aiSize) {
        return new CacheIcon(aoIcon, aiSize, aoFilter);
    }

    public static final void setIconSize(int aiSize) {
        miSize = aiSize;
        mhIcons.clear();
    }

    public static final int getIconSize() {
        return miSize;
    }

    public static Image createIconImage(Icon aoIcon) {
        if (aoIcon == null) {
            aoIcon = IconCache.getIcon("broken");
        }
        BufferedImage oImage = new BufferedImage(aoIcon.getIconWidth(), aoIcon.getIconHeight(), 2);
        aoIcon.paintIcon(null, oImage.getGraphics(), 0, 0);
        return oImage;
    }

    private static Icon createRenderedIcon(Icon aoIcon) {
        return IconCache.createRenderedIcon(aoIcon, miSize);
    }

    private static Icon createRenderedIcon(Icon aoIcon, int aiSize) {
        return IconCache.createRenderedIcon(aoIcon, aiSize, null);
    }

    private static Icon createRenderedIcon(Icon aoIcon, ProgramImageFilter aoFilter) {
        return IconCache.createRenderedIcon(aoIcon, miSize, aoFilter);
    }

    private static Icon createRenderedIcon(Icon aoIcon, int aiSize, ProgramImageFilter aoFilter) {
        Image oImage = IconCache.createIconImage(aoIcon);
        oImage = oImage.getScaledInstance(aiSize, aiSize, 4);
        if (aoFilter != null) {
            oImage = aoFilter.filterImage(oImage);
        }
        return new ImageIcon(oImage);
    }

    private static void createNamedCacheIcon(String asName, Icon aoRenderer) {
        mhProxies.put(asName, new CacheIcon(aoRenderer));
    }

    static {
        miSize = 24;
        mhIcons = new Hashtable();
        mhProxies = new Hashtable();
        IconCache.createNamedCacheIcon("novaworx", new NovaworxIcon(true, true));
        IconCache.createNamedCacheIcon("null", new NullIcon());
        IconCache.createNamedCacheIcon("blank", new BlankIcon());
        IconCache.createNamedCacheIcon("broken", new BrokenIcon());
        IconCache.createNamedCacheIcon("checkbox", new CheckboxIcon());
        IconCache.createNamedCacheIcon("checkbox.selected", new CheckboxSelectedIcon());
        IconCache.createNamedCacheIcon("back", new BackwardIcon());
        IconCache.createNamedCacheIcon("forward", new ForwardIcon());
        IconCache.createNamedCacheIcon("parent", new ParentIcon());
        IconCache.createNamedCacheIcon("refresh", new RefreshIcon());
        IconCache.createNamedCacheIcon("error", new ErrorIcon());
        IconCache.createNamedCacheIcon("new", new NewIcon());
        IconCache.createNamedCacheIcon("open", new OpenIcon());
        IconCache.createNamedCacheIcon("recent", new OpenIcon());
        IconCache.createNamedCacheIcon("save", new SaveIcon());
        IconCache.createNamedCacheIcon("save.as", new SaveAsIcon());
        IconCache.createNamedCacheIcon("save.copy.as", new SaveCopyAsIcon());
        IconCache.createNamedCacheIcon("save.all", new SaveAllIcon());
        IconCache.createNamedCacheIcon("print", new PrintIcon());
        IconCache.createNamedCacheIcon("print.preview", new PrintPreviewIcon());
        IconCache.createNamedCacheIcon("close", new FileCloseIcon());
        IconCache.createNamedCacheIcon("close.all", new FileCloseAllIcon());
        IconCache.createNamedCacheIcon("exit", new BannerIcon("exit"));
        IconCache.createNamedCacheIcon("halt", new BannerIcon("halt"));
        IconCache.createNamedCacheIcon("undo", new UndoIcon());
        IconCache.createNamedCacheIcon("redo", new RedoIcon());
        IconCache.createNamedCacheIcon("cut", new CutIcon());
        IconCache.createNamedCacheIcon("copy", new CopyIcon());
        IconCache.createNamedCacheIcon("paste", new PasteIcon());
        IconCache.createNamedCacheIcon("delete", new DeleteIcon());
        IconCache.createNamedCacheIcon("search.quick", new SearchIcon());
        IconCache.createNamedCacheIcon("search.next", new SearchNextIcon());
        IconCache.createNamedCacheIcon("search.previous", new SearchPreviousIcon());
        IconCache.createNamedCacheIcon("indent", new IndentIcon());
        IconCache.createNamedCacheIcon("unindent", new UnindentIcon());
        IconCache.createNamedCacheIcon("jump.to.line", new JumpToLineIcon());
        IconCache.createNamedCacheIcon("select.all", new SelectAllIcon());
        IconCache.createNamedCacheIcon("frame", new FrameIcon());
        IconCache.createNamedCacheIcon("frame.new", new FrameNewIcon());
        IconCache.createNamedCacheIcon("menu.bar", new MenuBarIcon());
        IconCache.createNamedCacheIcon("tool.bar", new ToolBarIcon());
        IconCache.createNamedCacheIcon("frame.close", new FrameCloseIcon());
        IconCache.createNamedCacheIcon("area", new AreaIcon());
        IconCache.createNamedCacheIcon("area.new", new AreaNewIcon());
        IconCache.createNamedCacheIcon("area.close", new AreaCloseIcon());
        IconCache.createNamedCacheIcon("pane", new PaneIcon());
        IconCache.createNamedCacheIcon("pane.default", new PaneDefaultIcon());
        IconCache.createNamedCacheIcon("pane.maximize", new PaneMaximizeIcon());
        IconCache.createNamedCacheIcon("pane.restore", new PaneRestoreIcon());
        IconCache.createNamedCacheIcon("pane.close", new PaneCloseIcon());
        IconCache.createNamedCacheIcon("pane.split.vertical", new PaneSplitVerticalIcon());
        IconCache.createNamedCacheIcon("pane.split.horizontal", new PaneSplitHorizontalIcon());
        IconCache.createNamedCacheIcon("pane.merge.north", new PaneMergeNorthIcon());
        IconCache.createNamedCacheIcon("pane.merge.south", new PaneMergeSouthIcon());
        IconCache.createNamedCacheIcon("pane.merge.east", new PaneMergeEastIcon());
        IconCache.createNamedCacheIcon("pane.merge.west", new PaneMergeWestIcon());
        IconCache.createNamedCacheIcon("view", new ViewIcon());
        IconCache.createNamedCacheIcon("view.options", new ViewOptionsIcon());
        IconCache.createNamedCacheIcon("view.close", new ViewCloseIcon());
        IconCache.createNamedCacheIcon("workspace", new WorkspaceIcon());
        IconCache.createNamedCacheIcon("outline", new OutlineIcon());
        IconCache.createNamedCacheIcon("editor", new TextEditorIcon());
        IconCache.createNamedCacheIcon("terminal", new TerminalIcon());
        IconCache.createNamedCacheIcon("properties", new PropertiesIcon());
        IconCache.createNamedCacheIcon("preferences", new PreferencesIcon());
        IconCache.createNamedCacheIcon("compile", new CompileIcon());
        IconCache.createNamedCacheIcon("build", new BuildIcon());
        IconCache.createNamedCacheIcon("build.all", new BuildAllIcon());
        IconCache.createNamedCacheIcon("build.stop", new BuildStopIcon());
        IconCache.createNamedCacheIcon("run", new RunIcon());
        IconCache.createNamedCacheIcon("debug", new DebugIcon());
        IconCache.createNamedCacheIcon("stop", new StopIcon());
        IconCache.createNamedCacheIcon("step.over", new StepOverIcon());
        IconCache.createNamedCacheIcon("step.into", new StepIntoIcon());
        IconCache.createNamedCacheIcon("step.out", new StepOutIcon());
        IconCache.createNamedCacheIcon("step.line", new StepLineIcon());
        IconCache.createNamedCacheIcon("breakpoint", new BannerIcon("stop"));
        IconCache.createNamedCacheIcon("help", new QuestionMarkIcon());
        IconCache.createNamedCacheIcon("about", new AboutIcon());
        IconCache.createNamedCacheIcon("dropdown", new DropDownIcon());
        IconCache.createNamedCacheIcon("preference", new PreferenceIcon());
        IconCache.createNamedCacheIcon("keymap", new KeyMapIcon("K"));
        IconCache.createNamedCacheIcon("keystroke", new KeyStrokeIcon("S"));
        IconCache.createNamedCacheIcon("disc", new DiscIcon());
        IconCache.createNamedCacheIcon("disk", new DiskIcon());
        IconCache.createNamedCacheIcon("database", new DatabaseIcon());
        IconCache.createNamedCacheIcon("file", new FileIcon());
        IconCache.createNamedCacheIcon("filesystem", new FileSystemIcon());
        IconCache.createNamedCacheIcon("folder", new FolderIcon());
        IconCache.createNamedCacheIcon("folder.open", new FolderOpenIcon());
        IconCache.createNamedCacheIcon("resource", new ResourceIcon());
        IconCache.createNamedCacheIcon("resource.scheme.root", new FileSystemIcon());
        IconCache.createNamedCacheIcon("resource.type.dtd", new FileTypeIcon("dtd"));
        IconCache.createNamedCacheIcon("resource.type.java", new FileTypeIcon("java"));
        IconCache.createNamedCacheIcon("resource.type.png", new FileTypeIcon("png"));
        IconCache.createNamedCacheIcon("resource.type.properties", new FileTypeIcon("prop"));
        IconCache.createNamedCacheIcon("resource.type.shell", new FileTypeIcon("sh"));
        IconCache.createNamedCacheIcon("resource.type.xml", new FileTypeIcon("xml"));
        IconCache.createNamedCacheIcon("uml.package", new UmlPackageIcon());
        IconCache.createNamedCacheIcon("uml.class", new UmlClassIcon());
        IconCache.createNamedCacheIcon("uml.interface", new UmlInterfaceIcon());
        IconCache.createNamedCacheIcon("uml.field", new UmlFieldIcon());
        IconCache.createNamedCacheIcon("uml.method", new UmlMethodIcon());
        IconCache.createNamedCacheIcon("java.jar", new JavaJarIcon());
        IconCache.createNamedCacheIcon("java.package", new JavaPackageIcon());
        IconCache.createNamedCacheIcon("java.import", new JavaImportIcon());
        IconCache.createNamedCacheIcon("java.class", new JavaClassIcon());
        IconCache.createNamedCacheIcon("java.interface", new JavaInterfaceIcon());
        IconCache.createNamedCacheIcon("java.field", new JavaFieldIcon());
        IconCache.createNamedCacheIcon("java.initializer", new JavaInitializerIcon());
        IconCache.createNamedCacheIcon("java.constructor", new JavaConstructorIcon());
        IconCache.createNamedCacheIcon("java.method", new JavaMethodIcon());
        IconCache.createNamedCacheIcon("java.nested.class", new JavaNestedClassIcon());
        IconCache.createNamedCacheIcon("java.nested.interface", new JavaNestedInterfaceIcon());
        IconCache.createNamedCacheIcon("north.drop.cursor", new ProgramImageIcon("north.drop.cursor.png"));
        IconCache.createNamedCacheIcon("south.drop.cursor", new ProgramImageIcon("south.drop.cursor.png"));
        IconCache.createNamedCacheIcon("west.drop.cursor", new ProgramImageIcon("west.drop.cursor.png"));
        IconCache.createNamedCacheIcon("east.drop.cursor", new ProgramImageIcon("east.drop.cursor.png"));
        miSize = 24;
        Preferences oLookAndFeelPreferences = PreferenceEngine.get().getPreferences("/program/lookandfeel");
        try {
            miSize = Integer.parseInt(oLookAndFeelPreferences.get("icon.size", "24"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        moPreferenceChangeHandler = new PreferenceChangeHandler();
    }

    private static class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moLookAndFeelPreferences = PreferenceEngine.get().getPreferences("/program/lookandfeel");

        public PreferenceChangeHandler() {
            this.moLookAndFeelPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moLookAndFeelPreferences, "icon.size", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moLookAndFeelPreferences && "icon.size".equals(sKey)) {
                int iIconSize = 24;
                try {
                    iIconSize = Integer.parseInt(sValue);
                }
                catch (NumberFormatException aoException) {
                    // empty catch block
                }
                IconCache.setIconSize(iIconSize);
                GuiEngine.get().updateUI();
            }
        }
    }

    private static class CacheIcon
    implements Icon {
        private Icon moRenderer;
        private Integer moSize;
        private ProgramImageFilter moFilter;

        public CacheIcon(Icon aoRenderer) {
            this.moRenderer = aoRenderer;
        }

        public CacheIcon(Icon aoRenderer, int aiSize) {
            this.moRenderer = aoRenderer;
            this.moSize = new Integer(aiSize);
        }

        public CacheIcon(Icon aoRenderer, ProgramImageFilter aoFilter) {
            this.moRenderer = aoRenderer;
            this.moFilter = aoFilter;
        }

        public CacheIcon(Icon aoRenderer, int aiSize, ProgramImageFilter aoFilter) {
            this.moRenderer = aoRenderer;
            this.moSize = new Integer(aiSize);
            this.moFilter = aoFilter;
        }

        public Icon getRenderer() {
            return this.moRenderer;
        }

        public int getIconWidth() {
            return this.getRenderedIcon().getIconWidth();
        }

        public int getIconHeight() {
            return this.getRenderedIcon().getIconHeight();
        }

        public void paintIcon(Component aoComponent, Graphics aoGraphics, int aiX, int aiY) {
            this.getRenderedIcon().paintIcon(aoComponent, aoGraphics, aiX, aiY);
        }

        private Icon getRenderedIcon() {
            Icon oRenderedIcon = (Icon)mhIcons.get(this);
            if (oRenderedIcon != null) {
                return oRenderedIcon;
            }
            oRenderedIcon = this.moSize == null ? IconCache.createRenderedIcon(this.moRenderer, this.moFilter) : IconCache.createRenderedIcon(this.moRenderer, this.moSize, this.moFilter);
            mhIcons.put(this, oRenderedIcon);
            return oRenderedIcon;
        }
    }
}

