/*
 * Decompiled with CFR 0.152.
 */
package novaworx.gui;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramAction;
import novaworx.gui.ShortcutGrabber;

public class ActionLibrary {
    public static final int NONE = -1;
    private static Hashtable mhProgramActions = new Hashtable();
    private static Hashtable mhPublicActions;
    private static Hashtable mhProgramShortcuts;
    private static Hashtable mhPublicShortcuts;
    private static PreferenceChangeHandler moPreferenceChangeHandler;

    private ActionLibrary() {
    }

    public static final Action get(String asKey) {
        Action oAction = (Action)mhProgramActions.get(asKey);
        if (oAction == null) {
            oAction = (Action)mhPublicActions.get(asKey);
        }
        return oAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Vector getShortcuts() {
        Vector vShortcuts = new Vector();
        Hashtable hashtable = mhProgramShortcuts;
        synchronized (hashtable) {
            vShortcuts.addAll(mhProgramShortcuts.keySet());
        }
        hashtable = mhPublicShortcuts;
        synchronized (hashtable) {
            vShortcuts.addAll(mhPublicShortcuts.keySet());
        }
        Collections.sort(vShortcuts);
        return vShortcuts;
    }

    public static final Action getForShortcut(String asKey) {
        Action oAction = (Action)mhProgramShortcuts.get(asKey);
        if (oAction == null) {
            oAction = (Action)mhPublicShortcuts.get(asKey);
        }
        return oAction;
    }

    public static final void add(String asKey, String asName, Icon aoIcon, int aiMnemonic) {
        ActionLibrary.add(asKey, asName, aoIcon, aiMnemonic, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void add(String asKey, String asName, Icon aoIcon, int aiMnemonic, String asKeySequence) {
        ProgramAction oAction = new ProgramAction(asKey, asName, aoIcon, aiMnemonic, asKeySequence);
        mhPublicActions.put(asKey, oAction);
        if (asKeySequence != null) {
            Hashtable hashtable = mhPublicShortcuts;
            synchronized (hashtable) {
                mhPublicShortcuts.put(asKeySequence, oAction);
            }
        }
    }

    private static final void addSystemAction(String asKey, String asName, Icon aoIcon, int aiMnemonic) {
        ActionLibrary.addSystemAction(asKey, asName, aoIcon, aiMnemonic, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addSystemAction(String asKey, String asName, Icon aoIcon, int aiMnemonic, String asKeySequence) {
        ProgramAction oAction = new ProgramAction(asKey, asName, aoIcon, aiMnemonic, asKeySequence);
        mhProgramActions.put(asKey, oAction);
        if (asKeySequence != null) {
            Hashtable hashtable = mhProgramShortcuts;
            synchronized (hashtable) {
                mhProgramShortcuts.put(asKeySequence, oAction);
            }
        }
    }

    static {
        mhProgramShortcuts = new Hashtable();
        mhPublicActions = new Hashtable();
        mhPublicShortcuts = new Hashtable();
        moPreferenceChangeHandler = new PreferenceChangeHandler();
        ActionLibrary.addSystemAction("back", "Back", IconCache.getIcon("back"), 66);
        ActionLibrary.addSystemAction("forward", "Forward", IconCache.getIcon("forward"), 70);
        ActionLibrary.addSystemAction("parent", "Parent", IconCache.getIcon("parent"), 80, "c-up");
        ActionLibrary.addSystemAction("refresh", "Refresh", IconCache.getIcon("refresh"), 80, "f5");
        ActionLibrary.addSystemAction("accept", "Accept", IconCache.getIcon("accept"), 65, "enter");
        ActionLibrary.addSystemAction("cancel", "Cancel", IconCache.getIcon("cancel"), 67, "escape");
        ActionLibrary.addSystemAction("new", "New", IconCache.getIcon("new"), 78, "c-n");
        ActionLibrary.addSystemAction("open", "Open", IconCache.getIcon("open"), 79, "c-o");
        ActionLibrary.addSystemAction("properties", "Properties", IconCache.getIcon("properties"), 82);
        ActionLibrary.addSystemAction("save", "Save", IconCache.getIcon("save"), 83, "c-s");
        ActionLibrary.addSystemAction("save.as", "Save As", IconCache.getIcon("save.as"), 65);
        ActionLibrary.addSystemAction("save.copy.as", "Save Copy As", IconCache.getIcon("save.copy.as"), 89);
        ActionLibrary.addSystemAction("save.all", "Save All", IconCache.getIcon("save.all"), 76);
        ActionLibrary.addSystemAction("print", "Print", IconCache.getIcon("print"), 80, "c-p");
        ActionLibrary.addSystemAction("print.preview", "Print Preview", IconCache.getIcon("print.preview"), 86);
        ActionLibrary.addSystemAction("next.resource", "Next Resource", IconCache.getIcon("next.resource"), 88, "cs-down");
        ActionLibrary.addSystemAction("previous.resource", "Previous Resource", IconCache.getIcon("previous.resource"), 85, "cs-up");
        ActionLibrary.addSystemAction("close", "Close", IconCache.getIcon("close"), 67, "c-w");
        ActionLibrary.addSystemAction("close.all", "Close All", IconCache.getIcon("close.all"), 69);
        ActionLibrary.addSystemAction("exit", "Exit", IconCache.getIcon("exit"), 88, "c-q");
        ActionLibrary.addSystemAction("halt", "Halt", IconCache.getIcon("halt"), 72, "ca-q");
        ActionLibrary.addSystemAction("undo", "Undo", IconCache.getIcon("undo"), 85, "c-z");
        ActionLibrary.addSystemAction("redo", "Redo", IconCache.getIcon("redo"), 82, "c-y");
        ActionLibrary.addSystemAction("cut", "Cut", IconCache.getIcon("cut"), 67, "c-x");
        ActionLibrary.addSystemAction("copy", "Copy", IconCache.getIcon("copy"), 79, "c-c");
        ActionLibrary.addSystemAction("paste", "Paste", IconCache.getIcon("paste"), 80, "c-v");
        ActionLibrary.addSystemAction("delete", "Delete", IconCache.getIcon("delete"), 76, "delete");
        ActionLibrary.addSystemAction("indent", "Indent", IconCache.getIcon("indent"), 73, "tab");
        ActionLibrary.addSystemAction("unindent", "Unindent", IconCache.getIcon("unindent"), 84, "s-tab");
        ActionLibrary.addSystemAction("search", "Search", IconCache.getIcon("search"), 83);
        ActionLibrary.addSystemAction("search.quick", "Quick Search", IconCache.getIcon("search.quick"), 81, "c-f");
        ActionLibrary.addSystemAction("search.next", "Search Next", IconCache.getIcon("search.next"), 78);
        ActionLibrary.addSystemAction("search.previous", "Search Previous", IconCache.getIcon("search.previous"), 86);
        ActionLibrary.addSystemAction("jump.to.line", "Jump to Line", IconCache.getIcon("jump.to.line"), 74, "c-l");
        ActionLibrary.addSystemAction("select.all", "Select All", IconCache.getIcon("select.all"), 65, "c-a");
        ActionLibrary.addSystemAction("preferences", "Preferences", IconCache.getIcon("preferences"), 70);
        ActionLibrary.addSystemAction("frame.new", "New Frame", IconCache.getIcon("frame.new"), 70);
        ActionLibrary.addSystemAction("show.menu.bar", "Show Menu Bar", IconCache.getIcon("menu.bar"), 77);
        ActionLibrary.addSystemAction("show.tool.bar", "Show Tool Bar", IconCache.getIcon("tool.bar"), 84);
        ActionLibrary.addSystemAction("frame.close", "Close Frame", IconCache.getIcon("frame.close"), 70);
        ActionLibrary.addSystemAction("area.new", "New Area", IconCache.getIcon("area.new"), 70);
        ActionLibrary.addSystemAction("area.close", "Close Area", IconCache.getIcon("area.close"), 70);
        ActionLibrary.addSystemAction("pane.default", "Set Default", IconCache.getIcon("pane.default"), 68);
        ActionLibrary.addSystemAction("pane.split.vertical", "Split Horizontal", IconCache.getIcon("pane.split.vertical"), 72);
        ActionLibrary.addSystemAction("pane.split.horizontal", "Split Vertical", IconCache.getIcon("pane.split.horizontal"), 86);
        ActionLibrary.addSystemAction("pane.merge.north", "Merge Up", IconCache.getIcon("pane.merge.north"), 85);
        ActionLibrary.addSystemAction("pane.merge.south", "Merge Down", IconCache.getIcon("pane.merge.south"), 87);
        ActionLibrary.addSystemAction("pane.merge.west", "Merge Left", IconCache.getIcon("pane.merge.west"), 76);
        ActionLibrary.addSystemAction("pane.merge.east", "Merge Right", IconCache.getIcon("pane.merge.east"), 82);
        ActionLibrary.addSystemAction("pane.close", "Close Pane", IconCache.getIcon("pane.close"), 67);
        ActionLibrary.addSystemAction("workspace.new", "Workspace View", IconCache.getIcon("workspace"), 87);
        ActionLibrary.addSystemAction("outline.new", "Outline View", IconCache.getIcon("outline"), 79);
        ActionLibrary.addSystemAction("editor.new", "Text Editor", IconCache.getIcon("editor"), 84);
        ActionLibrary.addSystemAction("terminal.new", "Terminal", IconCache.getIcon("terminal"), 67);
        ActionLibrary.addSystemAction("view.new", "New View", IconCache.getIcon("view.new"), 78);
        ActionLibrary.addSystemAction("view.close", "Close View", IconCache.getIcon("view.close"), 67);
        ActionLibrary.addSystemAction("view.options", "View Options", IconCache.getIcon("view.options"), 79);
        ActionLibrary.addSystemAction("compile", "Compile", IconCache.getIcon("compile"), 67);
        ActionLibrary.addSystemAction("build", "Build", IconCache.getIcon("build"), 66, "f8");
        ActionLibrary.addSystemAction("build.all", "Build All", IconCache.getIcon("build.all"), 65, "s-f8");
        ActionLibrary.addSystemAction("build.stop", "Build Stop", IconCache.getIcon("build.stop"), 83, "c-f8");
        ActionLibrary.addSystemAction("run", "Run", IconCache.getIcon("run"), 82, "f9");
        ActionLibrary.addSystemAction("debug", "Debug", IconCache.getIcon("debug"), 68, "s-f9");
        ActionLibrary.addSystemAction("stop", "Stop", IconCache.getIcon("stop"), 83, "c-f9");
        ActionLibrary.addSystemAction("debug.step.over", "Step Over", IconCache.getIcon("step.over"), 86, "f10");
        ActionLibrary.addSystemAction("debug.step.line", "Run to Line", IconCache.getIcon("step.line"), 67, "s-f10");
        ActionLibrary.addSystemAction("debug.step.into", "Step Into", IconCache.getIcon("step.into"), 73, "f11");
        ActionLibrary.addSystemAction("debug.step.out", "Step Out", IconCache.getIcon("step.out"), 79, "s-f11");
        ActionLibrary.addSystemAction("debug.breakpoint", "Toggle Breakpoint", IconCache.getIcon("breakpoint"), 66, "f12");
        ActionLibrary.addSystemAction("help.content", "Contents", IconCache.getIcon("help"), 67, "f1");
        ActionLibrary.addSystemAction("about", "About", IconCache.getIcon("about"), 65, "c-h a");
        moPreferenceChangeHandler.init();
    }

    private static class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moShortcutPreferences = PreferenceEngine.get().getPreferences("/keymap/program");

        public PreferenceChangeHandler() {
            this.moShortcutPreferences.addPreferenceChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            Vector vActions = new Vector();
            Hashtable hashtable = mhProgramActions;
            synchronized (hashtable) {
                vActions.addAll(mhProgramActions.keySet());
            }
            int iCount = mhProgramActions.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                String sKey = (String)vActions.get(iIndex);
                PreferenceEngine.get().initPreference(this.moShortcutPreferences, sKey, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moShortcutPreferences) {
                ProgramAction oAction = (ProgramAction)ActionLibrary.get(sKey);
                if (oAction == null) {
                    return;
                }
                String sOldShortcut = (String)oAction.getValue("shortcut.key.sequence");
                String sNewShortcut = sValue;
                if (sOldShortcut != null) {
                    mhProgramShortcuts.remove(sOldShortcut);
                }
                if (sNewShortcut != null && sNewShortcut != "") {
                    Hashtable hashtable = mhProgramShortcuts;
                    synchronized (hashtable) {
                        mhProgramShortcuts.put(sNewShortcut, oAction);
                        ShortcutGrabber oGrabber = (ShortcutGrabber)MainEngine.get().getResource("shortcut.grabber");
                        if (oGrabber != null) {
                            oGrabber.update();
                        }
                    }
                }
                oAction.putValue("shortcut.key.sequence", sNewShortcut);
            }
        }
    }
}

