/*
 * Decompiled with CFR 0.152.
 */
package novaworx.data;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import novaworx.data.Node;
import novaworx.data.NodeComparator;
import novaworx.data.NodeComparatorAdapter;
import novaworx.data.NodeEvent;
import novaworx.data.NodeFilter;
import novaworx.data.NodeListener;
import novaworx.data.RealNode;

public class ViewNode
implements Node {
    private Node moNode;
    private ViewNode moParent;
    private Vector mvChildren;
    private Vector mvListeners;
    private ChildNodeHandler moChildNodeHandler;
    private DelegateNodeHandler moDelegateNodeHandler;

    public ViewNode(RealNode aoNode) {
        if (aoNode == null) {
            throw new IllegalArgumentException("Node can not be null.");
        }
        this.mvChildren = new Vector();
        this.moNode = aoNode;
        this.moChildNodeHandler = new ChildNodeHandler();
        this.moDelegateNodeHandler = new DelegateNodeHandler();
        aoNode.addNodeListener(this.moDelegateNodeHandler);
    }

    public RealNode getRealNode() {
        Node oNode = this;
        while (oNode instanceof ViewNode) {
            oNode = this.getNode();
        }
        return (RealNode)oNode;
    }

    public Node getNode() {
        return this.moNode;
    }

    private void setParent(ViewNode aoNode) {
        this.moParent = aoNode;
    }

    public Node getParent() {
        return this.moParent;
    }

    public void add(ViewNode aoNode) {
        this.insert(aoNode, this.mvChildren.size());
    }

    public void insert(ViewNode aoNode, int aiIndex) {
        if (aoNode == null) {
            return;
        }
        this.mvChildren.add(aiIndex, aoNode);
        aoNode.setParent(this);
        aoNode.addNodeListener(this.moChildNodeHandler);
        this.triggerNodeChanged();
    }

    public void insertBefore(ViewNode aoNode, ViewNode aoPeer) {
        if (aoPeer == null || aoNode == null) {
            return;
        }
        int iIndex = this.mvChildren.indexOf(aoPeer);
        this.mvChildren.add(iIndex, aoNode);
        aoNode.setParent(this);
        aoNode.addNodeListener(this.moChildNodeHandler);
        this.triggerNodeChanged();
    }

    public void insertAfter(ViewNode aoNode, ViewNode aoPeer) {
        if (aoPeer == null || aoNode == null) {
            return;
        }
        int iIndex = this.mvChildren.indexOf(aoPeer) + 1;
        this.mvChildren.add(iIndex, aoNode);
        aoNode.setParent(this);
        aoNode.addNodeListener(this.moChildNodeHandler);
        this.triggerNodeChanged();
    }

    public int getChildCount() {
        return this.mvChildren == null ? 0 : this.mvChildren.size();
    }

    public Node getChild(int aiIndex) {
        return this.mvChildren == null ? null : (Node)this.mvChildren.get(aiIndex);
    }

    public int getIndex(Node aoNode) {
        if (this.mvChildren == null) {
            return -1;
        }
        int iReturn = -1;
        int iCount = this.mvChildren.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            RealNode oNode = ((Node)this.mvChildren.get(iIndex)).getRealNode();
            if (oNode != aoNode.getRealNode()) continue;
            iReturn = iIndex;
            break;
        }
        return iReturn;
    }

    public boolean contains(Node aoNode) {
        return this.mvChildren != null && this.mvChildren.contains(aoNode);
    }

    public void remove(ViewNode aoNode) {
        if (aoNode == null) {
            return;
        }
        this.mvChildren.remove(aoNode);
        aoNode.setParent(null);
        aoNode.removeNodeListener(this.moChildNodeHandler);
        this.triggerNodeChanged();
    }

    public void clear() {
        for (int iIndex = 0; iIndex < this.mvChildren.size(); ++iIndex) {
            this.remove((ViewNode)this.getChild(0));
        }
    }

    public boolean isModified() {
        return this.moNode.isModified();
    }

    public String get(String asKey) {
        return this.moNode.get(asKey);
    }

    public boolean getBoolean(String asKey) {
        return this.moNode.getBoolean(asKey);
    }

    public int getInt(String asKey) {
        return this.moNode.getInt(asKey);
    }

    public long getLong(String asKey) {
        return this.moNode.getLong(asKey);
    }

    public float getFloat(String asKey) {
        return this.moNode.getFloat(asKey);
    }

    public double getDouble(String asKey) {
        return this.moNode.getDouble(asKey);
    }

    public Enumeration getAttributeKeys() {
        return this.moNode.getAttributeKeys();
    }

    public void setResource(String asKey, Object aoResource) {
        this.moNode.setResource(asKey, aoResource);
    }

    public Object getResource(String asKey) {
        return this.moNode.getResource(asKey);
    }

    public Enumeration getResourceKeys() {
        return this.moNode.getResourceKeys();
    }

    public void copyFrom(Node aoNode) {
        this.moNode.copyFrom(aoNode);
    }

    public void copyFrom(Node aoNode, boolean abReplaceExisting) {
        this.moNode.copyFrom(aoNode, abReplaceExisting);
    }

    public void sort(NodeComparator aoComparator) {
        Collections.sort(this.mvChildren, new NodeComparatorAdapter(aoComparator));
    }

    public void filter(NodeFilter aoFilter) {
        if (aoFilter == null) {
            return;
        }
        Vector vChildren = (Vector)this.mvChildren.clone();
        int iCount = vChildren.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ViewNode oChild = (ViewNode)vChildren.get(iIndex);
            if (aoFilter.accept(oChild)) continue;
            this.remove(oChild);
        }
    }

    public String toString() {
        StringBuffer oBuffer = new StringBuffer();
        String sName = this.getClass().getName();
        oBuffer.append(sName);
        oBuffer.append("( ");
        oBuffer.append("modified=");
        oBuffer.append(this.isModified() ? "true" : "false");
        oBuffer.append(" )");
        return oBuffer.toString();
    }

    public void addNodeListener(NodeListener aoListener) {
        if (this.mvListeners == null) {
            this.mvListeners = new Vector();
        }
        this.mvListeners.add(aoListener);
    }

    public void removeNodeListener(NodeListener aoListener) {
        if (this.mvListeners == null) {
            return;
        }
        this.mvListeners.remove(aoListener);
    }

    private void triggerNodeChanged() {
        NodeEvent oEvent = new NodeEvent(this, 0);
        this.fireNodeEventOccurred(oEvent);
    }

    public void fireNodeEventOccurred(NodeEvent aoEvent) {
        if (this.mvListeners == null) {
            return;
        }
        Vector vListeners = (Vector)this.mvListeners.clone();
        int iCount = vListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((NodeListener)vListeners.get(iIndex)).nodeEventOccurred(aoEvent);
        }
    }

    protected void finalize() {
        this.moNode.removeNodeListener(this.moDelegateNodeHandler);
    }

    public static final ViewNode createView(RealNode aoNode) {
        ViewNode oView = new ViewNode(aoNode.getRealNode());
        int iCount = aoNode.getChildCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Node oChild = aoNode.getChild(iIndex);
            oView.add(ViewNode.createView(oChild.getRealNode()));
        }
        return oView;
    }

    private class DelegateNodeHandler
    implements NodeListener {
        private DelegateNodeHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            ViewNode.this.fireNodeEventOccurred(aoEvent);
        }
    }

    private class ChildNodeHandler
    implements NodeListener {
        private ChildNodeHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            int iEventType = aoEvent.getType();
            switch (iEventType) {
                case 0: 
                case 1: 
                case 2: {
                    ViewNode.this.triggerNodeChanged();
                }
            }
        }
    }
}

