/*
 * Decompiled with CFR 0.152.
 */
package novaworx.data;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import novaworx.data.DataNode;
import novaworx.data.Node;
import novaworx.data.NodeEvent;
import novaworx.data.NodeListener;

public class NodeTreeModel
implements NodeListener,
TreeModel {
    Node moRoot;
    private Vector mvTreeModelListeners;

    public NodeTreeModel(Node aoRoot) {
        this.moRoot = aoRoot;
        this.moRoot.addNodeListener(this);
        this.mvTreeModelListeners = new Vector();
    }

    public void nodeEventOccurred(NodeEvent aoEvent) {
        Vector<Node> vPath = new Vector<Node>();
        for (Node oNode = aoEvent.getNode(); oNode != null; oNode = oNode.getParent()) {
            vPath.add(0, oNode);
        }
        Object[] aPath = vPath.toArray();
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, aPath));
    }

    public Object getRoot() {
        return this.moRoot;
    }

    public Object getChild(Object aoParent, int aiIndex) {
        return ((Node)aoParent).getChild(aiIndex);
    }

    public int getChildCount(Object aoParent) {
        return ((Node)aoParent).getChildCount();
    }

    public int getIndexOfChild(Object aoParent, Object aoChild) {
        return ((Node)aoParent).getIndex((Node)aoChild);
    }

    public boolean isLeaf(Object aoNode) {
        return ((Node)aoNode).getChildCount() == 0;
    }

    public void valueForPathChanged(TreePath aoPath, Object aoValue) {
        ((DataNode)aoPath.getLastPathComponent()).set("name", (String)aoValue);
    }

    public void addTreeModelListener(TreeModelListener aoListener) {
        this.mvTreeModelListeners.add(aoListener);
    }

    public void removeTreeModelListener(TreeModelListener aoListener) {
        this.mvTreeModelListeners.remove(aoListener);
    }

    protected void fireTreeNodesChanged(TreeModelEvent aoEvent) {
        int iCount = this.mvTreeModelListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((TreeModelListener)this.mvTreeModelListeners.get(iIndex)).treeNodesChanged(aoEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent aoEvent) {
        int iCount = this.mvTreeModelListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((TreeModelListener)this.mvTreeModelListeners.get(iIndex)).treeNodesInserted(aoEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent aoEvent) {
        int iCount = this.mvTreeModelListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((TreeModelListener)this.mvTreeModelListeners.get(iIndex)).treeNodesRemoved(aoEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent aoEvent) {
        List oListeners = Collections.unmodifiableList(this.mvTreeModelListeners);
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((TreeModelListener)oListeners.get(iIndex)).treeStructureChanged(aoEvent);
        }
    }

    public void finalize() {
        this.moRoot.removeNodeListener(this);
    }
}

