/*
 * Decompiled with CFR 0.152.
 */
package novaworx.data;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import novaworx.data.Node;
import novaworx.data.NodeComparator;
import novaworx.data.NodeComparatorAdapter;
import novaworx.data.NodeEvent;
import novaworx.data.NodeFilter;
import novaworx.data.NodeListener;
import novaworx.data.RealNode;

public class DataNode
implements RealNode {
    private DataNode moParent;
    private Vector mvChildren;
    private boolean mbModified;
    private int miModified;
    private Hashtable mhAttributes;
    private Hashtable mhResources;
    private Vector mvListeners;
    private boolean mbModifiedFlagEnabled;
    private boolean mbModifyForChildren = true;

    public RealNode getRealNode() {
        return this;
    }

    public void set(String asKey, String asValue) {
        this.setAttribute(asKey, asValue);
    }

    public String get(String asKey) {
        return this.getAttribute(asKey);
    }

    public String get(String asKey, String asDefault) {
        return this.getAttribute(asKey, asDefault);
    }

    public void setBoolean(String asKey, boolean abValue) {
        this.setAttribute(asKey, abValue ? "true" : "false");
    }

    public boolean getBoolean(String asKey) {
        return "true".equals(this.getAttribute(asKey));
    }

    public boolean getBoolean(String asKey, boolean abDefault) {
        return "true".equals(this.getAttribute(asKey, abDefault ? "true" : "false"));
    }

    public void setInt(String asKey, int aiValue) {
        this.setAttribute(asKey, String.valueOf(aiValue));
    }

    public int getInt(String asKey) {
        return Integer.parseInt(this.getAttribute(asKey), 0);
    }

    public int getInt(String asKey, int aiDefault) {
        int iValue = 0;
        iValue = Integer.parseInt(this.getAttribute(asKey, String.valueOf(aiDefault)));
        return iValue;
    }

    public void setLong(String asKey, long alValue) {
        this.setAttribute(asKey, String.valueOf(alValue));
    }

    public long getLong(String asKey) {
        return this.getLong(this.getAttribute(asKey), 0L);
    }

    public long getLong(String asKey, long alDefault) {
        long lValue = 0L;
        lValue = Long.parseLong(this.getAttribute(asKey, String.valueOf(alDefault)));
        return lValue;
    }

    public void setFloat(String asKey, float afValue) {
        this.setAttribute(asKey, String.valueOf(afValue));
    }

    public float getFloat(String asKey) {
        return this.getFloat(this.getAttribute(asKey), 0.0f);
    }

    public float getFloat(String asKey, float afDefault) {
        float fValue = 0.0f;
        fValue = Float.parseFloat(this.getAttribute(asKey, String.valueOf(afDefault)));
        return fValue;
    }

    public void setDouble(String asKey, double adValue) {
        this.setAttribute(asKey, String.valueOf(adValue));
    }

    public double getDouble(String asKey) {
        return this.getDouble(this.getAttribute(asKey), 0.0);
    }

    public double getDouble(String asKey, double adDefault) {
        double dValue = 0.0;
        dValue = Double.parseDouble(this.getAttribute(asKey, String.valueOf(adDefault)));
        return dValue;
    }

    private void setAttribute(String asKey, String asValue) {
        String sCurrentValue;
        if (asKey == null) {
            return;
        }
        String string = sCurrentValue = this.mhAttributes == null ? null : (String)this.mhAttributes.get(asKey);
        if (sCurrentValue == null && asValue == null) {
            return;
        }
        if (sCurrentValue != null && sCurrentValue.equals(asValue)) {
            return;
        }
        if (asValue == null) {
            if (this.mhAttributes != null) {
                this.mhAttributes.remove(asKey);
            }
        } else {
            if (this.mhAttributes == null) {
                this.mhAttributes = new Hashtable();
            }
            this.mhAttributes.put(asKey, asValue);
        }
        this.setModified(true);
    }

    private String getAttribute(String asKey) {
        if (this.mhAttributes == null) {
            return null;
        }
        return (String)this.mhAttributes.get(asKey);
    }

    private String getAttribute(String asKey, String asDefault) {
        String sValue = null;
        if (this.mhAttributes == null) {
            if (asDefault == null) {
                return null;
            }
            this.mhAttributes = new Hashtable();
        } else {
            sValue = (String)this.mhAttributes.get(asKey);
        }
        if (sValue == null && asDefault != null) {
            sValue = asDefault;
            this.setAttribute(asKey, asDefault);
        }
        return sValue;
    }

    public Enumeration getAttributeKeys() {
        return this.mhAttributes == null ? null : this.mhAttributes.keys();
    }

    private void setParent(DataNode aoNode) {
        this.moParent = aoNode;
    }

    public Node getParent() {
        return this.moParent;
    }

    public void add(DataNode aoNode) {
        this.insertNode(aoNode, this.mvChildren == null ? 0 : this.mvChildren.size());
    }

    public void insert(DataNode aoNode, int aiIndex) {
        if (aoNode == null) {
            return;
        }
        if (this.mvChildren == null) {
            this.mvChildren = new Vector();
        }
        this.insertNode(aoNode, aiIndex);
    }

    public void insertBefore(DataNode aoNode, DataNode aoPeer) {
        if (aoPeer == null || aoNode == null) {
            return;
        }
        int iIndex = this.mvChildren.indexOf(aoPeer);
        this.insertNode(aoNode, iIndex);
    }

    public void insertAfter(DataNode aoNode, DataNode aoPeer) {
        if (aoPeer == null || aoNode == null) {
            return;
        }
        int iIndex = this.mvChildren.indexOf(aoPeer) + 1;
        this.insertNode(aoNode, iIndex);
    }

    private void insertNode(DataNode aoNode, int aiIndex) {
        if (aoNode == null) {
            return;
        }
        if (this.mvChildren == null) {
            this.mvChildren = new Vector();
        }
        this.mvChildren.add(aiIndex, aoNode);
        aoNode.setParent(this);
        if (this.mbModifyForChildren) {
            this.setModified(true);
        }
        if (aoNode.isModified()) {
            ++this.miModified;
        }
    }

    public int getChildCount() {
        return this.mvChildren == null ? 0 : this.mvChildren.size();
    }

    public Node getChild(int aiIndex) {
        return this.mvChildren == null ? null : (Node)this.mvChildren.get(aiIndex);
    }

    public int getIndex(Node aoNode) {
        return this.mvChildren == null ? -1 : this.mvChildren.indexOf(aoNode);
    }

    public boolean contains(Node aoNode) {
        return this.mvChildren != null && this.mvChildren.contains(aoNode);
    }

    public void remove(DataNode aoNode) {
        if (aoNode == null || this.mvChildren == null) {
            return;
        }
        this.mvChildren.remove(aoNode);
        aoNode.setParent(null);
        if (this.mbModifyForChildren) {
            this.setModified(true);
        }
        if (aoNode.isModified()) {
            --this.miModified;
        }
    }

    public void clear() {
        if (this.mvChildren == null) {
            return;
        }
        while (this.mvChildren.size() > 0) {
            this.remove((DataNode)this.getChild(0));
        }
    }

    public final void setModified(boolean abModified) {
        boolean bNewState;
        if (!this.mbModifiedFlagEnabled) {
            return;
        }
        if (abModified) {
            this.triggerNodeChanged();
        }
        if (this.isModified() == abModified) {
            return;
        }
        boolean bOldState = this.isModified();
        this.mbModified = abModified;
        if (!abModified) {
            this.miModified = 0;
        }
        if (bOldState != (bNewState = this.isModified()) && this.moParent != null) {
            if (abModified) {
                this.moParent.childModified();
            } else {
                this.moParent.childUnmodified();
            }
        }
        if (this.mvChildren != null && !abModified) {
            Vector vChildren = (Vector)this.mvChildren.clone();
            int iCount = vChildren.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                ((DataNode)vChildren.get(iIndex)).parentUnmodified();
            }
        }
        if (bOldState != bNewState) {
            this.triggerModifiedStateChanged(abModified);
        }
    }

    public final void setModifiedFlagEnabled(boolean abEnabled) {
        this.mbModifiedFlagEnabled = abEnabled;
    }

    public final void setModifyForChildren(boolean abModify) {
        this.mbModifyForChildren = abModify;
    }

    public final boolean isModified() {
        return this.mbModified || this.mbModifyForChildren & this.miModified > 0;
    }

    private boolean isSelfModified() {
        return this.mbModified;
    }

    private boolean isTreeModified() {
        return this.miModified > 0;
    }

    public int getModifiedChildCount() {
        return this.miModified;
    }

    public void addNodeListener(NodeListener aoListener) {
        if (this.mvListeners == null) {
            this.mvListeners = new Vector();
        }
        this.mvListeners.add(aoListener);
    }

    public void removeNodeListener(NodeListener aoListener) {
        if (this.mvListeners == null) {
            return;
        }
        this.mvListeners.remove(aoListener);
    }

    public void setResource(String asKey, Object aoValue) {
        this.setResource(asKey, aoValue, false);
    }

    public void setResource(String asKey, Object aoValue, boolean abTriggerEvent) {
        if (aoValue == null) {
            if (this.mhResources != null) {
                if (this.mhResources.get(asKey) == aoValue) {
                    return;
                }
                this.mhResources.remove(asKey);
            }
        } else {
            if (this.mhResources == null) {
                this.mhResources = new Hashtable();
            }
            if (this.mhResources.get(asKey) == aoValue) {
                return;
            }
            this.mhResources.put(asKey, aoValue);
        }
        if (abTriggerEvent) {
            this.triggerNodeChanged();
        }
    }

    public Object getResource(String asKey) {
        return this.mhResources == null ? null : this.mhResources.get(asKey);
    }

    public Enumeration getResourceKeys() {
        return this.mhResources == null ? null : this.mhResources.keys();
    }

    public void copyFrom(Node aoNode) {
        this.copyFrom(aoNode, true);
    }

    public void copyFrom(Node aoNode, boolean abReplaceExisting) {
        Enumeration oAttributeKeys = aoNode.getAttributeKeys();
        if (oAttributeKeys != null) {
            while (oAttributeKeys.hasMoreElements()) {
                String sKey = (String)oAttributeKeys.nextElement();
                String sValue = aoNode.get(sKey);
                if (this.get(sKey) != null && !abReplaceExisting) continue;
                this.set(sKey, sValue);
            }
        }
    }

    public void sort(NodeComparator aoComparator) {
        if (this.mvChildren == null) {
            return;
        }
        Collections.sort(this.mvChildren, new NodeComparatorAdapter(aoComparator));
    }

    public void filter(NodeFilter aoFilter) {
        if (aoFilter == null) {
            return;
        }
        Vector vChildren = (Vector)this.mvChildren.clone();
        int iCount = vChildren.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            DataNode oChild = (DataNode)vChildren.get(iIndex);
            if (aoFilter.accept(oChild)) continue;
            this.remove(oChild);
        }
    }

    public String toString() {
        StringBuffer oBuffer = new StringBuffer();
        String sName = this.getClass().getName();
        oBuffer.append(sName);
        oBuffer.append("( ");
        oBuffer.append("modified=");
        oBuffer.append(this.mbModified ? "true" : "false");
        oBuffer.append(" modified.children=");
        oBuffer.append(this.miModified);
        oBuffer.append(" )");
        return oBuffer.toString();
    }

    private void childModified() {
        boolean bOldState = this.isModified();
        ++this.miModified;
        boolean bNewState = this.isModified();
        this.triggerChildModifiedStateChanged(true);
        if (bNewState && bNewState != bOldState) {
            if (this.moParent != null) {
                this.moParent.childModified();
            }
            this.triggerModifiedStateChanged(true);
        }
    }

    private final void childUnmodified() {
        boolean bOldState = this.isModified();
        --this.miModified;
        boolean bNewState = this.isModified();
        this.triggerChildModifiedStateChanged(false);
        if (!bNewState && bNewState != bOldState) {
            if (this.moParent != null) {
                this.moParent.childUnmodified();
            }
            this.triggerModifiedStateChanged(false);
        }
    }

    private final void parentUnmodified() {
        this.mbModified = false;
        this.miModified = 0;
        if (this.mvChildren == null) {
            return;
        }
        for (int iIndex = 0; iIndex < this.mvChildren.size(); ++iIndex) {
            ((DataNode)this.mvChildren.get(iIndex)).parentUnmodified();
        }
    }

    protected void triggerNodeChanged() {
        NodeEvent oEvent = new NodeEvent(this, 0);
        this.fireNodeEventOccurred(oEvent);
    }

    protected void triggerModifiedStateChanged(boolean abModified) {
        NodeEvent oEvent = new NodeEvent(this, abModified ? 2 : 1);
        this.fireNodeEventOccurred(oEvent);
        this.triggerNodeChanged();
    }

    protected void triggerChildModifiedStateChanged(boolean abModified) {
        NodeEvent oEvent = new NodeEvent(this, abModified ? 4 : 3);
        this.fireNodeEventOccurred(oEvent);
    }

    private void fireNodeEventOccurred(NodeEvent aoEvent) {
        if (this.mvListeners == null) {
            return;
        }
        Vector vListeners = (Vector)this.mvListeners.clone();
        int iCount = vListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((NodeListener)vListeners.get(iIndex)).nodeEventOccurred(aoEvent);
        }
    }
}

