/*
 * Decompiled with CFR 0.152.
 */
package novaworx.bus;

import java.util.Hashtable;
import java.util.Vector;
import novaworx.bus.Message;
import novaworx.bus.MessageListener;
import novaworx.log.Log;
import novaworx.util.thread.ThreadPool;

public class MessageBus {
    private static Hashtable mhListeners = new Hashtable();
    private static ThreadPool moThreadPool = new ThreadPool(0, 0);
    static /* synthetic */ Class class$novaworx$bus$Message;

    private MessageBus() {
    }

    public static void start() {
        moThreadPool.allow();
    }

    public static void stop() {
        moThreadPool.disallow();
    }

    public static void send(Message aoMessage) {
        MessageBus.dispatchMessage(aoMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchMessage(Message aoMessage) {
        if (aoMessage == null) {
            return;
        }
        Log.write(5, "Dispatch message: " + aoMessage.getClass().getName());
        aoMessage.setAlive(true);
        Vector vListeners = MessageBus.getListeners(aoMessage.getClass());
        if (vListeners == null) {
            return;
        }
        Vector vector = vListeners;
        synchronized (vector) {
            int iCount = vListeners.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                MessageListener oListener = (MessageListener)vListeners.get(iIndex);
                moThreadPool.execute(new MessageRunner(aoMessage, oListener));
            }
        }
        aoMessage.setAlive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(MessageListener aoListener, Class aoClass) {
        if (aoListener == null) {
            throw new IllegalArgumentException("MessageListener can not be null.");
        }
        if (aoClass == null) {
            throw new IllegalArgumentException("Class can not be null.");
        }
        if (!(class$novaworx$bus$Message == null ? (class$novaworx$bus$Message = MessageBus.class$("novaworx.bus.Message")) : class$novaworx$bus$Message).isAssignableFrom(aoClass)) {
            throw new IllegalArgumentException("Class must be assignable from Message.");
        }
        Vector<MessageListener> vListeners = MessageBus.getListeners(aoClass);
        if (vListeners == null) {
            vListeners = new Vector<MessageListener>();
            mhListeners.put(aoClass, vListeners);
        }
        Vector<MessageListener> vector = vListeners;
        synchronized (vector) {
            vListeners.add(aoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(MessageListener aoListener, Class aoClass) {
        if (aoClass == null) {
            throw new IllegalArgumentException("Class can not be null.");
        }
        if (!(class$novaworx$bus$Message == null ? (class$novaworx$bus$Message = MessageBus.class$("novaworx.bus.Message")) : class$novaworx$bus$Message).isAssignableFrom(aoClass)) {
            throw new IllegalArgumentException("Class must be assignable from Message.");
        }
        Vector vListeners = MessageBus.getListeners(aoClass);
        if (vListeners == null) {
            return;
        }
        Vector vector = vListeners;
        synchronized (vector) {
            vListeners.remove(aoListener);
        }
    }

    private static Vector getListeners(Class aoClass) {
        return (Vector)mhListeners.get(aoClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MessageBus.start();
    }

    private static class MessageRunner
    implements Runnable {
        private Message moMessage;
        private MessageListener moListener;

        public MessageRunner(Message aoMessage, MessageListener aoListener) {
            this.moMessage = aoMessage;
            this.moListener = aoListener;
        }

        public void run() {
            this.moMessage.threadIncrement();
            this.moListener.messageReceived(this.moMessage);
            this.moMessage.threadDecrement();
        }
    }
}

