/*
 * Decompiled with CFR 0.152.
 */
package novaworx.bus;

import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Message {
    private boolean mbAlive;
    private int miThreadCount;
    private Object moSource;
    private Throwable moStackTrace;

    public Message(Object aoSource) {
        if (aoSource == null) {
            throw new IllegalArgumentException("Message source can not be null.");
        }
        this.moSource = aoSource;
        this.moStackTrace = new Throwable();
    }

    public Object getSource() {
        return this.moSource;
    }

    protected final synchronized void setAlive(boolean abAlive) {
        this.mbAlive = abAlive;
    }

    public synchronized void threadIncrement() {
        ++this.miThreadCount;
    }

    public synchronized void threadDecrement() {
        --this.miThreadCount;
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (this.mbAlive | this.miThreadCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException aoException) {
                break;
            }
        }
    }

    public String printStackTrace() {
        StringWriter oStringWriter = new StringWriter();
        PrintWriter oPrintWriter = new PrintWriter(oStringWriter);
        this.moStackTrace.printStackTrace(oPrintWriter);
        return oStringWriter.toString();
    }
}

