/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.EventQueue;
import java.util.Hashtable;
import java.util.Vector;
import novaworx.GuiEngine;
import novaworx.Startup;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.log.Log;
import novaworx.resource.Resource;
import novaworx.viewarea.ViewArea;

public final class WorkViewEngine {
    private static WorkViewEngine moInstance;
    private Hashtable mhViewClasses;
    private Vector mvViewInstances;
    private MessageHandler moMessageHandler;
    static /* synthetic */ Class class$novaworx$message$ResourceSelect;
    static /* synthetic */ Class class$novaworx$WorkViewEngine;

    private WorkViewEngine() {
    }

    public static WorkViewEngine get() {
        if (moInstance == null) {
            moInstance = new WorkViewEngine();
        }
        return moInstance;
    }

    public void start() {
        this.mhViewClasses = new Hashtable();
        this.mvViewInstances = new Vector();
        this.moMessageHandler = new MessageHandler();
        String[] aViewNames = new String[]{"novaworx.view.about.About", "novaworx.view.editor.Editor", "novaworx.view.outline.Outline", "novaworx.view.preference.PreferenceManager", "novaworx.view.resource.ResourceView", "novaworx.view.search.SearchView", "novaworx.view.terminal.TerminalView", "novaworx.view.workspace.WorkspaceManager"};
        for (int iIndex = 0; iIndex < aViewNames.length; ++iIndex) {
            this.loadViewClass(aViewNames[iIndex]);
        }
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceSelect == null ? (class$novaworx$message$ResourceSelect = WorkViewEngine.class$("novaworx.message.ResourceSelect")) : class$novaworx$message$ResourceSelect);
    }

    public void stop() {
        int iCount = this.mvViewInstances.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            WorkView workView = (WorkView)this.mvViewInstances.get(0);
        }
    }

    private void loadViewClass(String asViewName) {
        this.loadViewClass(asViewName, (class$novaworx$WorkViewEngine == null ? (class$novaworx$WorkViewEngine = WorkViewEngine.class$("novaworx.WorkViewEngine")) : class$novaworx$WorkViewEngine).getClassLoader());
    }

    private void loadViewClass(String asViewName, ClassLoader aoLoader) {
        Class<?> oClass = null;
        try {
            oClass = Class.forName(asViewName, true, aoLoader);
        }
        catch (ClassNotFoundException aoException) {
            Log.write(2, "View not loaded: " + asViewName);
            return;
        }
        this.mhViewClasses.put(asViewName, oClass);
        Log.write(5, "View loaded: " + asViewName);
        Startup.advanceSplashProgress("View loaded: " + asViewName.substring(asViewName.lastIndexOf(46) + 1));
    }

    private Class getViewClass(String asView) {
        return (Class)this.mhViewClasses.get(asView);
    }

    public boolean hasViewType(String asType) {
        return this.getViewClass(asType) != null;
    }

    private WorkView createView(String asViewName) {
        if (asViewName == null) {
            return null;
        }
        Class oClass = (Class)this.mhViewClasses.get(asViewName);
        if (oClass == null) {
            return null;
        }
        return this.createView(oClass);
    }

    private WorkView createView(Class aoClass) {
        String sViewName = aoClass.getName();
        WorkView oView = null;
        try {
            oView = (WorkView)aoClass.newInstance();
        }
        catch (InstantiationException aoException) {
        }
        catch (IllegalAccessException aoException) {
            // empty catch block
        }
        this.mvViewInstances.add(oView);
        Log.write(5, "View created: " + sViewName);
        return oView;
    }

    private int getViewCount() {
        return this.mvViewInstances.size();
    }

    private WorkView getView(int aiIndex) {
        return (WorkView)this.mvViewInstances.get(aiIndex);
    }

    public void destroyView(WorkView aoView) {
        this.mvViewInstances.remove(aoView);
    }

    private final void lockView(WorkView aoView) {
    }

    private final void unlockView(WorkView aoView) {
    }

    public final WorkView getView(String asView) {
        if (asView == null) {
            return null;
        }
        WorkView oView = null;
        Class oClass = this.getViewClass(asView);
        if (oClass == null) {
            return null;
        }
        if (oView == null) {
            int iViewCount = this.mvViewInstances.size();
            for (int iIndex = 0; iIndex < iViewCount; ++iIndex) {
                WorkView oTestView = (WorkView)this.mvViewInstances.get(iIndex);
                if (oTestView.isAllocated() || oTestView.getClass() != oClass) continue;
                oView = oTestView;
                break;
            }
        }
        if (oView == null) {
            oView = this.createView(oClass);
        }
        this.lockView(oView);
        return oView;
    }

    public void returnView(WorkView aoView) {
        this.unlockView(aoView);
    }

    private WorkView findViewInWorkPane(String asClass, WorkPane aoWorkPane) {
        if (aoWorkPane == null) {
            return null;
        }
        WorkView oView = null;
        Class oClass = this.getViewClass(asClass);
        if (aoWorkPane != null) {
            int iViewCount = aoWorkPane.getViewCount();
            for (int iIndex = 0; iIndex < iViewCount; ++iIndex) {
                WorkView oTestView = aoWorkPane.getView(iIndex);
                if (oTestView.getClass() != oClass) continue;
                oView = oTestView;
                break;
            }
        }
        return oView;
    }

    private WorkView findViewInWorkArea(String asClass, WorkArea aoWorkArea) {
        WorkPane oPane;
        int iIndex;
        if (aoWorkArea == null) {
            return null;
        }
        WorkView oView = null;
        Class oClass = this.getViewClass(asClass);
        ViewArea oViewArea = aoWorkArea.getViewArea();
        int iPaneCount = oViewArea.getViewPaneCount();
        for (iIndex = 0; iIndex < iPaneCount; ++iIndex) {
            oPane = (WorkPane)oViewArea.getViewPane(iIndex);
            WorkView oTestView = oPane.peek();
            if (oTestView == null || oTestView.getClass() != oClass) continue;
            oView = oTestView;
            break;
        }
        if (oView == null) {
            for (iIndex = 0; iIndex < iPaneCount && (oView = this.findViewInWorkPane(asClass, oPane = (WorkPane)oViewArea.getViewPane(iIndex))) == null; ++iIndex) {
            }
        }
        return oView;
    }

    public WorkView getViewForResource(Resource aoResource) {
        WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
        WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
        String sViewType = this.getViewTypeForResource(aoResource);
        WorkView oView = this.findViewInWorkArea(sViewType, oWorkArea);
        if (oView == null) {
            oView = this.getView(sViewType);
        }
        return oView;
    }

    public WorkView getViewForResource(Resource aoResource, WorkArea aoWorkArea) {
        return this.findViewInWorkArea(this.getViewTypeForResource(aoResource), aoWorkArea);
    }

    public WorkView getViewForResource(Resource aoResource, WorkPane aoWorkPane) {
        if (aoWorkPane == null) {
            return this.getViewForResource(aoResource);
        }
        String sViewType = this.getViewTypeForResource(aoResource);
        WorkView oView = this.findViewInWorkPane(sViewType, aoWorkPane);
        if (oView == null) {
            oView = this.getView(sViewType);
        }
        aoWorkPane.push(oView);
        return oView;
    }

    public String getViewTypeForResource(Resource aoResource) {
        return "novaworx.view.editor.Editor";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShowView
    implements Runnable {
        private WorkPane moWorkPane;
        private WorkView moView;

        public ShowView(WorkPane aoWorkPane, WorkView aoView) {
            if (aoWorkPane == null || aoView == null) {
                return;
            }
            this.moWorkPane = aoWorkPane;
            this.moView = aoView;
            EventQueue.invokeLater(this);
        }

        public void run() {
            this.moWorkPane.push(this.moView);
            this.moView.requestFocusInWindow();
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
        }
    }
}

