/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.Container;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JComponent;
import novaworx.WorkPane;
import novaworx.WorkViewException;
import novaworx.log.Log;

public abstract class WorkView
extends JComponent {
    private Icon moIcon;
    private String msTitle;
    private boolean mbAllocated;
    private boolean mbDisplayed;
    private boolean mbSelected;
    private Preferences moPreferences;
    private PreferenceChangeHandler moPreferenceChangeHandler;

    public WorkView() {
        this.setOpaque(false);
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
    }

    public final boolean isAllocated() {
        return this.mbAllocated;
    }

    public final boolean isDisplayed() {
        return this.mbDisplayed;
    }

    public final boolean isSelected() {
        return this.mbSelected;
    }

    protected final void setIcon(Icon aoIcon) {
        this.moIcon = aoIcon;
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane != null) {
            oWorkPane.setIcon(aoIcon);
        }
    }

    public final Icon getIcon() {
        return this.moIcon;
    }

    protected final void setTitle(String asTitle) {
        this.msTitle = asTitle;
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane != null) {
            oWorkPane.setTitle(asTitle);
        }
    }

    public final String getTitle() {
        return this.msTitle;
    }

    public void fireAllocate() {
        if (this.mbAllocated) {
            Log.write(2, "Attemt to allocate an allocated tool: " + this.getClass().getName());
            return;
        }
        try {
            this.allocate();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbAllocated = true;
    }

    public void fireDisplay() {
        if (!this.mbAllocated) {
            Log.write(2, "Attemt to display an unallocated tool: " + this.getClass().getName());
            return;
        }
        try {
            this.display();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbDisplayed = true;
    }

    public void fireSelect() {
        if (!this.mbDisplayed) {
            Log.write(2, "Attemt to select a concealed tool: " + this.getClass().getName());
            return;
        }
        try {
            this.select();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbSelected = true;
    }

    public void fireUnselect() {
        if (!this.mbSelected) {
            Log.write(2, "Attempt to unselect an unselected tool: " + this.getClass().getName());
            return;
        }
        try {
            this.unselect();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbSelected = false;
    }

    public void fireConceal() {
        if (this.mbSelected) {
            this.fireUnselect();
        }
        if (!this.mbDisplayed) {
            Log.write(2, "Attemt to conceal a concealed tool: " + this.getClass().getName());
            return;
        }
        try {
            this.conceal();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbDisplayed = false;
    }

    public void fireDeallocate() {
        if (this.mbDisplayed) {
            this.fireConceal();
        }
        if (!this.mbAllocated) {
            Log.write(2, "Attemt to deallocate a deallocated tool: " + this.getClass().getName());
            return;
        }
        try {
            this.deallocate();
        }
        catch (WorkViewException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        this.mbAllocated = false;
    }

    protected void allocate() throws WorkViewException {
    }

    protected void display() throws WorkViewException {
    }

    protected void select() throws WorkViewException {
    }

    protected void unselect() throws WorkViewException {
    }

    protected void conceal() throws WorkViewException {
    }

    protected void deallocate() throws WorkViewException {
    }

    public WorkPane getWorkPane() {
        Container oParent;
        for (oParent = this.getParent(); oParent != null && !(oParent instanceof WorkPane); oParent = oParent.getParent()) {
        }
        return oParent == null ? null : (WorkPane)oParent;
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        if (aoPreferences == this.moPreferences) {
            return;
        }
        this.moPreferences = aoPreferences;
        if (aoPreferences != null) {
            this.loadPreferences(aoPreferences, aoDefaultPreferences);
            this.moPreferenceChangeHandler.init(aoPreferences, aoDefaultPreferences);
        }
    }

    public Preferences getPreferences() {
        return this.moPreferences;
    }

    protected void loadPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private PreferenceChangeHandler() {
        }

        public void init(Preferences aoPreferences, Preferences aoDefaultPreferences) {
            aoPreferences.addPreferenceChangeListener(this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == WorkView.this.moPreferences) {
                // empty if block
            }
        }
    }
}

