/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.WorkArea;
import novaworx.WorkView;
import novaworx.WorkViewEngine;
import novaworx.bus.MessageBus;
import novaworx.gui.ActionLibrary;
import novaworx.gui.ProgramAction;
import novaworx.log.Log;
import novaworx.message.RequestResourceOpen;
import novaworx.resource.Resource;
import novaworx.viewarea.DefaultViewPane;
import novaworx.viewarea.ViewHeader;
import novaworx.viewarea.ViewPane;

public class WorkPane
extends DefaultViewPane {
    private Vector mvViews = new Vector();
    private CardLayout moLayout = new CardLayout();
    private DropHandler moDropHandler = new DropHandler();
    private NewViewAction moNewWorkspaceViewAction;
    private NewViewAction moNewOutlineViewAction;
    private NewViewAction moNewEditorViewAction;
    private NewViewAction moNewTerminalViewAction;
    private CloseViewAction moCloseViewAction;

    public WorkPane(ViewHeader aoViewHeader) {
        super(aoViewHeader);
        this.getContentPane().setLayout(this.moLayout);
        this.getContentPane().setDropTarget(this.moDropHandler);
        this.moCloseViewAction = new CloseViewAction();
        this.moNewWorkspaceViewAction = new NewViewAction("novaworx.view.workspace.WorkspaceManager");
        this.moNewOutlineViewAction = new NewViewAction("novaworx.view.outline.Outline");
        this.moNewEditorViewAction = new NewViewAction("novaworx.view.editor.Editor");
        this.moNewTerminalViewAction = new NewViewAction("novaworx.view.terminal.TerminalView");
    }

    protected void select() {
        WorkView oWorkView = this.peek();
        if (oWorkView != null) {
            oWorkView.fireSelect();
        }
        ((ProgramAction)ActionLibrary.get("view.close")).pushListener(this.moCloseViewAction, this.getViewCount() > 0);
        ((ProgramAction)ActionLibrary.get("workspace.new")).pushListener(this.moNewWorkspaceViewAction);
        ((ProgramAction)ActionLibrary.get("outline.new")).pushListener(this.moNewOutlineViewAction);
        ((ProgramAction)ActionLibrary.get("editor.new")).pushListener(this.moNewEditorViewAction);
        ((ProgramAction)ActionLibrary.get("terminal.new")).pushListener(this.moNewTerminalViewAction);
    }

    protected void unselect() {
        ((ProgramAction)ActionLibrary.get("view.close")).pullListener(this.moCloseViewAction);
        ((ProgramAction)ActionLibrary.get("workspace.new")).pullListener(this.moNewWorkspaceViewAction);
        ((ProgramAction)ActionLibrary.get("outline.new")).pullListener(this.moNewOutlineViewAction);
        ((ProgramAction)ActionLibrary.get("editor.new")).pullListener(this.moNewEditorViewAction);
        ((ProgramAction)ActionLibrary.get("terminal.new")).pullListener(this.moNewTerminalViewAction);
        WorkView oWorkView = this.peek();
        if (oWorkView != null) {
            oWorkView.fireUnselect();
        }
    }

    public synchronized void push(WorkView aoView) {
        if (aoView == null || aoView == this.peek()) {
            return;
        }
        if (this.mvViews.size() > 0) {
            this.peek().fireConceal();
        }
        String sName = this.getViewName(aoView);
        WorkPane oWorkPane = aoView.getWorkPane();
        if (oWorkPane == this) {
            this.mvViews.remove(aoView);
        } else {
            if (oWorkPane != null) {
                oWorkPane.pull(aoView);
            }
            this.getContentPane().add((Component)aoView, sName);
            aoView.fireAllocate();
        }
        this.mvViews.add(0, aoView);
        this.ensureDropHandler(aoView);
        aoView.fireDisplay();
        if (this.isSelected()) {
            aoView.fireSelect();
        }
        this.moLayout.show(this.getContentPane(), sName);
        this.setIcon(aoView.getIcon());
        this.setTitle(aoView.getTitle());
        this.revalidate();
        this.repaint();
        if (this.isSelected()) {
            aoView.fireSelect();
        }
        this.savePreferences();
        ActionLibrary.get("view.close").setEnabled(this.getViewCount() > 0);
    }

    public synchronized WorkView pull(WorkView aoView) {
        if (aoView == null || !this.hasView(aoView)) {
            return null;
        }
        if (this.mvViews.size() > 1 && this.peek() == aoView) {
            this.push((WorkView)this.mvViews.get(1));
        }
        aoView.fireDeallocate();
        this.getContentPane().remove(aoView);
        this.mvViews.remove(aoView);
        if (this.mvViews.size() == 0) {
            this.repaint();
            this.setIcon(null);
            this.setTitle(null);
            this.getContentPane().setDropTarget(this.moDropHandler);
        }
        this.savePreferences();
        ActionLibrary.get("view.close").setEnabled(this.getViewCount() > 0);
        return aoView;
    }

    public synchronized WorkView peek() {
        return this.mvViews.size() == 0 ? null : (WorkView)this.mvViews.get(0);
    }

    protected void drop(ViewPane aoSourcePane, ViewPane aoNewPane) {
        super.drop(aoSourcePane, aoNewPane);
        if (aoSourcePane instanceof WorkPane && aoNewPane instanceof WorkPane) {
            ((WorkPane)aoNewPane).push(((WorkPane)aoSourcePane).peek());
        }
    }

    public WorkView getView(int aiIndex) {
        return (WorkView)this.mvViews.get(aiIndex);
    }

    public boolean hasView(WorkView aoView) {
        return this.mvViews.contains(aoView);
    }

    private String getViewName(WorkView aoView) {
        return String.valueOf(aoView.hashCode()).intern();
    }

    public int getViewCount() {
        return this.mvViews.size();
    }

    public WorkArea getWorkArea() {
        Container oParent;
        for (oParent = this.getParent(); oParent != null && !(oParent instanceof WorkArea); oParent = oParent.getParent()) {
        }
        return (WorkArea)oParent;
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        int iIndex;
        super.setPreferences(aoPreferences, aoDefaultPreferences);
        if (aoPreferences == null) {
            return;
        }
        PreferenceEngine oPreferenceEngine = PreferenceEngine.get();
        int iViewCount = oPreferenceEngine.getIntegerValue(aoPreferences, "workpane.view.count", aoDefaultPreferences, 0);
        if (iViewCount == 0) {
            this.savePreferences();
            return;
        }
        int iOldViewCount = this.mvViews.size();
        for (iIndex = 0; iIndex < iOldViewCount; ++iIndex) {
            WorkView oView = this.pull((WorkView)this.mvViews.get(0));
        }
        for (iIndex = iViewCount - 1; iIndex >= 0; --iIndex) {
            Preferences oViewPreferences = aoPreferences.node("view-" + iIndex);
            Preferences oViewDefaultPreferences = aoDefaultPreferences.node("view-" + iIndex);
            String sClass = oPreferenceEngine.getStringValue(oViewPreferences, "class", oViewDefaultPreferences, null);
            WorkView oView = WorkViewEngine.get().getView(sClass);
            if (oView == null) continue;
            oView.setPreferences(oViewPreferences, oViewDefaultPreferences);
            this.push(oView);
        }
    }

    private void savePreferences() {
        int iViewCount = this.mvViews.size();
        Preferences oPreferences = this.getPreferences();
        try {
            for (int iIndex = 0; iIndex < iViewCount; ++iIndex) {
                ((WorkView)this.mvViews.get(iIndex)).setPreferences(null, null);
            }
            String[] aKeys = oPreferences.keys();
            for (int iIndex = 0; iIndex < aKeys.length; ++iIndex) {
                if (!aKeys[iIndex].startsWith("workpane")) continue;
                oPreferences.remove(aKeys[iIndex]);
            }
            String[] aNodeNames = oPreferences.childrenNames();
            for (int iIndex = 0; iIndex < aNodeNames.length; ++iIndex) {
                if (!aNodeNames[iIndex].startsWith("view")) continue;
                oPreferences.node(aNodeNames[iIndex]).removeNode();
            }
        }
        catch (BackingStoreException aoException) {
            Log.write(2, (Throwable)aoException);
        }
        oPreferences.putInt("workpane.view.count", iViewCount);
        for (int iIndex = 0; iIndex < iViewCount; ++iIndex) {
            WorkView oView = (WorkView)this.mvViews.get(iIndex);
            Preferences oViewPreferences = oPreferences.node("view-" + iIndex);
            oViewPreferences.put("class", oView.getClass().getName());
            oView.setPreferences(oViewPreferences, null);
        }
    }

    private void ensureDropHandler(WorkView aoView) {
        aoView.setDropTarget(this.moDropHandler);
    }

    private class DropHandler
    extends DropTarget {
        public void drop(DropTargetDropEvent aoEvent) {
            aoEvent.acceptDrop(aoEvent.getDropAction());
            DataFlavor[] aDataFlavors = aoEvent.getCurrentDataFlavors();
            Transferable oTransferable = aoEvent.getTransferable();
            List oFileList = null;
            for (int iIndex = 0; iIndex < aDataFlavors.length; ++iIndex) {
                DataFlavor oFlavor = aDataFlavors[iIndex];
                if (!oFlavor.isFlavorJavaFileListType()) continue;
                try {
                    Object oData = oTransferable.getTransferData(oFlavor);
                    oFileList = (List)oData;
                    break;
                }
                catch (UnsupportedFlavorException aoException) {
                    Log.write(aoException);
                    continue;
                }
                catch (IOException aoException) {
                    Log.write(aoException);
                }
            }
            Resource[] aResources = null;
            if (oFileList != null) {
                int iCount = oFileList.size();
                aResources = new Resource[iCount];
                for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                    File oFile = (File)oFileList.get(iIndex);
                    try {
                        Log.write(5, "Resource specified: " + oFile.toString());
                        oFile = oFile.getCanonicalFile();
                        aResources[iIndex] = ResourceEngine.get().createResource(oFile);
                        continue;
                    }
                    catch (IOException aoException) {
                        Log.write(aoException);
                    }
                }
            }
            if (aResources != null) {
                RequestResourceOpen message = new RequestResourceOpen((Object)WorkPane.this, aResources, WorkPane.this);
                MessageBus.send(message);
            }
        }
    }

    public class CloseViewAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            WorkPane.this.pull(WorkPane.this.peek());
        }
    }

    public class NewViewAction
    extends AbstractAction {
        private String msViewClassName;

        public NewViewAction(String asViewClassName) {
            this.msViewClassName = asViewClassName;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkView oView = WorkViewEngine.get().getView(this.msViewClassName);
            WorkPane.this.push(oView);
        }
    }
}

