/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JMenuBar;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.Utilities;
import novaworx.Version;
import novaworx.WorkArea;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramAction;
import novaworx.log.Log;
import novaworx.message.RequestGuiRevalidate;
import novaworx.message.RequestProgramExit;
import novaworx.message.RequestProgramHalt;
import novaworx.swing.XFrame;

public final class WorkFrame
extends XFrame {
    public static final String PREFERENCE_PREFIX = "frame";
    private Vector mvWorkAreas;
    private WorkArea moSelectedWorkArea;
    private FrameCloseAction moFrameCloseAction;
    private WindowHandler moWindowHandler;
    private ComponentHandler moComponentHandler;
    private MessageHandler moMessageHandler;
    private Preferences moPreferences;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    static /* synthetic */ Class class$novaworx$message$RequestGuiRevalidate;
    static /* synthetic */ Class class$novaworx$WorkFrame;

    public WorkFrame() {
        this.setIconImage(IconCache.createIconImage(IconCache.getIcon("novaworx", 16)));
        this.setTitle(Version.name());
        this.setDefaultCloseOperation(0);
        this.mvWorkAreas = new Vector();
        this.moFrameCloseAction = new FrameCloseAction();
        this.moWindowHandler = new WindowHandler();
        this.addWindowListener(this.moWindowHandler);
        this.addWindowFocusListener(this.moWindowHandler);
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$RequestGuiRevalidate == null ? (class$novaworx$message$RequestGuiRevalidate = WorkFrame.class$("novaworx.message.RequestGuiRevalidate")) : class$novaworx$message$RequestGuiRevalidate);
        this.moComponentHandler = new ComponentHandler();
        this.addComponentListener(this.moComponentHandler);
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
    }

    public void setWorkArea(WorkArea aoWorkArea) {
        if (aoWorkArea == null) {
            throw new IllegalArgumentException("WorkArea can not be null.");
        }
        if (this.moSelectedWorkArea == aoWorkArea) {
            aoWorkArea.requestFocusInWindow();
            return;
        }
        if (this.moSelectedWorkArea != null) {
            this.moSelectedWorkArea.unselect();
        }
        this.setRootPane(aoWorkArea);
        this.moSelectedWorkArea = aoWorkArea;
        aoWorkArea.select();
        aoWorkArea.requestFocusInWindow();
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        if (aoPreferences == this.moPreferences) {
            return;
        }
        this.moPreferences = aoPreferences;
        if (aoPreferences != null) {
            this.loadPreferences(aoPreferences, aoDefaultPreferences);
            this.moPreferences.addPreferenceChangeListener(this.moPreferenceChangeHandler);
            this.moPreferenceChangeHandler.init(aoPreferences, aoDefaultPreferences);
        }
    }

    public Preferences getPreferences() {
        return this.moPreferences;
    }

    private void loadPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        int iWorkAreaCount = PreferenceEngine.get().getIntegerValue(aoPreferences, "workarea.count", aoDefaultPreferences);
        int iSelectedWorkArea = PreferenceEngine.get().getIntegerValue(aoPreferences, "workarea.active", aoDefaultPreferences);
        for (int iIndex = 0; iIndex < iWorkAreaCount; ++iIndex) {
            String sPreferencesKey = "workarea-" + iIndex;
            Preferences oPreferences = aoPreferences.node(sPreferencesKey);
            Preferences oDefaultPreferences = aoDefaultPreferences.node("workarea-" + iIndex);
            WorkArea oWorkArea = new WorkArea();
            this.mvWorkAreas.add(oWorkArea);
            oWorkArea.setPreferences(oPreferences, oDefaultPreferences);
            if (iIndex != iSelectedWorkArea) continue;
            this.setWorkArea(oWorkArea);
        }
    }

    public WorkArea[] getWorkAreas() {
        return this.mvWorkAreas.toArray(new WorkArea[this.mvWorkAreas.size()]);
    }

    public WorkArea getSelectedWorkArea() {
        return this.moSelectedWorkArea;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ((ProgramAction)ActionLibrary.get("exit")).pushListener(new ExitAction());
        ((ProgramAction)ActionLibrary.get("halt")).pushListener(new HaltAction());
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private PreferenceChangeHandler() {
        }

        public void init(Preferences aoPreferences, Preferences aoDefaultPreferences) {
            PreferenceEngine.get().initPreference(WorkFrame.this.moPreferences, "w", this, aoDefaultPreferences);
            PreferenceEngine.get().initPreference(WorkFrame.this.moPreferences, "h", this, aoDefaultPreferences);
            PreferenceEngine.get().initPreference(WorkFrame.this.moPreferences, "x", this, aoDefaultPreferences);
            PreferenceEngine.get().initPreference(WorkFrame.this.moPreferences, "y", this, aoDefaultPreferences);
            PreferenceEngine.get().initPreference(WorkFrame.this.moPreferences, "menu.bar", this, aoDefaultPreferences);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == WorkFrame.this.moPreferences) {
                Rectangle oBounds = WorkFrame.this.getBounds();
                WorkFrame.this.removeComponentListener(WorkFrame.this.moComponentHandler);
                if ("x".equals(sKey)) {
                    if ("center".equals(sValue)) {
                        Dimension oScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        oBounds.x = (oScreenSize.width - oBounds.width) / 2;
                    } else {
                        try {
                            oBounds.x = Integer.parseInt(sValue);
                        }
                        catch (NumberFormatException aoException) {
                            Log.write(3, (Throwable)aoException);
                        }
                    }
                    WorkFrame.this.setBounds(oBounds);
                } else if ("y".equals(sKey)) {
                    if ("center".equals(sValue)) {
                        Dimension oScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        oBounds.y = (oScreenSize.height - oBounds.height) / 2;
                    } else {
                        try {
                            oBounds.y = Integer.parseInt(sValue);
                        }
                        catch (NumberFormatException aoException) {
                            Log.write(3, (Throwable)aoException);
                        }
                    }
                    WorkFrame.this.setBounds(oBounds);
                } else if ("w".equals(sKey)) {
                    try {
                        oBounds.width = Integer.parseInt(sValue);
                    }
                    catch (NumberFormatException aoException) {
                        Log.write(3, (Throwable)aoException);
                    }
                    WorkFrame.this.setBounds(oBounds);
                } else if ("h".equals(sKey)) {
                    try {
                        oBounds.height = Integer.parseInt(sValue);
                    }
                    catch (NumberFormatException aoException) {
                        Log.write(3, (Throwable)aoException);
                    }
                    WorkFrame.this.setBounds(oBounds);
                } else if ("menu.bar".equals(sKey)) {
                    JMenuBar oMenuBar = GuiEngine.get().createMenuBar(sValue);
                    WorkFrame.this.setJMenuBar(oMenuBar);
                }
                WorkFrame.this.addComponentListener(WorkFrame.this.moComponentHandler);
            }
            WorkFrame.this.repaint();
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof RequestGuiRevalidate) {
                Log.write(5, "Revalidating work frame...");
                Utilities.invalidateContainerTree(WorkFrame.this.getContentPane());
                WorkFrame.this.validate();
                Log.write(5, "Work frame revalidated.");
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        public void componentMoved(ComponentEvent aoEvent) {
            if (WorkFrame.this.moPreferences == null) {
                return;
            }
            Rectangle oBounds = WorkFrame.this.getBounds();
            WorkFrame.this.moPreferences.removePreferenceChangeListener(WorkFrame.this.moPreferenceChangeHandler);
            WorkFrame.this.moPreferences.putInt("x", oBounds.x);
            WorkFrame.this.moPreferences.putInt("y", oBounds.y);
            WorkFrame.this.moPreferences.addPreferenceChangeListener(WorkFrame.this.moPreferenceChangeHandler);
        }

        public void componentResized(ComponentEvent aoEvent) {
            if (WorkFrame.this.moPreferences == null) {
                return;
            }
            Rectangle oBounds = WorkFrame.this.getBounds();
            WorkFrame.this.moPreferences.removePreferenceChangeListener(WorkFrame.this.moPreferenceChangeHandler);
            WorkFrame.this.moPreferences.putInt("w", oBounds.width);
            WorkFrame.this.moPreferences.putInt("h", oBounds.height);
            WorkFrame.this.moPreferences.addPreferenceChangeListener(WorkFrame.this.moPreferenceChangeHandler);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowGainedFocus(WindowEvent aoEvent) {
            ((ProgramAction)ActionLibrary.get("frame.close")).pushListener(WorkFrame.this.moFrameCloseAction);
        }

        public void windowClosing(WindowEvent aoEvent) {
            String sCommand = ((ProgramAction)ActionLibrary.get("frame.close")).getCommand();
            WorkFrame.this.moFrameCloseAction.actionPerformed(new ActionEvent(aoEvent.getSource(), aoEvent.getID(), sCommand));
        }
    }

    private static class HaltAction
    extends AbstractAction {
        private HaltAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            MessageBus.send(new RequestProgramHalt(class$novaworx$WorkFrame == null ? (class$novaworx$WorkFrame = WorkFrame.class$("novaworx.WorkFrame")) : class$novaworx$WorkFrame));
        }
    }

    private static class ExitAction
    extends AbstractAction {
        private ExitAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            MessageBus.send(new RequestProgramExit(class$novaworx$WorkFrame == null ? (class$novaworx$WorkFrame = WorkFrame.class$("novaworx.WorkFrame")) : class$novaworx$WorkFrame));
        }
    }

    private class FrameCloseAction
    extends AbstractAction {
        private FrameCloseAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            if (GuiEngine.get().getWorkFrames().length > 1) {
                WorkFrame.this.setVisible(false);
            } else {
                MessageBus.send(new RequestProgramExit(class$novaworx$WorkFrame == null ? (class$novaworx$WorkFrame = WorkFrame.class$("novaworx.WorkFrame")) : class$novaworx$WorkFrame));
            }
        }
    }
}

