/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.WorkAreaFactory;
import novaworx.WorkPane;
import novaworx.bus.Message;
import novaworx.bus.MessageListener;
import novaworx.gui.ActionLibrary;
import novaworx.gui.ProgramAction;
import novaworx.gui.UtilityBar;
import novaworx.log.Log;
import novaworx.resource.Resource;
import novaworx.swing.XColor;
import novaworx.swing.XMenuBar;
import novaworx.swing.XPanel;
import novaworx.swing.XRootPane;
import novaworx.swing.XToolBar;
import novaworx.swing.XWallpaper;
import novaworx.viewarea.ViewArea;

public final class WorkArea
extends XRootPane {
    private static Vector mvWorkPanes;
    private MessageHandler moMessageHandler;
    private Preferences moPreferences;
    private PreferenceChangeHandler moPreferenceChangeHandler = new PreferenceChangeHandler();
    private XWallpaper moWallpaper = new XWallpaper();
    private XMenuBar moMenuBar;
    private XToolBar moToolBar;
    private XRootPane moRootPane;
    private ViewArea moViewArea;
    private XPanel moViewAreaBorderPanel;
    private UtilityBar moUtilityBar;
    private XPanel moUtilityBarBorderPanel;

    public WorkArea() {
        this.setContentPane(this.moWallpaper);
        this.moViewArea = new ViewArea(new WorkAreaFactory());
        this.moRootPane = new XRootPane();
        this.moRootPane.setContentPane(this.moViewArea);
        this.moViewAreaBorderPanel = new XPanel(new BorderLayout());
        this.moViewAreaBorderPanel.setOpaque(false);
        this.moViewAreaBorderPanel.setBackground(new XColor(UIManager.getColor("control"), 0));
        this.moViewAreaBorderPanel.add((Component)this.moRootPane, "Center");
        this.getContentPane().add((Component)this.moViewAreaBorderPanel, "Center");
        this.moUtilityBar = new UtilityBar();
        this.moUtilityBarBorderPanel = new XPanel();
        this.moUtilityBarBorderPanel.setLayout(new BorderLayout());
        this.moUtilityBarBorderPanel.add((Component)this.moUtilityBar, "Center");
        this.setUtilityBarDividerSize(3);
        this.getContentPane().add((Component)this.moUtilityBarBorderPanel, "South");
        this.setLookAndFeelValues();
    }

    void select() {
        ActionMap oActionMap = this.moViewArea.getActionMap();
        ((ProgramAction)ActionLibrary.get("pane.default")).pushListener(oActionMap.get("default.pane"));
        ((ProgramAction)ActionLibrary.get("pane.split.horizontal")).pushListener(oActionMap.get("split.horizontal"));
        ((ProgramAction)ActionLibrary.get("pane.split.vertical")).pushListener(oActionMap.get("split.vertical"));
        ((ProgramAction)ActionLibrary.get("pane.merge.north")).pushListener(oActionMap.get("merge.north"));
        ((ProgramAction)ActionLibrary.get("pane.merge.south")).pushListener(oActionMap.get("merge.south"));
        ((ProgramAction)ActionLibrary.get("pane.merge.east")).pushListener(oActionMap.get("merge.east"));
        ((ProgramAction)ActionLibrary.get("pane.merge.west")).pushListener(oActionMap.get("merge.west"));
        ((ProgramAction)ActionLibrary.get("pane.close")).pushListener(oActionMap.get("close"));
    }

    void unselect() {
        ActionMap oActionMap = this.moViewArea.getActionMap();
        ((ProgramAction)ActionLibrary.get("pane.default")).pullListener(oActionMap.get("default.pane"));
        ((ProgramAction)ActionLibrary.get("pane.split.horizontal")).pullListener(oActionMap.get("split.horizontal"));
        ((ProgramAction)ActionLibrary.get("pane.split.vertical")).pullListener(oActionMap.get("split.vertical"));
        ((ProgramAction)ActionLibrary.get("pane.merge.north")).pullListener(oActionMap.get("merge.north"));
        ((ProgramAction)ActionLibrary.get("pane.merge.south")).pullListener(oActionMap.get("merge.south"));
        ((ProgramAction)ActionLibrary.get("pane.merge.east")).pullListener(oActionMap.get("merge.east"));
        ((ProgramAction)ActionLibrary.get("pane.merge.west")).pullListener(oActionMap.get("merge.west"));
        ((ProgramAction)ActionLibrary.get("pane.close")).pullListener(oActionMap.get("close"));
    }

    public void setToolBar(JToolBar aoToolBar) {
        aoToolBar.setFloatable(false);
        this.getContentPane().add((Component)aoToolBar, "North");
    }

    public XWallpaper getWallpaper() {
        return this.moWallpaper;
    }

    public ViewArea getViewArea() {
        return this.moViewArea;
    }

    public UtilityBar getUtilityBar() {
        return this.moUtilityBar;
    }

    public JRootPane getRootPane() {
        return this.moRootPane;
    }

    public void setSelectedWorkPane(WorkPane aoWorkPane) {
        this.moViewArea.setSelectedViewPane(aoWorkPane);
    }

    public WorkPane getSelectedWorkPane() {
        return (WorkPane)this.moViewArea.getSelectedViewPane();
    }

    public void setDefaultWorkPane(WorkPane aoWorkPane) {
        this.moViewArea.setDefaultViewPane(aoWorkPane);
    }

    public WorkPane getDefaultWorkPane() {
        return (WorkPane)this.moViewArea.getDefaultViewPane();
    }

    public WorkPane getLargestWorkPane() {
        return (WorkPane)this.moViewArea.getLargestViewPane();
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        if (aoPreferences == this.moPreferences) {
            return;
        }
        this.moPreferences = aoPreferences;
        if (aoPreferences != null) {
            this.loadPreferences(aoPreferences, aoDefaultPreferences);
            this.moPreferenceChangeHandler.init(aoPreferences, aoDefaultPreferences);
        }
        this.moViewArea.setPreferences(aoPreferences, aoDefaultPreferences);
    }

    public Preferences getPreferences() {
        return this.moPreferences;
    }

    private void loadPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
    }

    public void setUtilityBarDividerSize(int aiSize) {
        this.moViewAreaBorderPanel.setBorder(new MatteBorder(aiSize, aiSize, aiSize, aiSize, UIManager.getColor("control")));
        this.revalidate();
        this.repaint();
    }

    public void setAntiAliasText(boolean abAntiAliasText) {
        this.putClientProperty("anti.alias.text", new Boolean(abAntiAliasText));
        this.repaint();
    }

    public boolean isAntiAliasText() {
        return (Boolean)this.getClientProperty("anti.alias.text");
    }

    public void updateUI() {
        this.setLookAndFeelValues();
    }

    private void setLookAndFeelValues() {
        if (this.moViewAreaBorderPanel != null) {
            this.moViewAreaBorderPanel.setBorder(new MatteBorder(this.moViewAreaBorderPanel.getBorder().getBorderInsets(this.moViewAreaBorderPanel), UIManager.getColor("control")));
        }
        if (this.moUtilityBar != null) {
            this.moUtilityBar.setBorder(new MatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")));
        }
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moLookAndFeelPreferences = PreferenceEngine.get().getPreferences("/program/lookandfeel");
        private Preferences moWorkAreaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");
        private Preferences moWallpaperPreferences = PreferenceEngine.get().getPreferences("/program/workarea/wallpaper");

        public void init(Preferences aoPreferences, Preferences aoDefaultPreferences) {
            aoPreferences.addPreferenceChangeListener(this);
            this.moLookAndFeelPreferences.addPreferenceChangeListener(this);
            this.moWorkAreaPreferences.addPreferenceChangeListener(this);
            this.moWallpaperPreferences.addPreferenceChangeListener(this);
            PreferenceEngine.get().initPreference(aoPreferences, "tool.bar", this, aoDefaultPreferences);
            PreferenceEngine.get().initPreference(this.moLookAndFeelPreferences, "antialias", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "caret", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "orientation", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "divider.size", this);
            PreferenceEngine.get().initPreference(this.moWallpaperPreferences, "image", this);
            PreferenceEngine.get().initPreference(this.moWallpaperPreferences, "orientation", this);
            PreferenceEngine.get().initPreference(this.moWallpaperPreferences, "style", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == WorkArea.this.moPreferences) {
                if ("tool.bar".equals(sKey)) {
                    XToolBar oToolBar = GuiEngine.get().createToolBar(sValue);
                    WorkArea.this.setToolBar(oToolBar);
                }
            } else if (oPreferences == this.moLookAndFeelPreferences) {
                if ("name".equals(sKey)) {
                    GuiEngine.get().setLookAndFeel(sValue);
                } else if ("antialias".equals(sKey)) {
                    WorkArea.this.setAntiAliasText("true".equals(sValue));
                }
            } else if (oPreferences == this.moWorkAreaPreferences) {
                if ("default".equals(sKey)) {
                    Color oForeground = XColor.decodeForeground(sValue);
                    Color oBackground = XColor.decodeBackground(sValue);
                    WorkArea.this.setBackground(XColor.decodeBackground(sValue));
                    WorkArea.this.moWallpaper.setBackground(oBackground);
                    WorkArea.this.moWallpaper.setOpacity((double)(255 - oBackground.getAlpha()) / 255.0);
                } else if ("highlight".equals(sKey)) {
                    Color oForeground = XColor.decodeForeground(sValue);
                    Color oBackground = XColor.decodeBackground(sValue);
                } else if (!"textfield".equals(sKey)) {
                    if ("selection".equals(sKey)) {
                        Color oForeground = XColor.decodeForeground(sValue);
                        Color oBackground = XColor.decodeBackground(sValue);
                        WorkArea.this.moUtilityBar.setSelectionForeground(oForeground);
                        WorkArea.this.moUtilityBar.setSelectionBackground(oBackground);
                    } else if ("caret".equals(sKey)) {
                        WorkArea.this.moUtilityBar.setCaretColor(XColor.decode(sValue));
                    } else if ("orientation".equals(sKey)) {
                        WorkArea.this.moViewArea.setOrientation(Integer.parseInt(sValue));
                    } else if ("divider.size".equals(sKey)) {
                        WorkArea.this.moViewArea.setDividerSize(Integer.parseInt(sValue));
                        WorkArea.this.setUtilityBarDividerSize(Integer.parseInt(sValue));
                    }
                }
            } else if (oPreferences == this.moWallpaperPreferences) {
                if ("image".equals(sKey)) {
                    Resource oResource = ResourceEngine.get().createResource(sValue);
                    if (oResource == null) {
                        return;
                    }
                    Image oWallpaper = GuiEngine.get().loadImage(oResource.getUri());
                    if (oWallpaper != null && oWallpaper.getWidth(WorkArea.this) >= 0) {
                        WorkArea.this.moWallpaper.setImage(oWallpaper);
                    }
                } else if (!"opacity".equals(sKey)) {
                    if ("orientation".equals(sKey)) {
                        try {
                            WorkArea.this.moWallpaper.setOrientation(Integer.parseInt(sValue));
                        }
                        catch (NumberFormatException aoException) {
                            Log.write(3, (Throwable)aoException);
                        }
                    } else if ("style".equals(sKey)) {
                        try {
                            WorkArea.this.moWallpaper.setStyle(Integer.parseInt(sValue));
                        }
                        catch (NumberFormatException aoException) {
                            Log.write(3, (Throwable)aoException);
                        }
                    }
                }
            }
            WorkArea.this.repaint();
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
        }
    }
}

