/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.IOException;
import java.util.Properties;

public final class Version {
    public static final int ALPHA = 0;
    public static final int BETA = 1;
    public static final int PATCH = 2;
    public static final int UNMAINTAINED = 3;
    private String msName = "Novaworx";
    private String msNameKey = "novaworx";
    private String msNameFull = "Novaworx Development Environment";
    private String msCopyright = "Copyright (C) 2000-2004 Mark Soderquist All rights reserved.";
    private int miMajor;
    private int miMinor;
    private int miMicro;
    private int miState;
    private int miBuild;
    private String msBuildDate;
    private static Version moVersion = new Version();

    private Version() {
        Properties oProperties = new Properties();
        try {
            oProperties.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException aoException) {
            aoException.printStackTrace();
            return;
        }
        this.miMajor = Integer.parseInt(oProperties.getProperty("version.major"));
        this.miMinor = Integer.parseInt(oProperties.getProperty("version.minor"));
        this.miMicro = Integer.parseInt(oProperties.getProperty("version.micro"));
        this.miState = Integer.parseInt(oProperties.getProperty("version.state"));
        this.miBuild = Integer.parseInt(oProperties.getProperty("version.build"));
        this.msBuildDate = oProperties.getProperty("version.date");
    }

    public static final String name() {
        return Version.moVersion.msName;
    }

    public static final String nameKey() {
        return Version.moVersion.msNameKey;
    }

    public static final String fullName() {
        return Version.moVersion.msNameFull;
    }

    public static final String copyright() {
        return Version.moVersion.msCopyright;
    }

    public static final int major() {
        return Version.moVersion.miMajor;
    }

    public static final int minor() {
        return Version.moVersion.miMinor;
    }

    public static final int micro() {
        return Version.moVersion.miMicro;
    }

    public static final int state() {
        return Version.moVersion.miState;
    }

    public static final int build() {
        return Version.moVersion.miBuild;
    }

    public static final String buildDate() {
        return Version.moVersion.msBuildDate;
    }

    public static final String getVersion() {
        return Version.major() + "." + Version.minor() + "." + Version.micro();
    }

    public static final String getFullVersion() {
        return Version.major() + "-" + Version.minor() + "-" + Version.micro() + "-" + Version.state() + "-" + Version.build();
    }

    public static final String getState() {
        return Version.getStateDescription(Version.state()) + " " + Version.build();
    }

    public static final String getBuildDate() {
        return Version.buildDate();
    }

    public static final String getStateDescription(int aiState) {
        String sReturn = "";
        switch (aiState) {
            case 0: {
                sReturn = "Alpha";
                break;
            }
            case 1: {
                sReturn = "Beta";
                break;
            }
            case 2: {
                sReturn = "Patch";
            }
        }
        return sReturn;
    }
}

