/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import novaworx.log.Log;

public final class Utilities {
    private Utilities() {
    }

    public static void copyFile(File aoSource, File aoDestination) throws IOException {
        if (!aoSource.exists()) {
            return;
        }
        aoDestination.getParentFile().mkdirs();
        FileInputStream oFileIn = new FileInputStream(aoSource);
        FileOutputStream oFileOut = new FileOutputStream(aoDestination);
        byte[] aBuffer = new byte[4096];
        int iCount = 0;
        do {
            oFileOut.write(aBuffer, 0, iCount);
        } while ((iCount = oFileIn.read(aBuffer, 0, aBuffer.length)) != -1);
        oFileIn.close();
        oFileOut.close();
    }

    public static String globToRE(String asGlob) {
        StringBuffer oBuffer = new StringBuffer();
        boolean bBackslash = false;
        boolean bInsideGroup = false;
        block9: for (int iIndex = 0; iIndex < asGlob.length(); ++iIndex) {
            char cChar = asGlob.charAt(iIndex);
            if (bBackslash) {
                oBuffer.append('\\');
                oBuffer.append(cChar);
                bBackslash = false;
                continue;
            }
            switch (cChar) {
                case '\\': {
                    bBackslash = true;
                    continue block9;
                }
                case '?': {
                    oBuffer.append('.');
                    continue block9;
                }
                case '.': {
                    oBuffer.append("\\.");
                    continue block9;
                }
                case '*': {
                    oBuffer.append(".*");
                    continue block9;
                }
                case '{': {
                    oBuffer.append('(');
                    bInsideGroup = true;
                    continue block9;
                }
                case ',': {
                    if (bInsideGroup) {
                        oBuffer.append('|');
                        continue block9;
                    }
                    oBuffer.append(',');
                    continue block9;
                }
                case '}': {
                    oBuffer.append(')');
                    bInsideGroup = false;
                    continue block9;
                }
                default: {
                    oBuffer.append(cChar);
                }
            }
        }
        return oBuffer.toString();
    }

    public static final String getFileExtension(File aoFile) {
        return Utilities.getFileExtension(aoFile.getName());
    }

    public static final String getFileExtension(String asFilename) {
        String sExtension = null;
        int iIndex = asFilename.lastIndexOf(".");
        if (iIndex > 0) {
            sExtension = asFilename.substring(iIndex + 1);
        }
        return sExtension;
    }

    public static final String getFileNameWithoutExtension(File aoFile) {
        return Utilities.getFileNameWithoutExtension(aoFile.getName());
    }

    public static final String getFileNameWithoutExtension(String asFilename) {
        String sFilename = asFilename;
        int iIndex = asFilename.lastIndexOf(".");
        if (iIndex > 0) {
            sFilename = asFilename.substring(0, iIndex);
        }
        return sFilename;
    }

    public static final void invalidateContainerTree(Container aoContainer) {
        aoContainer.invalidate();
        int iCount = aoContainer.getComponentCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Component oComponent = aoContainer.getComponent(iIndex);
            if (!(oComponent instanceof Container)) continue;
            Log.write(-1, "Invalidating: " + oComponent.getClass().getName() + " ...");
            Utilities.invalidateContainerTree((Container)oComponent);
        }
    }
}

