/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import novaworx.GuiEngine;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.Settings;
import novaworx.Version;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.gui.SplashScreen;
import novaworx.log.ConsoleLogger;
import novaworx.log.FileLogger;
import novaworx.log.Log;
import novaworx.message.RequestProgramHalt;
import novaworx.message.RequestResourceOpen;
import novaworx.message.RequestSplashScreenHide;
import novaworx.resource.Resource;
import novaworx.resource.ResourceException;
import novaworx.util.CommandLine;

public final class Startup
implements Settings {
    public static final String[] FLAGS = new String[]{"help", "version", "daemon", "nosplash", "stop", "devel", "log.color"};
    public static final long mlStartTime = System.currentTimeMillis();
    private static CommandLine moCommandLine;
    private static String msHomeDirectory;
    private static MessageHandler moMessageHandler;
    private static SplashScreen moSplash;
    private static long mlLastSplash;
    static /* synthetic */ Class class$novaworx$Startup;

    public static void main(String[] aaParameters) {
        String sJavaVersion = System.getProperty("java.version");
        if (sJavaVersion.compareTo("1.4") < 0) {
            String[] aMessage = new String[]{"You are running Java version " + sJavaVersion + ".", Version.name() + " requires Java 1.4 or later."};
            System.err.println(aMessage[0]);
            System.err.println(aMessage[1]);
            JOptionPane.showMessageDialog(null, aMessage);
            System.exit(-1);
        }
        System.out.println("");
        System.out.println(Version.fullName());
        System.out.println("");
        System.out.println(Version.copyright());
        System.out.println(Version.name() + " comes with ABSOLUTELY NO WARRANTY.  This is free software,");
        System.out.println("and you are welcome to redistribute it under certain conditions. ");
        moCommandLine = new CommandLine(aaParameters, FLAGS);
        ConsoleLogger oConsoleLogger = new ConsoleLogger();
        oConsoleLogger.setLevel(moCommandLine.get("log.level"));
        oConsoleLogger.setAnsiColor("true".equals(moCommandLine.get("log.color")));
        Log.addLogger(oConsoleLogger);
        String sLogFile = moCommandLine.get("log.file");
        if (sLogFile != null && !"true".equals(sLogFile)) {
            FileLogger oUserFileLogger = new FileLogger(sLogFile);
            oUserFileLogger.setLevel(moCommandLine.get("log.level"));
            Log.addLogger(oUserFileLogger);
        }
        if ("true".equals(moCommandLine.get("help"))) {
            System.out.println("");
            Startup.showHelp();
            System.exit(0);
        }
        Log.write(-100, "");
        Log.write(-100, "Version: " + Version.getVersion() + " " + Version.getState() + " (" + Version.getFullVersion() + ") " + Version.getBuildDate());
        Log.write(-100, "");
        if ("true".equals(moCommandLine.get("version"))) {
            System.exit(0);
        }
        if ("true".equals(moCommandLine.get("devel"))) {
            Log.write(-1, "Enabling DEVELOPMENT mode...");
            MainEngine.get().setDevel(true);
        }
        Log.write(5, "Parameters: " + moCommandLine.toString());
        if (Startup.isPeerRunning(moCommandLine)) {
            System.exit(0);
        }
        if ("true".equals(moCommandLine.get("stop"))) {
            System.exit(0);
        }
        Log.write(5, "Starting new instance of program...");
        if (!"true".equals(moCommandLine.get("nosplash")) & !"true".equals(moCommandLine.get("daemon"))) {
            Startup.showSplashScreen();
        }
        try {
            MainEngine.get().start();
        }
        catch (Throwable aoThrowable) {
            Log.write(2, aoThrowable);
        }
        Startup.hideSplashScreen();
        try {
            Startup.processParameters(moCommandLine);
        }
        catch (Throwable aoThrowable) {
            Log.write(2, aoThrowable);
        }
    }

    public static CommandLine getCommandLine() {
        return moCommandLine;
    }

    public static String getHomeDirectory() {
        if (msHomeDirectory == null) {
            String sPropertyKey = Version.nameKey() + ".home";
            String sHomeDirectory = System.getProperty(sPropertyKey);
            String classpath = System.getProperty("java.class.path");
            int iIndex = classpath.toLowerCase().indexOf(Version.nameKey() + ".jar");
            int iStart = classpath.lastIndexOf(File.pathSeparator, iIndex) + 1;
            File oHomeDirectory = null;
            if (sHomeDirectory == null) {
                if (classpath.equalsIgnoreCase(Version.nameKey() + ".jar")) {
                    oHomeDirectory = new File(System.getProperty("user.dir"));
                    oHomeDirectory = oHomeDirectory.getParentFile();
                } else if (iIndex > iStart) {
                    oHomeDirectory = new File(classpath.substring(iStart, iIndex - 1));
                    oHomeDirectory = oHomeDirectory.getParentFile();
                } else {
                    oHomeDirectory = new File(System.getProperty("user.dir"));
                    Log.write(2, "Could not determine " + Version.name() + " home directory!");
                }
            }
            if (oHomeDirectory != null) {
                try {
                    oHomeDirectory = oHomeDirectory.getCanonicalFile();
                }
                catch (IOException aoException) {
                    Log.write(aoException);
                }
            }
            if (oHomeDirectory != null) {
                msHomeDirectory = oHomeDirectory.getAbsolutePath();
            }
        }
        return msHomeDirectory;
    }

    public static void showHelp() {
        System.out.println("Usage:");
        System.out.println("  java -jar " + Version.nameKey() + ".jar [options] [files]");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("  -help               Show this help information.");
        System.out.println("  -version            Show full version information.");
        System.out.println("  -daemon             Start program in daemon mode.");
        System.out.println("  -nosplash           Do not show splash screen when starting.");
        System.out.println("  -log.level <level>  Set the logging level.");
        System.out.println("  -log.color          Use ANSI color codes for console logs.");
        System.out.println("  -log.file           Log to the specified file.");
        System.out.println("");
        System.out.println("Log Levels:");
        System.out.println("   none               No entries logged at all.");
        System.out.println("   fatal              Something very bad occurred that caused the");
        System.out.println("                      program to fail and terminate.");
        System.out.println("   error              Something bad occurred and the program");
        System.out.println("                      may be in an unstable state.");
        System.out.println("   warn               Something bad occurred but the program");
        System.out.println("                      was able to recover to a stable state.");
        System.out.println("   info               Standard information about the operation");
        System.out.println("                      of the program. This is the default.");
        System.out.println("   config             Configuration information will also be logged.");
        System.out.println("   debug              Debugging information will also be logged.");
        System.out.println("   all                All entries will be logged.");
    }

    private static boolean isPeerRunning(CommandLine aoCommandLine) {
        Preferences oProgramPrefs = PreferenceEngine.get().getPreferences("/program/peerengine");
        int iPort = oProgramPrefs.getInt("port", 0);
        if (iPort >= 1024) {
            Log.write(4, "Connecting to peer (" + iPort + ")...");
            SocketChannel oChannel = null;
            try {
                InetAddress oHost = InetAddress.getByName("localhost");
                InetSocketAddress oAddress = new InetSocketAddress(oHost, iPort);
                oChannel = SocketChannel.open();
                oChannel.connect(oAddress);
                BufferedReader oBufferRead = new BufferedReader(new InputStreamReader(oChannel.socket().getInputStream()));
                String sLine = oBufferRead.readLine();
                if (sLine != null) {
                    Log.write(4, "Connected to: " + sLine);
                } else {
                    Log.write(4, "Connected to unknown service.");
                }
                Log.write(4, "Sending parameters to engine...");
                ObjectOutputStream oObjectOut = new ObjectOutputStream(oChannel.socket().getOutputStream());
                oObjectOut.writeObject(aoCommandLine);
                oObjectOut.flush();
                Log.write(4, "Parameters sent to engine.");
                sLine = oBufferRead.readLine();
                while (sLine != null) {
                    System.out.println(sLine);
                    sLine = oBufferRead.readLine();
                }
                Log.write(4, "Disconnecting from peer...");
                oChannel.close();
                Log.write(4, "Disconnected from peer.");
                return true;
            }
            catch (ConnectException aoException) {
                Log.write(3, "Engine not running.");
                return false;
            }
            catch (SocketException aoException) {
                Log.write(2, (Throwable)aoException);
            }
            catch (IOException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        } else {
            return false;
        }
        return true;
    }

    public static void processParameters(CommandLine aoCommandLine) {
        Vector vFiles;
        Log.write(5, "Processing parameters...");
        if ("true".equals(aoCommandLine.get("stop"))) {
            MessageBus.send(new RequestProgramHalt(class$novaworx$Startup == null ? (class$novaworx$Startup = Startup.class$("novaworx.Startup")) : class$novaworx$Startup));
            return;
        }
        if (!MainEngine.get().isDaemon() && "true".equals(aoCommandLine.get("daemon"))) {
            Log.write(5, "Enabling DAEMON mode...");
            MainEngine.get().setDaemon(true);
        }
        if ((vFiles = aoCommandLine.getFiles()).size() == 0) {
            if ("true".equals(aoCommandLine.get("daemon"))) {
                return;
            }
        } else {
            Resource oResource = null;
            Vector<Resource> vResources = new Vector<Resource>();
            for (int iIndex = 0; iIndex < vFiles.size(); ++iIndex) {
                String sFilename = (String)vFiles.get(iIndex);
                Log.write(5, "Resource specified: " + sFilename);
                try {
                    File oFile = new File(sFilename).getCanonicalFile();
                    sFilename = oFile.getCanonicalPath();
                    oResource = ResourceEngine.get().createResource(oFile);
                    if (oResource.isContainer()) continue;
                    vResources.add(oResource);
                    continue;
                }
                catch (ResourceException aoException) {
                    Log.write(2, (Throwable)aoException);
                    continue;
                }
                catch (IOException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
            }
            Resource[] aResources = new Resource[vResources.size()];
            aResources = vResources.toArray(aResources);
            MessageBus.send(new RequestResourceOpen((Object)(class$novaworx$Startup == null ? (class$novaworx$Startup = Startup.class$("novaworx.Startup")) : class$novaworx$Startup), aResources));
        }
        Log.write(5, "Requesting that the frame be shown...");
        GuiEngine.get().requestFrameShow();
    }

    public static void showSplashScreen() {
        moSplash = new SplashScreen(13);
        mlLastSplash = System.currentTimeMillis();
    }

    public static void hideSplashScreen() {
        long lNow;
        if (moSplash == null) {
            return;
        }
        mlLastSplash = lNow = System.currentTimeMillis();
        Log.write(5, "Splash steps: " + moSplash.getProgress());
        moSplash.dispose();
        moSplash = null;
    }

    public static void advanceSplashProgress() {
        Startup.advanceSplashProgress("Unknown source.");
    }

    public static void advanceSplashProgress(String asMessage) {
        long lNow;
        if (moSplash == null) {
            return;
        }
        moSplash.advance();
        mlLastSplash = lNow = System.currentTimeMillis();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mlLastSplash = 0L;
    }

    private static class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof RequestSplashScreenHide) {
                // empty if block
            }
        }
    }
}

