/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.WorkPane;
import novaworx.WorkViewEngine;
import novaworx.Workspace;
import novaworx.WorkspaceEngine;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.NodeEvent;
import novaworx.data.NodeListener;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramAction;
import novaworx.log.Log;
import novaworx.message.ProgramStopRequested;
import novaworx.message.RequestResourceClose;
import novaworx.message.RequestResourceLoad;
import novaworx.message.RequestResourceOpen;
import novaworx.message.RequestResourceSave;
import novaworx.message.RequestResourceSaveAs;
import novaworx.message.RequestResourceSaveCopyAs;
import novaworx.message.ResourceClose;
import novaworx.message.ResourceLoad;
import novaworx.message.ResourceOpen;
import novaworx.message.ResourceSave;
import novaworx.message.ResourceSelect;
import novaworx.message.ResourceUnselect;
import novaworx.resource.Resource;
import novaworx.resource.ResourceException;
import novaworx.resource.ResourceFactory;
import novaworx.swing.XColor;
import novaworx.util.thread.ThreadPool;
import novaworx.view.resource.ResourceView;

public final class ResourceEngine {
    public static final String ROOT = "root:resources";
    public static final String PREFERENCES_KEY = "/program/resourceengine";
    private static ResourceEngine moInstance;
    private Resource moRoot;
    private Vector mvStaticResources = new Vector();
    private Vector mvOpenResources = new Vector();
    private Resource moCurrentResource;
    private int miModifiedResourceCount;
    private ResourceHandler moResourceHandler = new ResourceHandler();
    private CurrentResourceHandler moCurrentResourceHandler = new CurrentResourceHandler();
    private MessageHandler moMessageListener;
    private NewActionHandler moNewActionHandler;
    private OpenActionHandler moOpenActionHandler;
    private SaveActionHandler moSaveActionHandler;
    private SaveAsActionHandler moSaveAsActionHandler;
    private SaveCopyAsActionHandler moSaveCopyAsActionHandler;
    private SaveAllActionHandler moSaveAllActionHandler;
    private CloseActionHandler moCloseActionHandler;
    private CloseAllActionHandler moCloseAllActionHandler;
    private NextResourceActionHandler moNextResourceActionHandler;
    private PreviousResourceActionHandler moPreviousResourceActionHandler;
    private Workspace moDefaultWorkspace = WorkspaceEngine.get().createWorkspace();
    private static int miNextNewNumber;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    private static Color moModifiedResourceForeground;
    private static Color moModifiedResourceBackground;
    private static Color moModifiedResourceSelectedForeground;
    private static Color moModifiedResourceSelectedBackground;
    private static Color moNotWritableResourceForeground;
    private static Color moNotWritableResourceBackground;
    private static Color moNotWritableResourceSelectedForeground;
    private static Color moNotWritableResourceSelectedBackground;
    static /* synthetic */ Class class$novaworx$message$ResourceSelect;
    static /* synthetic */ Class class$novaworx$message$RequestResourceOpen;
    static /* synthetic */ Class class$novaworx$message$RequestResourceLoad;
    static /* synthetic */ Class class$novaworx$message$RequestResourceSave;
    static /* synthetic */ Class class$novaworx$message$RequestResourceSaveAs;
    static /* synthetic */ Class class$novaworx$message$RequestResourceSaveCopyAs;
    static /* synthetic */ Class class$novaworx$message$RequestResourceClose;
    static /* synthetic */ Class class$novaworx$message$ProgramStopRequested;
    static /* synthetic */ Class class$novaworx$ResourceEngine;

    private ResourceEngine() {
        this.moNewActionHandler = new NewActionHandler();
        this.moOpenActionHandler = new OpenActionHandler();
        this.moSaveActionHandler = new SaveActionHandler();
        this.moSaveAsActionHandler = new SaveAsActionHandler();
        this.moSaveCopyAsActionHandler = new SaveCopyAsActionHandler();
        this.moSaveAllActionHandler = new SaveAllActionHandler();
        this.moCloseActionHandler = new CloseActionHandler();
        this.moCloseAllActionHandler = new CloseAllActionHandler();
        this.moNextResourceActionHandler = new NextResourceActionHandler();
        this.moPreviousResourceActionHandler = new PreviousResourceActionHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
    }

    public static ResourceEngine get() {
        if (moInstance == null) {
            moInstance = new ResourceEngine();
        }
        return moInstance;
    }

    public void start() {
        this.moRoot = this.createResource(URI.create(ROOT));
        if (this.moRoot == null) {
            Log.write(1, "Root resource failed to open.");
        } else {
            this.moRoot.setResource("display.name", "Resource Root");
            this.moRoot.setResource("display.icon", IconCache.getIcon("folder"));
            this.mvStaticResources.add(this.moRoot);
        }
        boolean bResourceView = WorkViewEngine.get().hasViewType("novaworx.view.resource.ResourceView");
        ((ProgramAction)ActionLibrary.get("new")).pushListener(this.moNewActionHandler, bResourceView);
        ((ProgramAction)ActionLibrary.get("open")).pushListener(this.moOpenActionHandler, bResourceView);
        ((ProgramAction)ActionLibrary.get("save")).pushListener(this.moSaveActionHandler, false);
        ((ProgramAction)ActionLibrary.get("save.as")).pushListener(this.moSaveAsActionHandler, false);
        ((ProgramAction)ActionLibrary.get("save.copy.as")).pushListener(this.moSaveCopyAsActionHandler, false);
        ((ProgramAction)ActionLibrary.get("save.all")).pushListener(this.moSaveAllActionHandler, false);
        ((ProgramAction)ActionLibrary.get("close")).pushListener(this.moCloseActionHandler, false);
        ((ProgramAction)ActionLibrary.get("close.all")).pushListener(this.moCloseAllActionHandler, false);
        ((ProgramAction)ActionLibrary.get("next.resource")).pushListener(this.moNextResourceActionHandler, false);
        ((ProgramAction)ActionLibrary.get("previous.resource")).pushListener(this.moPreviousResourceActionHandler, false);
        this.moMessageListener = new MessageHandler();
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$ResourceSelect == null ? (class$novaworx$message$ResourceSelect = ResourceEngine.class$("novaworx.message.ResourceSelect")) : class$novaworx$message$ResourceSelect);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceOpen == null ? (class$novaworx$message$RequestResourceOpen = ResourceEngine.class$("novaworx.message.RequestResourceOpen")) : class$novaworx$message$RequestResourceOpen);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceLoad == null ? (class$novaworx$message$RequestResourceLoad = ResourceEngine.class$("novaworx.message.RequestResourceLoad")) : class$novaworx$message$RequestResourceLoad);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceSave == null ? (class$novaworx$message$RequestResourceSave = ResourceEngine.class$("novaworx.message.RequestResourceSave")) : class$novaworx$message$RequestResourceSave);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceSaveAs == null ? (class$novaworx$message$RequestResourceSaveAs = ResourceEngine.class$("novaworx.message.RequestResourceSaveAs")) : class$novaworx$message$RequestResourceSaveAs);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceSaveCopyAs == null ? (class$novaworx$message$RequestResourceSaveCopyAs = ResourceEngine.class$("novaworx.message.RequestResourceSaveCopyAs")) : class$novaworx$message$RequestResourceSaveCopyAs);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$RequestResourceClose == null ? (class$novaworx$message$RequestResourceClose = ResourceEngine.class$("novaworx.message.RequestResourceClose")) : class$novaworx$message$RequestResourceClose);
        MessageBus.registerListener(this.moMessageListener, class$novaworx$message$ProgramStopRequested == null ? (class$novaworx$message$ProgramStopRequested = ResourceEngine.class$("novaworx.message.ProgramStopRequested")) : class$novaworx$message$ProgramStopRequested);
        this.moPreferenceChangeHandler.init();
    }

    public Resource getResource(URI aoURI) {
        Resource oResource = null;
        Resource oTestResource = null;
        Vector vStaticResources = (Vector)this.mvStaticResources.clone();
        int iStaticCount = vStaticResources.size();
        for (int iIndex = 0; iIndex < iStaticCount; ++iIndex) {
            oTestResource = (Resource)vStaticResources.get(iIndex);
            if (!aoURI.equals(oTestResource.getUri())) continue;
            oResource = oTestResource;
        }
        Vector vOpenResources = (Vector)this.mvStaticResources.clone();
        int iOpenCount = vOpenResources.size();
        for (int iIndex = 0; iIndex < iOpenCount; ++iIndex) {
            oTestResource = (Resource)vOpenResources.get(iIndex);
            if (!aoURI.equals(oTestResource.getUri())) continue;
            oResource = oTestResource;
        }
        return oResource;
    }

    public Workspace getDefaultWorkspace() {
        return this.moDefaultWorkspace;
    }

    private synchronized void setCurrentResource(Resource aoResource) {
        if (aoResource != null && !this.isAlreadyOpen(aoResource)) {
            return;
        }
        if (this.moCurrentResource != null) {
            this.moCurrentResource.removeNodeListener(this.moCurrentResourceHandler);
        }
        this.moCurrentResource = aoResource;
        if (aoResource != null) {
            aoResource.addNodeListener(this.moCurrentResourceHandler);
        }
        ActionLibrary.get("save").setEnabled(aoResource != null && aoResource.isModified());
        ActionLibrary.get("save.as").setEnabled(aoResource != null);
        ActionLibrary.get("save.copy.as").setEnabled(aoResource != null);
        ActionLibrary.get("close").setEnabled(aoResource != null);
    }

    public Resource getCurrentResource() {
        return this.moCurrentResource;
    }

    public Resource selectNextResource() {
        return null;
    }

    public Resource selectPreviousResource() {
        return null;
    }

    public Resource[] getOpenResources() {
        Resource[] aResources = new Resource[this.mvOpenResources.size()];
        this.mvOpenResources.toArray(aResources);
        return aResources;
    }

    public Resource[] getModifiedResources() {
        Vector<Resource> vModifiedResources = new Vector<Resource>();
        Vector vOpenResources = (Vector)this.mvOpenResources.clone();
        boolean iModifiedCount = false;
        int iResourceCount = vOpenResources.size();
        for (int iIndex = 0; iIndex < iResourceCount; ++iIndex) {
            Resource oResource = (Resource)vOpenResources.get(iIndex);
            if (!oResource.isModified()) continue;
            vModifiedResources.add(oResource);
        }
        Resource[] aResources = new Resource[vModifiedResources.size()];
        vModifiedResources.toArray(aResources);
        return aResources;
    }

    public int getOpenResourceCount() {
        return this.mvOpenResources.size();
    }

    public int getModifiedResourceCount() {
        Vector vOpenResources = (Vector)this.mvOpenResources.clone();
        int iModifiedResourceCount = 0;
        int iResourceCount = vOpenResources.size();
        for (int iIndex = 0; iIndex < iResourceCount; ++iIndex) {
            Resource oResource = (Resource)vOpenResources.get(iIndex);
            if (!oResource.isModified()) continue;
            ++iModifiedResourceCount;
        }
        return iModifiedResourceCount;
    }

    public Resource createResource(Object aoResource) {
        Object[] aResources = new Object[]{aoResource};
        return this.createResources(aResources)[0];
    }

    public Resource[] createResources(Object[] aaResources) {
        return ResourceFactory.createResources(aaResources);
    }

    public Resource newResource() {
        String sURI = "new:New%20Resource%20" + ++miNextNewNumber;
        Resource oResource = this.createResource(sURI);
        this.openResource(oResource);
        this.loadResource(oResource);
        return oResource;
    }

    private Resource openResource(Resource aoResource) {
        return this.openResource(aoResource, null);
    }

    private Resource openResource(Resource aoResource, WorkPane aoSuggestedPane) {
        Resource[] aResources = new Resource[]{aoResource};
        Resource[] aOpenResources = this.openResources(aResources, aoSuggestedPane);
        return aOpenResources.length == 0 ? null : aOpenResources[0];
    }

    private Resource[] openResources(Resource[] aaResources) {
        return this.openResources(aaResources, null);
    }

    private synchronized Resource[] openResources(Resource[] aaResources, WorkPane aoSuggestedPane) {
        Resource oSelectedResource = null;
        Vector<Resource> vOpenResources = new Vector<Resource>(aaResources.length);
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            URI oURI = (URI)oResource.getResource("uri");
            if (this.isAlreadyOpen(oResource)) continue;
            try {
                oResource.open();
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
                continue;
            }
            vOpenResources.add(oResource);
            try {
                if (oSelectedResource == null && !aaResources[iIndex].isContainer()) {
                    oSelectedResource = aaResources[iIndex];
                }
            }
            catch (ResourceException aoException) {
                Log.write(3, (Throwable)aoException);
            }
            this.mvOpenResources.add(oResource);
            this.moDefaultWorkspace.add(oResource);
            oResource.addNodeListener(this.moResourceHandler);
            if (!oResource.isModified()) continue;
            ++this.miModifiedResourceCount;
        }
        Resource[] aResources = (Resource[])aaResources.clone();
        Resource[] aOpenResources = vOpenResources.toArray(aResources);
        if (aOpenResources.length > 0) {
            MessageBus.send(new ResourceOpen((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), aOpenResources));
        }
        if (oSelectedResource != null) {
            MessageBus.send(new ResourceSelect((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), oSelectedResource, aoSuggestedPane));
        }
        ActionLibrary.get("save.all").setEnabled(this.miModifiedResourceCount > 0);
        ActionLibrary.get("close.all").setEnabled(this.mvOpenResources.size() > 0);
        return aOpenResources;
    }

    private boolean isAlreadyOpen(Resource aoResource) {
        Vector vOpenResources = (Vector)this.mvOpenResources.clone();
        int iResourceCount = vOpenResources.size();
        for (int iIndex = 0; iIndex < iResourceCount; ++iIndex) {
            Resource oResource = (Resource)vOpenResources.get(iIndex);
            if (!aoResource.equals(oResource)) continue;
            return true;
        }
        return false;
    }

    private void loadResource(Resource aoResource) {
        Resource[] aResources = new Resource[]{aoResource};
        this.loadResources(aResources);
    }

    private synchronized void loadResources(Resource[] aaResources) {
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            try {
                oResource.load();
                continue;
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
        if (aaResources.length > 0) {
            MessageBus.send(new ResourceLoad((Object)this, aaResources));
        }
    }

    private void saveResource(Resource aoResource) {
        Resource[] aResources = new Resource[]{aoResource};
        this.saveResources(aResources);
    }

    private synchronized void saveResources(Resource[] aaResources) {
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            URI oURI = oResource.getUri();
            if (oURI.getScheme().equals("new")) continue;
            try {
                oResource.save();
                continue;
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
        if (aaResources.length > 0) {
            MessageBus.send(new ResourceSave((Object)this, aaResources));
        }
    }

    private void saveAsResource(Resource aoResource, Resource aoAsResource) {
        Resource[] aResources = new Resource[1];
        Resource[] aAsResources = new Resource[1];
        aResources[0] = aoResource;
        aAsResources[0] = aoAsResource;
        this.saveAsResources(aResources, aAsResources);
    }

    private synchronized void saveAsResources(Resource[] aaResources, Resource[] aaAsResources) {
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            Resource oAsResource = aaAsResources[iIndex];
            try {
                oResource.saveAs(oAsResource);
                continue;
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
        if (aaResources.length > 0) {
            MessageBus.send(new ResourceSave((Object)this, aaResources));
        }
    }

    private void saveCopyAsResource(Resource aoResource, Resource aoAsResource) {
        Resource[] aResources = new Resource[1];
        Resource[] aAsResources = new Resource[1];
        aResources[0] = aoResource;
        aAsResources[0] = aoAsResource;
        this.saveCopyAsResources(aResources, aAsResources);
    }

    private synchronized void saveCopyAsResources(Resource[] aaResources, Resource[] aaAsResources) {
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            Resource oAsResource = aaAsResources[iIndex];
            Log.write(6, "Saving copy of " + oResource + " as " + oAsResource);
            oAsResource.copyFrom(oResource, false);
        }
        this.saveResources(aaAsResources);
        this.openResources(aaAsResources);
    }

    private void closeResource(Resource aoResource) {
        Resource[] aResources = new Resource[]{aoResource};
        this.closeResources(aResources);
    }

    private synchronized void closeResources(Resource[] aaResources) {
        if (aaResources.length > 0) {
            MessageBus.send(new ResourceUnselect((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), aaResources));
        }
        Resource oCurrentResource = this.getCurrentResource();
        for (int iIndex = 0; iIndex < aaResources.length; ++iIndex) {
            Resource oResource = aaResources[iIndex];
            if (oResource.isModified()) {
                --this.miModifiedResourceCount;
            }
            oResource.removeNodeListener(this.moResourceHandler);
            this.mvOpenResources.remove(oResource);
            this.moDefaultWorkspace.remove(oResource);
            try {
                oResource.close();
                if (oResource != oCurrentResource) continue;
                this.setCurrentResource(null);
                continue;
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
        ActionLibrary.get("save.all").setEnabled(this.miModifiedResourceCount > 0);
        ActionLibrary.get("close.all").setEnabled(this.mvOpenResources.size() > 0);
        if (aaResources.length > 0) {
            MessageBus.send(new ResourceClose((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), aaResources));
        }
    }

    public void stop() {
        MessageBus.removeListener(this.moMessageListener, class$novaworx$message$ResourceSelect == null ? (class$novaworx$message$ResourceSelect = ResourceEngine.class$("novaworx.message.ResourceSelect")) : class$novaworx$message$ResourceSelect);
        MessageBus.removeListener(this.moMessageListener, class$novaworx$message$RequestResourceSave == null ? (class$novaworx$message$RequestResourceSave = ResourceEngine.class$("novaworx.message.RequestResourceSave")) : class$novaworx$message$RequestResourceSave);
        MessageBus.removeListener(this.moMessageListener, class$novaworx$message$RequestResourceClose == null ? (class$novaworx$message$RequestResourceClose = ResourceEngine.class$("novaworx.message.RequestResourceClose")) : class$novaworx$message$RequestResourceClose);
        ((ProgramAction)ActionLibrary.get("new")).pullListener(this.moNewActionHandler);
        ((ProgramAction)ActionLibrary.get("open")).pullListener(this.moOpenActionHandler);
        ((ProgramAction)ActionLibrary.get("save")).pullListener(this.moSaveActionHandler);
        ((ProgramAction)ActionLibrary.get("save.as")).pullListener(this.moSaveAsActionHandler);
        ((ProgramAction)ActionLibrary.get("save.copy.as")).pullListener(this.moSaveCopyAsActionHandler);
        ((ProgramAction)ActionLibrary.get("save.all")).pullListener(this.moSaveAllActionHandler);
        ((ProgramAction)ActionLibrary.get("close")).pullListener(this.moCloseActionHandler);
        ((ProgramAction)ActionLibrary.get("close.all")).pullListener(this.moCloseAllActionHandler);
    }

    public static void setModifiedResourceForeground(Color aoColor) {
        moModifiedResourceForeground = aoColor;
    }

    public static Color getModifiedResourceForeground() {
        return moModifiedResourceForeground;
    }

    public static void setModifiedResourceBackground(Color aoColor) {
        moModifiedResourceBackground = aoColor;
    }

    public static Color getModifiedResourceBackground() {
        return moModifiedResourceBackground;
    }

    public static void setModifiedResourceSelectedForeground(Color aoColor) {
        moModifiedResourceSelectedForeground = aoColor;
    }

    public static Color getModifiedResourceSelectedForeground() {
        return moModifiedResourceSelectedForeground;
    }

    public static void setModifiedResourceSelectedBackground(Color aoColor) {
        moModifiedResourceSelectedBackground = aoColor;
    }

    public static Color getModifiedResourceSelectedBackground() {
        return moModifiedResourceSelectedBackground;
    }

    public static void setNotWritableResourceForeground(Color aoColor) {
        moNotWritableResourceForeground = aoColor;
    }

    public static Color getNotWritableResourceForeground() {
        return moNotWritableResourceForeground;
    }

    public static void setNotWritableResourceBackground(Color aoColor) {
        moNotWritableResourceBackground = aoColor;
    }

    public static Color getNotWritableResourceBackground() {
        return moNotWritableResourceBackground;
    }

    public static void setNotWritableResourceSelectedForeground(Color aoColor) {
        moNotWritableResourceSelectedForeground = aoColor;
    }

    public static Color getNotWritableResourceSelectedForeground() {
        return moNotWritableResourceSelectedForeground;
    }

    public static void setNotWritableResourceSelectedBackground(Color aoColor) {
        moNotWritableResourceSelectedBackground = aoColor;
    }

    public static Color getNotWritableResourceSelectedBackground() {
        return moNotWritableResourceSelectedBackground;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moResourcePreferences = PreferenceEngine.get().getPreferences("/program/workarea/resources");

        public PreferenceChangeHandler() {
            this.moResourcePreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moResourcePreferences, "modified", this);
            PreferenceEngine.get().initPreference(this.moResourcePreferences, "modified.selected", this);
            PreferenceEngine.get().initPreference(this.moResourcePreferences, "notwritable", this);
            PreferenceEngine.get().initPreference(this.moResourcePreferences, "notwritable.selected", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moResourcePreferences) {
                if ("modified".equals(sKey)) {
                    ResourceEngine.setModifiedResourceForeground(XColor.decodeForeground(sValue));
                    ResourceEngine.setModifiedResourceBackground(XColor.decodeBackground(sValue));
                } else if ("modified.selected".equals(sKey)) {
                    ResourceEngine.setModifiedResourceSelectedForeground(XColor.decodeForeground(sValue));
                    ResourceEngine.setModifiedResourceSelectedBackground(XColor.decodeBackground(sValue));
                } else if ("notwritable".equals(sKey)) {
                    ResourceEngine.setNotWritableResourceForeground(XColor.decodeForeground(sValue));
                    ResourceEngine.setNotWritableResourceBackground(XColor.decodeBackground(sValue));
                } else if ("notwritable.selected".equals(sKey)) {
                    ResourceEngine.setNotWritableResourceSelectedForeground(XColor.decodeForeground(sValue));
                    ResourceEngine.setNotWritableResourceSelectedBackground(XColor.decodeBackground(sValue));
                }
            }
        }
    }

    private class CloseResources
    implements Runnable {
        private Resource[] maResources;

        public CloseResources(Resource[] aaResources) {
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            this.maResources = aaResources;
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.closeResources(this.maResources);
        }
    }

    private class SaveCopyAsResources
    implements Runnable {
        private Resource[] maResources;
        private Resource[] maAsResources;

        public SaveCopyAsResources(Resource[] aaResources, Resource[] aaAsResources) {
            this.maResources = aaResources;
            this.maAsResources = aaAsResources;
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.saveCopyAsResources(this.maResources, this.maAsResources);
        }
    }

    private class SaveCopyAsResourceHandler
    implements ActionListener {
        private Resource[] maResources;

        public SaveCopyAsResourceHandler(Resource[] aaResources) {
            this.maResources = aaResources;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)aoEvent.getSource();
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oResourceView.removeActionListener(this);
            Resource oContainer = oResourceView.getContainer();
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            oPreferences.put("current.container", oContainer.getUri().toString());
            if (aoEvent.getActionCommand() == "accept.selection") {
                Resource[] aAsResources = oResourceView.getSelectedResources();
                MessageBus.send(new RequestResourceSaveCopyAs((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), this.maResources, aAsResources));
            }
            WorkViewEngine.get().returnView(oResourceView);
        }
    }

    private class SaveAsResources
    implements Runnable {
        private Resource[] maResources;
        private Resource[] maAsResources;

        public SaveAsResources(Resource[] aaResources, Resource[] aaAsResources) {
            this.maResources = aaResources;
            this.maAsResources = aaAsResources;
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.saveAsResources(this.maResources, this.maAsResources);
        }
    }

    private class SaveAsResourceHandler
    implements ActionListener {
        private Resource[] maResources;

        public SaveAsResourceHandler(Resource aoResource) {
            Resource[] aResources = new Resource[]{aoResource};
            this.maResources = aResources;
        }

        public SaveAsResourceHandler(Resource[] aaResources) {
            this.maResources = aaResources;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)aoEvent.getSource();
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oResourceView.removeActionListener(this);
            Resource oContainer = oResourceView.getContainer();
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            oPreferences.put("current.container", oContainer.getUri().toString());
            if (aoEvent.getActionCommand() == "accept.selection") {
                Resource[] aAsResources = oResourceView.getSelectedResources();
                MessageBus.send(new RequestResourceSaveAs((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), this.maResources, aAsResources));
            }
            WorkViewEngine.get().returnView(oResourceView);
        }
    }

    private class SaveResources
    implements Runnable {
        private Resource[] maResources;

        public SaveResources(Resource[] aaResources) {
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            this.maResources = aaResources;
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.saveResources(this.maResources);
        }
    }

    private class LoadResources
    implements Runnable {
        private Resource[] maResources;

        public LoadResources(Resource[] aaResources) {
            this.maResources = aaResources;
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.loadResources(this.maResources);
        }
    }

    private class OpenResources
    implements Runnable {
        private Resource[] maResources;
        private WorkPane moSuggestedPane;

        public OpenResources(Resource[] aaResources) {
            this(aaResources, null);
        }

        public OpenResources(Resource[] aaResources, WorkPane aoSuggestedPane) {
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            this.maResources = aaResources;
            this.moSuggestedPane = aoSuggestedPane;
            oThreadPool.execute(this);
        }

        public void run() {
            ResourceEngine.this.openResources(this.maResources, this.moSuggestedPane);
        }
    }

    private class OpenResourcesHandler
    implements ActionListener {
        private OpenResourcesHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)aoEvent.getSource();
            oResourceView.removeActionListener(this);
            Resource oContainer = oResourceView.getContainer();
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            oPreferences.put("current.container", oContainer.getUri().toString());
            if (aoEvent.getActionCommand() == "accept.selection") {
                Resource[] aResources = oResourceView.getSelectedResources();
                MessageBus.send(new RequestResourceOpen((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), aResources));
            }
            WorkViewEngine.get().returnView(oResourceView);
        }
    }

    private class CloseAllActionHandler
    implements ActionListener {
        private CloseAllActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            MessageBus.send(new RequestResourceClose((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), ResourceEngine.this.getOpenResources()));
        }
    }

    private class CloseActionHandler
    implements ActionListener {
        private CloseActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            MessageBus.send(new RequestResourceClose((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), ResourceEngine.this.getCurrentResource()));
        }
    }

    private class SaveAllActionHandler
    implements ActionListener {
        private SaveAllActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            MessageBus.send(new RequestResourceSave((Object)ResourceEngine.this, ResourceEngine.this.getModifiedResources()));
        }
    }

    private class SaveCopyAsActionHandler
    implements ActionListener {
        private SaveCopyAsActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)WorkViewEngine.get().getView("novaworx.view.resource.ResourceView");
            Resource[] aResources = new Resource[]{ResourceEngine.this.getCurrentResource()};
            oResourceView.addActionListener(new SaveCopyAsResourceHandler(aResources));
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            String sContainer = oPreferences.get("current.container", null);
            oResourceView.setContainer(sContainer == null ? null : ResourceEngine.this.createResource(sContainer));
            oResourceView.showSaveDialog();
        }
    }

    private class SaveAsActionHandler
    implements ActionListener {
        private SaveAsActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)WorkViewEngine.get().getView("novaworx.view.resource.ResourceView");
            Resource[] aResources = new Resource[]{ResourceEngine.this.getCurrentResource()};
            oResourceView.addActionListener(new SaveAsResourceHandler(aResources));
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            String sContainer = oPreferences.get("current.container", null);
            oResourceView.setContainer(sContainer == null ? null : ResourceEngine.this.createResource(sContainer));
            oResourceView.showSaveDialog();
        }
    }

    private class SaveActionHandler
    implements ActionListener {
        private SaveActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Resource oResource = ResourceEngine.this.getCurrentResource();
            Resource[] aResources = new Resource[]{oResource};
            URI oURI = oResource.getUri();
            if (oURI.getScheme().equals("new")) {
                ResourceEngine.this.moSaveAsActionHandler.actionPerformed(aoEvent);
            } else {
                MessageBus.send(new RequestResourceSave((Object)ResourceEngine.this, aResources));
            }
        }
    }

    public class OpenActionHandler
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView oResourceView = (ResourceView)WorkViewEngine.get().getView("novaworx.view.resource.ResourceView");
            oResourceView.addActionListener(new OpenResourcesHandler());
            Preferences oPreferences = PreferenceEngine.get().getPreferences(ResourceEngine.PREFERENCES_KEY);
            String sContainer = oPreferences.get("current.container", null);
            Resource oContainer = sContainer == null ? null : ResourceEngine.this.createResource(sContainer);
            oResourceView.setContainer(oContainer);
            oResourceView.showOpenDialog();
        }
    }

    private class NewActionHandler
    implements ActionListener {
        private NewActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Resource oResource = ResourceEngine.this.newResource();
            MessageBus.send(new ResourceSelect((Object)(class$novaworx$ResourceEngine == null ? (class$novaworx$ResourceEngine = ResourceEngine.class$("novaworx.ResourceEngine")) : class$novaworx$ResourceEngine), oResource));
        }
    }

    private class SetCurrentResource
    implements Runnable {
        private Resource moResource;

        public SetCurrentResource(Resource aoResource) {
            this.moResource = aoResource;
            EventQueue.invokeLater(this);
        }

        public void run() {
            ResourceEngine.this.setCurrentResource(this.moResource);
        }
    }

    private class PreviousResourceActionHandler
    implements ActionListener {
        private PreviousResourceActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
        }
    }

    private class NextResourceActionHandler
    implements ActionListener {
        private NextResourceActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ResourceSelect) {
                ResourceSelect oMessage = (ResourceSelect)aoMessage;
                new SetCurrentResource(oMessage.getResource());
            } else if (aoMessage instanceof RequestResourceOpen) {
                RequestResourceOpen oMessage = (RequestResourceOpen)aoMessage;
                new OpenResources(oMessage.getResources(), oMessage.getSuggestedWorkPane());
            } else if (aoMessage instanceof RequestResourceLoad) {
                RequestResourceLoad oMessage = (RequestResourceLoad)aoMessage;
                new LoadResources(oMessage.getResources());
            } else if (aoMessage instanceof RequestResourceSave) {
                RequestResourceSave oMessage = (RequestResourceSave)aoMessage;
                new SaveResources(oMessage.getResources());
            } else if (aoMessage instanceof RequestResourceSaveAs) {
                RequestResourceSaveAs oMessage = (RequestResourceSaveAs)aoMessage;
                new SaveAsResources(oMessage.getResources(), oMessage.getAsResources());
            } else if (aoMessage instanceof RequestResourceSaveCopyAs) {
                RequestResourceSaveCopyAs oMessage = (RequestResourceSaveCopyAs)aoMessage;
                new SaveCopyAsResources(oMessage.getResources(), oMessage.getAsResources());
            } else if (aoMessage instanceof RequestResourceClose) {
                RequestResourceClose oMessage = (RequestResourceClose)aoMessage;
                new CloseResources(oMessage.getResources());
            } else if (aoMessage instanceof ProgramStopRequested) {
                ProgramStopRequested oMessage = (ProgramStopRequested)aoMessage;
                new CloseResources(ResourceEngine.this.getOpenResources());
            }
        }
    }

    private class CurrentResourceHandler
    implements NodeListener {
        private CurrentResourceHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            int iEventType = aoEvent.getType();
            switch (iEventType) {
                case 1: 
                case 2: {
                    ActionLibrary.get("save").setEnabled(aoEvent.getNode().isModified());
                }
            }
        }
    }

    private class ResourceHandler
    implements NodeListener {
        private ResourceHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            int iEventType = aoEvent.getType();
            switch (iEventType) {
                case 1: 
                case 2: {
                    ActionLibrary.get("save.all").setEnabled(ResourceEngine.this.getModifiedResourceCount() > 0);
                }
            }
        }
    }
}

