/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import novaworx.MainEngine;
import novaworx.PreferenceGroup;
import novaworx.PreferenceNode;
import novaworx.XMLParser;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class PreferenceEngine {
    private static final String ROOT = "/novaworx";
    private static final String DEVEL = "/novaworxdev";
    private static PreferenceEngine moInstance;
    private PreferenceGroup moPreferenceRoot = new PreferenceGroup();
    private Hashtable mhDefaults = new Hashtable();
    private PreferenceHandler moPreferenceHandler = new PreferenceHandler();
    static /* synthetic */ Class class$novaworx$PreferenceEngine;

    private PreferenceEngine() {
    }

    public static PreferenceEngine get() {
        if (moInstance == null) {
            moInstance = new PreferenceEngine();
        }
        return moInstance;
    }

    public void start() {
        this.addDefaultPreferences();
    }

    public void stop() {
        Preferences oProgramPreferences = this.getPreferences("/program");
        try {
            oProgramPreferences.flush();
        }
        catch (BackingStoreException aoException) {
            Log.write(2, (Throwable)aoException);
        }
    }

    public String getRootPath() {
        return MainEngine.get().isDevel() ? DEVEL : ROOT;
    }

    public void initPreference(Preferences aoPreferences, String asKey, PreferenceChangeListener aoListener) {
        String sDefault = this.getDefaultValue(aoPreferences, asKey);
        aoListener.preferenceChange(new PreferenceChangeEvent(aoPreferences, asKey, aoPreferences.get(asKey, sDefault)));
    }

    public void initPreference(Preferences aoPreferences, String asKey, PreferenceChangeListener aoListener, Preferences aoDefaultPreferences) {
        String sDefault = this.getDefaultValue(aoPreferences, asKey, aoDefaultPreferences);
        aoListener.preferenceChange(new PreferenceChangeEvent(aoPreferences, asKey, aoPreferences.get(asKey, sDefault)));
    }

    public Preferences getPreferences(String asKey) {
        if (asKey == null) {
            return null;
        }
        if (!asKey.startsWith("/")) {
            Log.write(2, "Invalid preference path: " + asKey);
            new Exception().printStackTrace();
            return null;
        }
        return Preferences.userRoot().node(this.getRootPath() + asKey);
    }

    public String getStringValue(Preferences aoPreferences, String asKey) {
        return this.getStringValue(aoPreferences, asKey, null);
    }

    public String getStringValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences) {
        return aoPreferences.get(asKey, this.getDefaultValue(aoPreferences, asKey, aoDefaultPreferences));
    }

    public String getStringValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences, String asDefault) {
        return aoPreferences.get(asKey, this.getDefaultValue(aoPreferences, asKey, aoDefaultPreferences, asDefault));
    }

    public boolean getBooleanValue(Preferences aoPreferences, String asKey) {
        return this.getBooleanValue(aoPreferences, asKey, null);
    }

    public boolean getBooleanValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences) {
        return "true".equals(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences));
    }

    public boolean getBooleanValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences, boolean abDefault) {
        return "true".equals(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences, String.valueOf(abDefault)));
    }

    public int getIntegerValue(Preferences aoPreferences, String asKey) {
        return this.getIntegerValue(aoPreferences, asKey, null);
    }

    public int getIntegerValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences) {
        return Integer.parseInt(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences));
    }

    public int getIntegerValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences, int aiDefault) {
        return Integer.parseInt(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences, String.valueOf(aiDefault)));
    }

    public double getDecimalValue(Preferences aoPreferences, String asKey) {
        return this.getDecimalValue(aoPreferences, asKey, null);
    }

    public double getDecimalValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences) {
        return Double.parseDouble(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences));
    }

    public double getDecimalValue(Preferences aoPreferences, String asKey, Preferences aoDefaultPreferences, double adDefault) {
        return Double.parseDouble(this.getStringValue(aoPreferences, asKey, aoDefaultPreferences, String.valueOf(adDefault)));
    }

    public String getDefaultValue(PreferenceNode aoPreference) {
        return aoPreference.get("default");
    }

    public String getDefaultValue(Preferences aoPreferences, String asName) {
        String sKey = aoPreferences.absolutePath() + ":" + asName;
        String sValue = (String)this.mhDefaults.get(sKey);
        if (sValue == null) {
            Log.write(3, "No default for: " + sKey);
            Log.write(6, new Throwable("No default for: " + sKey));
        }
        return sValue;
    }

    public String getDefaultValue(Preferences aoPreferences, String asName, Preferences aoDefaultPreferences) {
        String sKey = aoPreferences.absolutePath() + ":" + asName;
        String sValue = (String)this.mhDefaults.get(sKey);
        if (sValue == null && aoDefaultPreferences != null) {
            sKey = aoDefaultPreferences.absolutePath() + ":" + asName;
            sValue = (String)this.mhDefaults.get(sKey);
        }
        if (sValue == null) {
            Log.write(3, "No default for: " + sKey);
        }
        return sValue;
    }

    public String getDefaultValue(Preferences aoPreferences, String asName, Preferences aoDefaultPreferences, String asDefault) {
        String sKey = aoPreferences.absolutePath() + ":" + asName;
        String sValue = (String)this.mhDefaults.get(sKey);
        if (sValue == null && aoDefaultPreferences != null) {
            sKey = aoDefaultPreferences.absolutePath() + ":" + asName;
            sValue = (String)this.mhDefaults.get(sKey);
        }
        if (sValue == null) {
            sValue = asDefault;
        }
        return sValue;
    }

    public PreferenceGroup getPreferenceRoot() {
        return this.moPreferenceRoot;
    }

    private void addDefaultPreferences() {
        try {
            InputStream oStream = (class$novaworx$PreferenceEngine == null ? (class$novaworx$PreferenceEngine = PreferenceEngine.class$("novaworx.PreferenceEngine")) : class$novaworx$PreferenceEngine).getResourceAsStream("preferences.xml");
            if (oStream == null) {
                throw new IOException("Preference data not found.");
            }
            this.addPreferences(this.moPreferenceRoot, oStream);
        }
        catch (IOException aoException) {
            Log.write(2, (Throwable)aoException);
            return;
        }
        PreferenceGroup oFirstNode = (PreferenceGroup)this.moPreferenceRoot.getChild(0);
    }

    public void addPreferences(InputStream aoStream) throws IOException {
        this.addPreferences(this.moPreferenceRoot, aoStream);
    }

    public void addPreferences(PreferenceGroup aoNode, InputStream aoStream) throws IOException {
        if (aoStream == null) {
            return;
        }
        XMLParser.parse(aoStream, this.moPreferenceHandler, "");
        PreferenceGroup[] aGroups = this.moPreferenceHandler.getGroups();
        for (int iIndex = 0; iIndex < aGroups.length; ++iIndex) {
            PreferenceGroup oGroup = aGroups[iIndex];
            aoNode.add(oGroup);
        }
    }

    public void dumpPreferences() {
        try {
            Preferences.userRoot().node(this.getRootPath()).exportSubtree(System.out);
        }
        catch (IOException aoException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PreferenceHandler
    extends DefaultHandler {
        private PreferenceGroup moRoot = new PreferenceGroup();
        private Stack moParents = new Stack();
        private Stack moGroups = new Stack();
        private Stack moPreferences = new Stack();
        private StringBuffer moDataBuffer = new StringBuffer();
        private String msAttributeName;
        private String msOptionValue;

        public PreferenceHandler() {
            this.moRoot.setResource("key", "root");
            this.moRoot.setResource("display.name", "Preferences Root");
            this.moRoot.setResource("display.icon", IconCache.getIcon("preference"));
            this.moRoot.setResource("groups", new Hashtable());
            this.moRoot.setResource("preferences", new Vector());
            this.moRoot.setResource("preferences.hash", new Hashtable());
            this.moGroups.push(this.moRoot);
        }

        public PreferenceGroup[] getGroups() {
            PreferenceGroup[] aGroups = new PreferenceGroup[this.moRoot.getChildCount()];
            for (int iIndex = 0; iIndex < aGroups.length; ++iIndex) {
                aGroups[iIndex] = (PreferenceGroup)this.moRoot.getChild(iIndex);
            }
            return aGroups;
        }

        public InputSource resolveEntity(String asPublicID, String asSystemID) {
            String sDTD = "preferences.dtd";
            if (asSystemID != null && asSystemID.endsWith(sDTD)) {
                try {
                    return new InputSource(this.getClass().getResourceAsStream(sDTD));
                }
                catch (Exception aoException) {
                    Log.write(2, "Error while loading DTD: " + sDTD);
                    Log.write(2, (Throwable)aoException);
                }
            }
            return null;
        }

        public void doctypeDecl(String asName, String asPublicID, String asSystemID) throws Exception {
            if ("preferences".equals(asName)) {
                return;
            }
            Log.write(2, "Loading catalog: DOCTYPE must be 'preferences'.");
        }

        public void characters(char[] aaCharacters, int aiStart, int aiLength) {
            this.moDataBuffer.append(aaCharacters, aiStart, aiLength);
        }

        public void startElement(String asNamespace, String asLocalName, String asQualifiedName, Attributes aoAttributes) {
            this.moDataBuffer.delete(0, this.moDataBuffer.length());
            if ("group".equals(asQualifiedName)) {
                String sIcon = aoAttributes.getValue("icon");
                String sName = aoAttributes.getValue("name");
                String sLabel = aoAttributes.getValue("label");
                PreferenceGroup oParentGroup = (PreferenceGroup)this.moGroups.peek();
                Hashtable hGroups = (Hashtable)oParentGroup.getResource("groups");
                PreferenceGroup oGroup = (PreferenceGroup)hGroups.get(sName);
                if (oGroup == null) {
                    oGroup = new PreferenceGroup();
                    oGroup.setResource("key", sName);
                    oGroup.setResource("display.name", sLabel);
                    oGroup.setResource("display.icon", IconCache.getIcon(sIcon));
                    oGroup.setResource("groups", new Hashtable());
                    oGroup.setResource("preferences", new Vector());
                    oGroup.setResource("preferences.hash", new Hashtable());
                    oParentGroup.add(oGroup);
                    hGroups.put(sName, oGroup);
                }
                this.moGroups.push(oGroup);
            } else if ("separator".equals(asQualifiedName)) {
                String sName = aoAttributes.getValue("name");
                PreferenceGroup oGroup = (PreferenceGroup)this.moGroups.peek();
                Vector vPreferences = (Vector)oGroup.getResource("preferences");
                Hashtable hPreferences = (Hashtable)oGroup.getResource("preferences.hash");
                PreferenceNode oSeparator = (PreferenceNode)hPreferences.get(sName);
                if (oSeparator == null) {
                    oSeparator = new PreferenceNode();
                    oSeparator.setResource("name", sName);
                    oSeparator.setResource("type", "separator");
                    oSeparator.setResource("hidden", aoAttributes.getValue("hidden"));
                    vPreferences.add(oSeparator);
                    hPreferences.put(sName, oSeparator);
                }
                this.moPreferences.push(oSeparator);
            } else if ("preference".equals(asQualifiedName)) {
                String sPath = aoAttributes.getValue("path");
                String sName = aoAttributes.getValue("name");
                String sType = aoAttributes.getValue("type");
                String sFullName = sPath + ":" + sName;
                PreferenceGroup oGroup = (PreferenceGroup)this.moGroups.peek();
                Vector vPreferences = (Vector)oGroup.getResource("preferences");
                Hashtable hPreferences = (Hashtable)oGroup.getResource("preferences.hash");
                PreferenceNode oPreference = (PreferenceNode)hPreferences.get(sFullName);
                if (oPreference == null) {
                    oPreference = new PreferenceNode();
                    oPreference.setResource("path", sPath);
                    oPreference.setResource("name", sName);
                    oPreference.setResource("type", sType);
                    oPreference.setResource("hidden", aoAttributes.getValue("hidden"));
                    vPreferences.add(oPreference);
                    hPreferences.put(sFullName, oPreference);
                }
                this.moPreferences.push(oPreference);
            } else if (!"default".equals(asQualifiedName)) {
                if ("option".equals(asQualifiedName)) {
                    this.msOptionValue = aoAttributes.getValue("value");
                } else if ("attribute".equals(asQualifiedName)) {
                    this.msAttributeName = aoAttributes.getValue("name");
                }
            }
        }

        public void endElement(String asNamespace, String asLocalName, String asQualifiedName) {
            if ("group".equals(asQualifiedName)) {
                PreferenceGroup oGroup = (PreferenceGroup)this.moGroups.pop();
            } else if ("separator".equals(asQualifiedName)) {
                PreferenceNode oSeparator = (PreferenceNode)this.moPreferences.pop();
            } else if ("preference".equals(asQualifiedName)) {
                PreferenceNode oPreference = (PreferenceNode)this.moPreferences.pop();
            } else if ("default".equals(asQualifiedName)) {
                String sValue = this.moDataBuffer.toString();
                PreferenceNode oPreference = (PreferenceNode)this.moPreferences.peek();
                boolean bModified = oPreference.isModified();
                oPreference.set("default", sValue);
                PreferenceEngine.this.mhDefaults.put(PreferenceEngine.this.getRootPath() + oPreference.getFullName(), sValue);
                if (!bModified) {
                    oPreference.setModified(false);
                }
            } else if ("option".equals(asQualifiedName)) {
                PreferenceNode oPreference = (PreferenceNode)this.moPreferences.peek();
                String sValue = this.msOptionValue;
                String sLabel = this.moDataBuffer.toString();
                Vector<String> vOptions = (Vector<String>)oPreference.getResource("options");
                Hashtable<String, String> hOptionLabels = (Hashtable<String, String>)oPreference.getResource("option.labels");
                Hashtable<String, String> hOptionLookup = (Hashtable<String, String>)oPreference.getResource("option.lookup");
                if (vOptions == null) {
                    vOptions = new Vector<String>();
                    hOptionLabels = new Hashtable<String, String>();
                    hOptionLookup = new Hashtable<String, String>();
                    oPreference.setResource("options", vOptions);
                    oPreference.setResource("option.labels", hOptionLabels);
                    oPreference.setResource("option.lookup", hOptionLookup);
                }
                vOptions.add(sValue);
                hOptionLabels.put(sValue, sLabel);
                hOptionLookup.put(sLabel, sValue);
            } else if ("attribute".equals(asQualifiedName)) {
                String sValue = this.moDataBuffer.toString();
                PreferenceNode oPreference = (PreferenceNode)this.moPreferences.peek();
                boolean bModified = oPreference.isModified();
                oPreference.set(this.msAttributeName, sValue);
                if (!bModified) {
                    oPreference.setModified(false);
                }
            }
        }
    }
}

