/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import novaworx.Startup;
import novaworx.XMLParser;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.log.Log;
import novaworx.message.ProgramStart;
import novaworx.plugin.Plugin;
import novaworx.plugin.PluginDependency;
import novaworx.plugin.PluginMetaData;
import novaworx.plugin.PluginWorker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class PluginEngine {
    private static PluginEngine moInstance;
    private Hashtable mhPlugins = new Hashtable();
    private Hashtable mhPluginWorkers = new Hashtable();
    private Hashtable mhPluginMetaData = new Hashtable();
    private File moUserPlugins;
    private File moProgramPlugins;
    private PluginFileFilter moPluginFileFilter = new PluginFileFilter();
    private PluginConfigHandler moPluginConfigHandler;
    static /* synthetic */ Class class$novaworx$message$ProgramStart;
    static /* synthetic */ Class class$novaworx$plugin$Plugin;

    private PluginEngine() {
        this.moProgramPlugins = new File(Startup.getHomeDirectory(), "ext");
        ClassMessageHandler oMessageHandler = new ClassMessageHandler();
        MessageBus.registerListener(oMessageHandler, class$novaworx$message$ProgramStart == null ? (class$novaworx$message$ProgramStart = PluginEngine.class$("novaworx.message.ProgramStart")) : class$novaworx$message$ProgramStart);
        this.moPluginConfigHandler = new PluginConfigHandler();
    }

    public static final PluginEngine get() {
        if (moInstance == null) {
            moInstance = new PluginEngine();
        }
        return moInstance;
    }

    public void start() {
        this.loadPlugins();
        this.initPlugins();
    }

    private void initPlugins() {
        Enumeration oPlugins = this.getPlugins();
        while (oPlugins.hasMoreElements()) {
            Plugin oPlugin = (Plugin)oPlugins.nextElement();
            oPlugin.init();
        }
    }

    private void startPlugins() {
        Enumeration oPluginWorkers = this.mhPluginWorkers.elements();
        while (oPluginWorkers.hasMoreElements()) {
            PluginWorker oPluginWorker = (PluginWorker)oPluginWorkers.nextElement();
            oPluginWorker.start();
        }
    }

    private void stopPlugins() {
        Enumeration oPluginWorkers = this.mhPluginWorkers.elements();
        while (oPluginWorkers.hasMoreElements()) {
            PluginWorker oPluginWorker = (PluginWorker)oPluginWorkers.nextElement();
            oPluginWorker.stop();
        }
    }

    private void destroyPlugins() {
        Enumeration oPlugins = this.getPlugins();
        while (oPlugins.hasMoreElements()) {
            Plugin oPlugin = (Plugin)oPlugins.nextElement();
            oPlugin.destroy();
        }
    }

    public void stop() {
        this.stopPlugins();
        this.destroyPlugins();
        this.unloadPlugins();
    }

    private void loadPlugins() {
        File[] aDirectories = new File[]{this.moUserPlugins, this.moProgramPlugins};
        this.loadPlugins(aDirectories);
    }

    private void loadPlugins(File[] aaDirectories) {
        for (int iPathIndex = 0; iPathIndex < aaDirectories.length; ++iPathIndex) {
            if (aaDirectories[iPathIndex] != null && aaDirectories[iPathIndex].exists()) {
                File[] oFiles = aaDirectories[iPathIndex].listFiles(this.moPluginFileFilter);
                if (oFiles == null || oFiles.length == 0) {
                    Log.write(6, "No files to load from: " + aaDirectories[iPathIndex]);
                    continue;
                }
                boolean bPlugins = false;
                for (int iFileIndex = 0; iFileIndex < oFiles.length; ++iFileIndex) {
                    Startup.advanceSplashProgress();
                    File oFile = oFiles[iFileIndex];
                    if (!oFile.isFile()) continue;
                    String sFile = oFile.getName().toLowerCase();
                    boolean bResult = false;
                    if (sFile.endsWith(".jar")) {
                        bResult = this.loadPlugin(oFile);
                    }
                    if (!bResult) continue;
                    bPlugins = true;
                }
                if (bPlugins) continue;
                Log.write(6, "No plugins loaded from: " + aaDirectories[iPathIndex]);
                continue;
            }
            Log.write(6, "Plugin directory does not exist: " + aaDirectories[iPathIndex]);
        }
    }

    private void unloadPlugins() {
        Enumeration oPlugins = this.getPlugins();
        while (oPlugins.hasMoreElements()) {
            Plugin oPlugin = (Plugin)oPlugins.nextElement();
            this.remove(oPlugin);
        }
    }

    private boolean add(Plugin aoPlugin) {
        String sKey = aoPlugin.getClass().getName();
        if (this.mhPlugins.get(sKey) != null) {
            Log.write(3, "Plugin already loaded: " + sKey);
            return false;
        }
        this.mhPlugins.put(sKey, aoPlugin);
        this.mhPluginWorkers.put(sKey, new PluginWorker(aoPlugin));
        return true;
    }

    private boolean remove(Plugin aoPlugin) {
        String sKey = aoPlugin.getClass().getName();
        if (!this.mhPlugins.containsKey(sKey)) {
            return false;
        }
        this.mhPlugins.remove(sKey);
        this.mhPluginWorkers.remove(sKey);
        return true;
    }

    public Enumeration getPlugins() {
        return this.mhPlugins.elements();
    }

    public PluginMetaData getPluginMetaData(Plugin aoPlugin) {
        String sKey = aoPlugin.getClass().getName();
        return (PluginMetaData)this.mhPluginMetaData.get(sKey);
    }

    private boolean loadPlugin(File aoFile) {
        URL[] aJarURLs = new URL[1];
        try {
            aJarURLs[0] = aoFile.toURL();
        }
        catch (MalformedURLException aoException) {
            Log.write(2, "Cannot load plugin:" + aoFile.getName());
            return false;
        }
        URLClassLoader oJarPluginLoader = new URLClassLoader(aJarURLs);
        URL oResourceURL = oJarPluginLoader.findResource("plugin.xml");
        if (oResourceURL == null) {
            Log.write(4, "Not a plugin: " + aoFile.getName());
            return false;
        }
        XMLParser.parse(oResourceURL.toString(), (DefaultHandler)this.moPluginConfigHandler);
        PluginMetaData oMetaData = this.moPluginConfigHandler.getPluginMetaData();
        String sPluginClassName = oMetaData.getClassName();
        return this.loadPlugin(oJarPluginLoader, sPluginClassName);
    }

    private boolean loadPlugin(ClassLoader aoLoader, String asName) {
        boolean bResult = false;
        Class<?> oClass = null;
        try {
            oClass = Class.forName(asName, true, aoLoader);
        }
        catch (ClassNotFoundException aoException) {
            return false;
        }
        if (!(class$novaworx$plugin$Plugin == null ? (class$novaworx$plugin$Plugin = PluginEngine.class$("novaworx.plugin.Plugin")) : class$novaworx$plugin$Plugin).isAssignableFrom(oClass)) {
            Log.write(2, "Class not a plugin: " + asName);
            return false;
        }
        Object oObject = null;
        try {
            oObject = oClass.newInstance();
        }
        catch (InstantiationException aoException) {
            Log.write(2, "Could not load plugin: " + asName);
            Log.write(6, (Throwable)aoException);
        }
        catch (IllegalAccessException aoException) {
            Log.write(2, "Could not load plugin: " + asName);
            Log.write(6, (Throwable)aoException);
        }
        if (oObject == null) {
            return false;
        }
        if (oObject instanceof Plugin) {
            Plugin oPlugin = oObject;
            bResult = this.add(oPlugin);
            if (bResult) {
                Log.write(5, "Plugin loaded: " + asName);
            } else {
                Log.write(4, "Plugin NOT loaded: " + asName);
            }
        }
        return bResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PluginConfigHandler
    extends DefaultHandler {
        private String msName;
        private String msLabel;
        private String msClass;
        private String msVersion;
        private Vector mvAuthors;
        private Vector mvDependencies;
        private StringBuffer moDataBuffer;

        public InputSource resolveEntity(String asPublicID, String asSystemID) {
            String sDTD = "plugin.dtd";
            if (asSystemID != null && asSystemID.endsWith(sDTD)) {
                try {
                    return new InputSource(this.getClass().getResourceAsStream(sDTD));
                }
                catch (Exception aoException) {
                    Log.write(2, "Error while loading DTD: " + sDTD);
                    Log.write(2, (Throwable)aoException);
                }
            }
            return null;
        }

        public void doctypeDecl(String asName, String asPublicID, String asSystemID) throws Exception {
            if ("plugin".equals(asName)) {
                return;
            }
            Log.write(2, "Loading catalog: DOCTYPE must be 'plugin'.");
        }

        private void clearDataBuffer() {
            this.moDataBuffer.delete(0, this.moDataBuffer.length());
        }

        private String getBufferData() {
            return this.moDataBuffer.toString();
        }

        public void startDocument() {
            this.mvAuthors = new Vector();
            this.mvDependencies = new Vector();
            this.moDataBuffer = new StringBuffer();
        }

        public void characters(char[] aaCharacters, int aiStart, int aiLength) {
            this.moDataBuffer.append(aaCharacters, aiStart, aiLength);
        }

        public void startElement(String asNamespace, String asLocalName, String asQualifiedName, Attributes aoAttributes) {
            if ("plugin".equals(asQualifiedName)) {
                this.msName = aoAttributes.getValue("name");
                this.msLabel = aoAttributes.getValue("label");
                this.msClass = aoAttributes.getValue("class");
                this.msVersion = aoAttributes.getValue("version");
            } else if ("author".equals(asQualifiedName)) {
                this.clearDataBuffer();
            } else if ("dependency".equals(asQualifiedName)) {
                String sName = aoAttributes.getValue("name");
                String sVersion = aoAttributes.getValue("version");
                this.mvDependencies.add(new PluginDependency(sName, sVersion));
            }
        }

        public void endElement(String asNamespace, String asLocalName, String asQualifiedName) {
            if ("author".equals(asQualifiedName)) {
                this.mvAuthors.add(this.getBufferData());
            }
        }

        public PluginMetaData getPluginMetaData() {
            String[] aAuthors = new String[this.mvAuthors.size()];
            PluginDependency[] aDependencies = new PluginDependency[this.mvDependencies.size()];
            aAuthors = this.mvAuthors.toArray(aAuthors);
            aDependencies = this.mvDependencies.toArray(aDependencies);
            return new PluginMetaData(this.msName, this.msLabel, this.msClass, this.msVersion, aAuthors, aDependencies);
        }
    }

    private class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStart) {
                PluginEngine.this.startPlugins();
            }
        }
    }

    private class PluginFileFilter
    implements FileFilter {
        private PluginFileFilter() {
        }

        public boolean accept(File aoFile) {
            String sFilename = aoFile.getName().toLowerCase();
            boolean bAccept = sFilename.endsWith(".jar") || sFilename.endsWith(".class");
            return bAccept;
        }
    }
}

