/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Random;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.Startup;
import novaworx.Version;
import novaworx.log.Log;
import novaworx.log.SocketLogger;
import novaworx.util.CommandLine;
import novaworx.util.thread.Worker;

public final class PeerEngine {
    private static PeerEngine moInstance;
    private int miPort;
    private PeerHandler moPeerHandler;

    private PeerEngine() {
    }

    public static PeerEngine get() {
        if (moInstance == null) {
            moInstance = new PeerEngine();
        }
        return moInstance;
    }

    public void start() {
        if (this.moPeerHandler == null) {
            this.moPeerHandler = new PeerHandler();
        }
        if (this.moPeerHandler.isExecuting()) {
            return;
        }
        this.moPeerHandler.start();
    }

    public void stop() {
        if (!this.moPeerHandler.isExecuting()) {
            return;
        }
        this.moPeerHandler.stop();
    }

    public int getPort() {
        return this.miPort;
    }

    private class PeerHandler
    extends Worker {
        private ServerSocketChannel moServerChannel;
        private Vector mvPeerChannels = new Vector();

        public void run() {
            boolean bPortOpen = false;
            Preferences oProgramPrefs = PreferenceEngine.get().getPreferences("/program/peerengine");
            while (!bPortOpen) {
                Random oRandom = new Random();
                PeerEngine.this.miPort = oRandom.nextInt(64511) + 1024;
                oProgramPrefs.putInt("port", PeerEngine.this.miPort);
                try {
                    oProgramPrefs.sync();
                }
                catch (BackingStoreException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
                try {
                    InetAddress oHost = InetAddress.getByName("localhost");
                    InetSocketAddress oAddress = new InetSocketAddress(oHost, PeerEngine.this.miPort);
                    this.moServerChannel = ServerSocketChannel.open();
                    this.moServerChannel.socket().bind(oAddress);
                    bPortOpen = true;
                }
                catch (IOException aoException) {
                    Log.write(6, (Throwable)aoException);
                    continue;
                }
                Log.write(5, "Peer server started on port: " + PeerEngine.this.miPort);
            }
            while (this.isExecuting()) {
                try {
                    Log.write(6, "Waiting for peer connections...");
                    SocketChannel oSocketChannel = this.moServerChannel.accept();
                    Socket oSocket = oSocketChannel.socket();
                    this.mvPeerChannels.add(oSocketChannel);
                    Log.write(5, "Peer connected: " + oSocket.getInetAddress().getHostAddress() + ":" + oSocket.getLocalPort());
                    MainEngine oMainEngine = MainEngine.get();
                    PrintStream oSocketPrint = new PrintStream(oSocket.getOutputStream());
                    oSocketPrint.println(Version.name() + " " + Version.getVersion() + " " + Version.getState());
                    ObjectInputStream oObjectIn = new ObjectInputStream(oSocket.getInputStream());
                    CommandLine oCommandLine = (CommandLine)oObjectIn.readObject();
                    SocketLogger oSocketLogger = new SocketLogger(oSocket);
                    oSocketLogger.setLevel(oCommandLine.get("log.level"));
                    Log.addLogger(oSocketLogger);
                    Startup.processParameters(oCommandLine);
                    Log.removeLogger(oSocketLogger);
                    oSocketChannel.close();
                    this.mvPeerChannels.remove(oSocketChannel);
                }
                catch (ClosedByInterruptException aoException) {
                    Log.write(6, "Socket closed by thread interrupt.");
                }
                catch (IOException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
                catch (ClassNotFoundException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
            }
            Log.write(6, "Resetting daemon port to zero...");
            PeerEngine.this.miPort = 0;
            oProgramPrefs.putInt("port", 0);
            try {
                oProgramPrefs.sync();
                Log.write(6, "Daemon port reset.");
            }
            catch (BackingStoreException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }

        public void stop() {
            super.stop();
            if (this.mvPeerChannels != null) {
                Vector vChannels = (Vector)this.mvPeerChannels.clone();
                int iCount = vChannels.size();
                for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                    SocketChannel oChannel = (SocketChannel)vChannels.get(iIndex);
                    try {
                        oChannel.close();
                        this.mvPeerChannels.remove(oChannel);
                        continue;
                    }
                    catch (IOException aoException) {
                        Log.write(2, (Throwable)aoException);
                    }
                }
            }
            try {
                Log.write(6, "Closing server socket...");
                this.moServerChannel.close();
                Log.write(6, "Server socket closed.");
            }
            catch (IOException aoException) {
                Log.write(6, (Throwable)aoException);
            }
        }
    }
}

