/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.io.File;
import novaworx.log.Log;

public class OperatingSystem {
    private static final int UNKNOWN = 0;
    private static final int UNIX = 1;
    private static final int WINDOWS_9X = 2;
    private static final int WINDOWS_NT = 3;
    private static final int OS2 = 4;
    private static final int MAC_OS_X = 5;
    private static int miOS;
    private static boolean mbFileSystemCaseSensitive;

    public static final boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static final boolean isWindows() {
        return miOS == 2 || miOS == 3;
    }

    public static final boolean isWindows9x() {
        return miOS == 2;
    }

    public static final boolean isWindowsNT() {
        return miOS == 3;
    }

    public static final boolean isOS2() {
        return miOS == 4;
    }

    public static final boolean isUnix() {
        return miOS == 1 || miOS == 5;
    }

    public static final boolean isMacOS() {
        return miOS == 5;
    }

    public static final boolean isFileSystemCaseSensitive() {
        return mbFileSystemCaseSensitive;
    }

    static {
        String sOSName = System.getProperty("os.name");
        if (sOSName.indexOf("Windows 9") != -1 || sOSName.indexOf("Windows ME") != -1) {
            miOS = 2;
        } else if (sOSName.indexOf("Windows") != -1) {
            miOS = 3;
        } else if (sOSName.indexOf("OS/2") != -1) {
            miOS = 4;
        } else if (File.separatorChar == '/' && new File("/dev").isDirectory()) {
            miOS = sOSName.indexOf("Mac OS X") != -1 ? 5 : 1;
        } else {
            miOS = 0;
            Log.write(3, "Unknown operating system: " + sOSName);
        }
        File oFileOne = new File("TestFile");
        File oFileTwo = new File("testfile");
        mbFileSystemCaseSensitive = !oFileOne.equals(oFileTwo);
    }
}

