/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.EventQueue;
import java.util.Hashtable;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import novaworx.GuiEngine;
import novaworx.PeerEngine;
import novaworx.PluginEngine;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.Settings;
import novaworx.ShutdownHook;
import novaworx.Startup;
import novaworx.WorkFrame;
import novaworx.WorkViewEngine;
import novaworx.WorkspaceEngine;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.log.Log;
import novaworx.message.DaemonModeDisabled;
import novaworx.message.DaemonModeEnabled;
import novaworx.message.ProgramStart;
import novaworx.message.ProgramStop;
import novaworx.message.ProgramStopRequested;
import novaworx.message.RequestProgramExit;
import novaworx.message.RequestProgramHalt;
import novaworx.message.RequestResourceSave;
import novaworx.resource.Resource;
import novaworx.swing.XOptionPane;
import novaworx.util.CommandLine;
import novaworx.util.thread.ThreadPool;
import novaworx.util.thread.Worker;

public final class MainEngine
implements Settings {
    private static MainEngine moInstance;
    private static boolean mbRunning;
    private static Hashtable mhSystemResources;
    private static Hashtable mhPublicResources;
    private static MessageHandler moMessageHandler;
    private static boolean mbDaemon;
    private static boolean mbDevel;
    private ThreadPool moThreadPool;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    private static boolean mbProgramStopRequest;
    static /* synthetic */ Class class$novaworx$message$RequestProgramExit;
    static /* synthetic */ Class class$novaworx$message$RequestProgramHalt;
    static /* synthetic */ Class class$novaworx$MainEngine;

    private MainEngine() {
    }

    public static MainEngine get() {
        if (moInstance == null) {
            moInstance = new MainEngine();
        }
        return moInstance;
    }

    void setDaemon(boolean abDaemon) {
        boolean previousDaemonState = this.isDaemon();
        mbDaemon = abDaemon;
        if (previousDaemonState != abDaemon) {
            if (abDaemon) {
                MessageBus.send(new DaemonModeEnabled(this));
            } else {
                MessageBus.send(new DaemonModeDisabled(this));
            }
        }
    }

    public boolean isDaemon() {
        return mbDaemon;
    }

    void setDevel(boolean abDevel) {
        mbDevel = abDevel;
    }

    public boolean isDevel() {
        return mbDevel;
    }

    public void start() {
        this.moThreadPool = new ThreadPool(0, 0);
        moMessageHandler = new MessageHandler();
        mhSystemResources = new Hashtable();
        mhPublicResources = new Hashtable();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.startEngine();
    }

    public boolean isRunning() {
        return mbRunning;
    }

    public void stop() {
        MessageBus.send(new RequestProgramExit(this));
    }

    private void startEngine() {
        Log.write("Starting main engine...");
        Log.write(5, "Home directory: " + Startup.getHomeDirectory());
        Log.write(5, "Work directory: " + System.getProperty("user.dir"));
        Log.write(5, "User directory: " + System.getProperty("user.home"));
        this.putSystemResource("thread.pool", this.moThreadPool);
        this.putSystemResource("command.line", Startup.getCommandLine());
        this.putSystemResource("home.directory", Startup.getHomeDirectory());
        this.putSystemResource("work.directory", System.getProperty("user.dir"));
        this.putSystemResource("user.directory", System.getProperty("user.home"));
        MessageBus.registerListener(moMessageHandler, class$novaworx$message$RequestProgramExit == null ? (class$novaworx$message$RequestProgramExit = MainEngine.class$("novaworx.message.RequestProgramExit")) : class$novaworx$message$RequestProgramExit);
        MessageBus.registerListener(moMessageHandler, class$novaworx$message$RequestProgramHalt == null ? (class$novaworx$message$RequestProgramHalt = MainEngine.class$("novaworx.message.RequestProgramHalt")) : class$novaworx$message$RequestProgramHalt);
        Log.write(5, "Adding shutdown hook...");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        Log.write(5, "Shutdown hook added.");
        Log.write(5, "Starting preference engine...");
        PreferenceEngine.get().start();
        this.moPreferenceChangeHandler.init();
        Log.write(5, "Preference engine started.");
        Log.write(5, "Starting thread pool...");
        this.moThreadPool.allow();
        Log.write(5, "Thread pool started.");
        Log.write(5, "Starting peer engine...");
        PeerEngine.get().start();
        Log.write(5, "Peer engine started.");
        Startup.advanceSplashProgress("Up to Peer Engine");
        Log.write(5, "Starting tool engine...");
        WorkViewEngine.get().start();
        Log.write(5, "View engine started.");
        Startup.advanceSplashProgress("View Engine");
        Log.write(5, "Starting plugin engine...");
        PluginEngine.get().start();
        Log.write(5, "Plugin engine started.");
        Log.write(5, "Starting workspace engine...");
        WorkspaceEngine.get().start();
        Log.write(5, "Workspace engine started.");
        Log.write(5, "Starting resource engine...");
        ResourceEngine.get().start();
        Log.write(5, "Resource engine started.");
        Log.write(5, "Starting gui engine...");
        GuiEngine.get().start();
        Log.write(5, "Gui engine started.");
        Log.write(6, "Starting message bus...");
        MessageBus.start();
        Log.write(6, "Message bus started.");
        Preferences oPeerPreferences = PreferenceEngine.get().getPreferences("/program/startup");
        boolean bQuickStart = PreferenceEngine.get().getBooleanValue(oPeerPreferences, "quickstart");
        if (!this.isDaemon()) {
            this.setDaemon(bQuickStart);
        }
        mbRunning = true;
        ProgramStart oStartMessage = new ProgramStart(class$novaworx$MainEngine == null ? (class$novaworx$MainEngine = MainEngine.class$("novaworx.MainEngine")) : class$novaworx$MainEngine);
        MessageBus.send(new ProgramStart(class$novaworx$MainEngine == null ? (class$novaworx$MainEngine = MainEngine.class$("novaworx.MainEngine")) : class$novaworx$MainEngine));
        Log.write("Main engine started.");
        Startup.advanceSplashProgress("Program Start");
    }

    private void stopProgram(boolean abHalt) {
        WorkFrame[] aWorkFrames = GuiEngine.get().getWorkFrames();
        for (int iIndex = 0; iIndex < aWorkFrames.length; ++iIndex) {
            aWorkFrames[iIndex].setVisible(false);
        }
        if (!abHalt && this.isDaemon()) {
            return;
        }
        this.stopEngine();
        System.exit(0);
    }

    private void stopEngine() {
        Log.write("Stopping main engine...");
        MessageBus.send(new ProgramStop(class$novaworx$MainEngine == null ? (class$novaworx$MainEngine = MainEngine.class$("novaworx.MainEngine")) : class$novaworx$MainEngine));
        Log.write(5, "Stopping message bus...");
        MessageBus.stop();
        Log.write(5, "Message bus stopped.");
        Log.write(5, "Stopping gui engine...");
        GuiEngine.get().stop();
        Log.write(5, "Gui engine stopped.");
        Log.write(5, "Stopping resource engine...");
        ResourceEngine.get().stop();
        Log.write(5, "Resource engine stopped.");
        Log.write(5, "Stopping workspace engine...");
        WorkspaceEngine.get().stop();
        Log.write(5, "Workspace engine stopped.");
        Log.write(5, "Stopping plugin engine...");
        PluginEngine.get().stop();
        Log.write(5, "Plugin engine stopped.");
        Log.write(5, "Stopping tool engine...");
        WorkViewEngine.get().stop();
        Log.write(5, "View engine stopped.");
        Log.write(5, "Stopping peer engine...");
        PeerEngine.get().stop();
        Log.write(5, "Peer engine stopped.");
        Log.write(5, "Stopping thread pool...");
        this.moThreadPool.disallow();
        Log.write(5, "Thread pool stopped.");
        Log.write(5, "Stopping preference engine...");
        PreferenceEngine.get().stop();
        Log.write(5, "Preference engine stopped.");
        Log.write("Main engine stopped.");
        Log.waitFor();
        mbRunning = false;
    }

    void putSystemResource(String asKey, Object aoResource) {
        if (asKey == null) {
            return;
        }
        if (aoResource == null) {
            mhSystemResources.remove(asKey);
        } else {
            mhSystemResources.put(asKey, aoResource);
        }
    }

    public void putResource(String asKey, Object aoResource) {
        if (asKey == null) {
            return;
        }
        if (aoResource == null) {
            mhPublicResources.remove(asKey);
        } else {
            mhPublicResources.put(asKey, aoResource);
        }
    }

    public Object getResource(String asKey) {
        Object oResource = mhSystemResources.get(asKey);
        if (oResource == null) {
            oResource = mhPublicResources.get(asKey);
        }
        return oResource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Shutdown
    extends Worker {
        private int miDelay;
        private boolean mbHalt;

        public Shutdown(boolean abHalt) {
            this.mbHalt = abHalt;
            this.start();
        }

        public void run() {
            ProgramStopRequested oMessage = new ProgramStopRequested(this);
            MessageBus.send(oMessage);
            oMessage.waitFor();
            try {
                Thread.sleep(this.miDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MainEngine.this.stopProgram(this.mbHalt);
        }

        public void delay(int aiDelay) {
            this.miDelay = Math.max(this.miDelay, aiDelay);
        }
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moStartupPreferences;
        private Preferences moThreadPoolPreferences;

        public void init() {
            this.moStartupPreferences = PreferenceEngine.get().getPreferences("/program/startup");
            this.moThreadPoolPreferences = PreferenceEngine.get().getPreferences("/program/threadpool");
            this.moStartupPreferences.addPreferenceChangeListener(this);
            this.moThreadPoolPreferences.addPreferenceChangeListener(this);
            PreferenceEngine.get().initPreference(this.moStartupPreferences, "quickstart", this);
            PreferenceEngine.get().initPreference(this.moThreadPoolPreferences, "minimum", this);
            PreferenceEngine.get().initPreference(this.moThreadPoolPreferences, "maximum", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moStartupPreferences) {
                CommandLine oCommandLine;
                if ("quickstart".equals(sKey) && !"true".equals((oCommandLine = (CommandLine)MainEngine.this.getResource("command.line")).get("daemon"))) {
                    MainEngine.this.setDaemon("true".equals(sValue));
                }
            } else if (oPreferences == this.moThreadPoolPreferences) {
                if ("minimum".equals(sKey)) {
                    MainEngine.this.moThreadPool.setMinimumSize(Integer.parseInt(sValue));
                } else if ("maximum".equals(sKey)) {
                    MainEngine.this.moThreadPool.setMaximumSize(Integer.parseInt(sValue));
                }
            }
        }
    }

    private class RequestShutdown
    implements Runnable {
        public RequestShutdown() {
            EventQueue.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MainEngine mainEngine = MainEngine.this;
            synchronized (mainEngine) {
                if (mbProgramStopRequest) {
                    return;
                }
                mbProgramStopRequest = true;
            }
            Preferences oPreferences = PreferenceEngine.get().getPreferences("/program/shutdown");
            boolean bConfirm = PreferenceEngine.get().getBooleanValue(oPreferences, "confirm");
            boolean bAutosave = PreferenceEngine.get().getBooleanValue(oPreferences, "autosave");
            boolean bAutosaveConfirm = PreferenceEngine.get().getBooleanValue(oPreferences, "autosave.confirm");
            int iModifiedResourceCount = ResourceEngine.get().getModifiedResourceCount();
            WorkFrame oSelectedWorkFrame = null;
            Object oSelectedWorkArea = null;
            JRootPane oRootPane = null;
            JLayeredPane oLayeredPane = null;
            oSelectedWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            if (oSelectedWorkFrame != null) {
                oRootPane = oSelectedWorkFrame.getRootPane();
            }
            if (oRootPane != null) {
                oLayeredPane = (JLayeredPane)oRootPane.getGlassPane();
            }
            if (oLayeredPane != null) {
                int iResult;
                boolean bSaveResources = bAutosave;
                JLayeredPane oParent = oLayeredPane;
                if (!bAutosave && bAutosaveConfirm && iModifiedResourceCount > 0) {
                    iResult = XOptionPane.showInternalConfirmDialog(oParent, "Do you want to save modified resources?", "Shutdown", 1);
                    switch (iResult) {
                        case 0: {
                            bSaveResources = true;
                            break;
                        }
                        case 1: {
                            bSaveResources = false;
                            break;
                        }
                        case 2: {
                            mbProgramStopRequest = false;
                            return;
                        }
                    }
                } else if (bConfirm) {
                    iResult = XOptionPane.showInternalConfirmDialog(oParent, "Do you want to exit?", "Shutdown", 0);
                    switch (iResult) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            mbProgramStopRequest = false;
                            return;
                        }
                    }
                }
                if (bSaveResources) {
                    Resource[] aResources = ResourceEngine.get().getModifiedResources();
                    RequestResourceSave oMessage = new RequestResourceSave((Object)(class$novaworx$MainEngine == null ? (class$novaworx$MainEngine = MainEngine.class$("novaworx.MainEngine")) : class$novaworx$MainEngine), aResources);
                    MessageBus.send(oMessage);
                    oMessage.waitFor();
                }
            }
            mbProgramStopRequest = false;
            new Shutdown(false);
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof RequestProgramExit) {
                new RequestShutdown();
            }
            if (aoMessage instanceof RequestProgramHalt) {
                new Shutdown(true);
            }
        }
    }
}

