/*
 * Decompiled with CFR 0.152.
 */
package novaworx;

import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.Startup;
import novaworx.WorkFrame;
import novaworx.WorkViewEngine;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.KeystrokeGrabber;
import novaworx.gui.ProgramTheme;
import novaworx.gui.ShortcutGrabber;
import novaworx.log.Log;
import novaworx.message.RequestFrameShow;
import novaworx.plaf.novaworx.NovaworxLookAndFeel;
import novaworx.swing.XMenu;
import novaworx.swing.XMenuItem;
import novaworx.swing.XToolBar;

public final class GuiEngine {
    private static final String MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String KUNSTSTOFF = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private static final String NOVAWORX = "novaworx.plaf.novaworx.NovaworxLookAndFeel";
    private static final String SKIN = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    private static GuiEngine moInstance;
    private static KeyEventDispatcher moKeystrokeGrabber;
    private static KeyEventDispatcher moShortcutGrabber;
    private Vector mvWorkFrames = new Vector();
    private WorkFrame moSelectedWorkFrame;
    private MessageHandler moMessageHandler;
    MediaTracker moTracker = new MediaTracker(new JPanel());
    static /* synthetic */ Class class$novaworx$message$RequestFrameShow;

    private GuiEngine() {
        KeyboardFocusManager oManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        moKeystrokeGrabber = new KeystrokeGrabber();
        moShortcutGrabber = new ShortcutGrabber();
        MainEngine oMainEngine = MainEngine.get();
        oMainEngine.putResource("keystroke.grabber", moKeystrokeGrabber);
        oMainEngine.putResource("shortcut.grabber", moShortcutGrabber);
        oManager.addKeyEventDispatcher(moKeystrokeGrabber);
        oManager.addKeyEventDispatcher(moShortcutGrabber);
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$RequestFrameShow == null ? (class$novaworx$message$RequestFrameShow = GuiEngine.class$("novaworx.message.RequestFrameShow")) : class$novaworx$message$RequestFrameShow);
    }

    public static GuiEngine get() {
        if (moInstance == null) {
            moInstance = new GuiEngine();
        }
        return moInstance;
    }

    public void start() {
        Log.write(6, "Setting look and feel...");
        Preferences moLookAndFeelPreferences = PreferenceEngine.get().getPreferences("/program/lookandfeel");
        String sLookAndFeel = PreferenceEngine.get().getStringValue(moLookAndFeelPreferences, "name");
        this.setLookAndFeel(sLookAndFeel);
        Log.write(6, "Look and feel set.");
        Log.write(6, "Creating inital frame...");
        this.moSelectedWorkFrame = this.createWorkFrame();
        Log.write(6, "Initial frame created.");
        Object oView = null;
        WorkViewEngine oWorkViewEngine = WorkViewEngine.get();
        Startup.advanceSplashProgress("Program frame created.");
        oWorkViewEngine.returnView(oWorkViewEngine.getView("novaworx.view.resource.ResourceView"));
        Startup.advanceSplashProgress("ResourceView created.");
        oWorkViewEngine.returnView(oWorkViewEngine.getView("novaworx.view.preference.PreferenceManager"));
        Startup.advanceSplashProgress("PreferenceManager created.");
    }

    public void stop() {
    }

    public void setLookAndFeel(String asLookAndFeelName) {
        if ("SYSTEM".equals(asLookAndFeelName)) {
            asLookAndFeelName = UIManager.getSystemLookAndFeelClassName();
        }
        if ("NOVAWORX".equals(asLookAndFeelName)) {
            asLookAndFeelName = NOVAWORX;
            NovaworxLookAndFeel.setCurrentTheme(new ProgramTheme());
        }
        if (METAL.equals(asLookAndFeelName)) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        Log.write(-1, "Look and Feel: " + asLookAndFeelName);
        try {
            UIManager.setLookAndFeel(asLookAndFeelName);
        }
        catch (UnsupportedLookAndFeelException aoException) {
            Log.write(3, (Throwable)aoException);
        }
        catch (IllegalAccessException aoException) {
            Log.write(3, (Throwable)aoException);
        }
        catch (InstantiationException aoException) {
            Log.write(3, (Throwable)aoException);
        }
        catch (ClassNotFoundException aoException) {
            Log.write(3, (Throwable)aoException);
        }
        this.updateUI();
    }

    public WorkFrame[] getWorkFrames() {
        return this.mvWorkFrames.toArray(new WorkFrame[this.mvWorkFrames.size()]);
    }

    public WorkFrame getSelectedWorkFrame() {
        return this.moSelectedWorkFrame;
    }

    private WorkFrame createWorkFrame() {
        WorkFrame oWorkFrame = new WorkFrame();
        this.mvWorkFrames.add(oWorkFrame);
        int iIndex = this.mvWorkFrames.indexOf(oWorkFrame);
        String sPreferencesKey = "/interface/frame-" + iIndex;
        Preferences oPreferences = PreferenceEngine.get().getPreferences(sPreferencesKey);
        String sDefaultPreferencesKey = "/interface/default";
        Preferences oDefaultPreferences = PreferenceEngine.get().getPreferences(sDefaultPreferencesKey);
        oWorkFrame.setPreferences(oPreferences, oDefaultPreferences);
        return oWorkFrame;
    }

    public final JMenuBar createMenuBar(String asMenuBar) {
        JMenuBar oBar = new JMenuBar();
        String sToken = null;
        StringTokenizer oTokenizer = new StringTokenizer(asMenuBar, " \t()|-:", true);
        while (oTokenizer.hasMoreTokens()) {
            sToken = oTokenizer.nextToken();
            if ("(".equals(sToken)) {
                int iPairCount = 1;
                String sMenuToken = null;
                StringBuffer oMenuBuffer = new StringBuffer();
                while (iPairCount > 0) {
                    sMenuToken = oTokenizer.nextToken();
                    if ("(".equals(sMenuToken)) {
                        ++iPairCount;
                    } else if (")".equals(sMenuToken)) {
                        --iPairCount;
                    }
                    oMenuBuffer.append(sMenuToken);
                }
                XMenu oMenu = this.createMenu(oMenuBuffer.substring(1, oMenuBuffer.length() - 2));
                if (oMenu == null) continue;
                oMenu.setIcon(null);
                oBar.add(oMenu);
                continue;
            }
            if (" ".equals(sToken) || "\t".equals(sToken) || "\r".equals(sToken) || "\n".equals(sToken)) continue;
            Log.write(2, "Unknown value in menu bar definition: " + sToken);
        }
        return oBar;
    }

    public final XMenu createMenu(String asMenu) {
        String sMenu = asMenu.trim();
        int iIndex = sMenu.indexOf(":");
        String sHeader = sMenu.substring(0, iIndex).trim();
        String sMenuBody = sMenu.substring(iIndex + 1).trim();
        StringTokenizer oTokenizer = new StringTokenizer(sHeader);
        AbstractButton oMenu = null;
        String sName = null;
        String sIcon = "null";
        int iMnemonic = 0;
        if (oTokenizer.hasMoreTokens()) {
            sName = oTokenizer.nextToken();
            if (sName != null) {
                oMenu = new XMenu(sName.replaceAll("_", " "));
                ((JMenuItem)oMenu).setEnabled(false);
            } else {
                return null;
            }
        }
        if (oTokenizer.hasMoreTokens()) {
            try {
                iMnemonic = Integer.parseInt(oTokenizer.nextToken());
            }
            catch (NumberFormatException aoException) {
                // empty catch block
            }
        }
        oMenu.setMnemonic(sName.charAt(iMnemonic));
        oMenu.setDisplayedMnemonicIndex(iMnemonic);
        if (oTokenizer.hasMoreTokens()) {
            sIcon = oTokenizer.nextToken();
        }
        oMenu.setIcon(IconCache.getIcon(sIcon));
        oMenu.setPressedIcon(IconCache.filterIcon(IconCache.getIcon(sIcon), IconCache.PRESSED_FILTER));
        oMenu.setDisabledIcon(IconCache.filterIcon(IconCache.getIcon(sIcon), IconCache.DISABLED_FILTER));
        String sToken = null;
        StringTokenizer oBodyTokenizer = new StringTokenizer(sMenuBody, " \r\n\t()|-:", true);
        while (oBodyTokenizer.hasMoreTokens()) {
            Action oAction;
            sToken = oBodyTokenizer.nextToken();
            if ("(".equals(sToken)) {
                int iPairCount = 1;
                String sNestedToken = null;
                StringBuffer oNestedBuffer = new StringBuffer();
                while (iPairCount > 0) {
                    sNestedToken = oBodyTokenizer.nextToken();
                    if ("(".equals(sNestedToken)) {
                        ++iPairCount;
                    } else if (")".equals(sNestedToken)) {
                        --iPairCount;
                    }
                    oNestedBuffer.append(sNestedToken);
                }
                XMenu oNestedMenu = this.createMenu(oNestedBuffer.substring(1, oNestedBuffer.length() - 2));
                if (oNestedMenu == null) continue;
                ((XMenu)oMenu).add(oNestedMenu);
                ((JMenuItem)oMenu).setEnabled(true);
                continue;
            }
            if ("|".equals(sToken)) {
                ((JMenu)oMenu).addSeparator();
                continue;
            }
            if (" ".equals(sToken) || "\t".equals(sToken) || "\r".equals(sToken) || "\n".equals(sToken) || (oAction = ActionLibrary.get(sToken)) == null) continue;
            XMenuItem oMenuItem = new XMenuItem(oAction);
            oMenuItem.setDisabledIcon(IconCache.filterIcon(oMenuItem.getIcon(), IconCache.DISABLED_FILTER));
            ((XMenu)oMenu).add(oMenuItem);
            ((JMenuItem)oMenu).setEnabled(true);
        }
        return oMenu;
    }

    public final XToolBar createToolBar(String asToolBar) {
        return this.createToolBar(asToolBar, true);
    }

    public final XToolBar createToolBar(String asToolBar, boolean abRollover) {
        return this.createToolBar(asToolBar, abRollover, false);
    }

    public final XToolBar createToolBar(String asToolBar, boolean abRollover, boolean abTransparent) {
        XToolBar oBar = new XToolBar();
        String sToken = null;
        StringTokenizer oTokenizer = new StringTokenizer(asToolBar, " \r\n\t|-", true);
        while (oTokenizer.hasMoreTokens()) {
            Action oAction;
            sToken = oTokenizer.nextToken();
            if ("|".equals(sToken)) {
                oBar.addSeparator();
                continue;
            }
            if ("-".equals(sToken)) {
                oBar.add(Box.createHorizontalGlue());
                continue;
            }
            if (" ".equals(sToken) || "\t".equals(sToken) || (oAction = ActionLibrary.get(sToken)) == null) continue;
            JButton oButton = oBar.add(oAction);
            this.modifyToolBarButton(oButton, abRollover, abTransparent);
        }
        return oBar;
    }

    private final JButton modifyToolBarButton(JButton aoButton, boolean abRollover, boolean abTransparent) {
        aoButton.setPressedIcon(IconCache.filterIcon(aoButton.getIcon(), IconCache.PRESSED_FILTER));
        aoButton.setDisabledIcon(IconCache.filterIcon(aoButton.getIcon(), IconCache.DISABLED_FILTER));
        aoButton.setMargin(new Insets(0, 0, 0, 0));
        aoButton.setFocusPainted(false);
        aoButton.setContentAreaFilled(!abTransparent);
        return aoButton;
    }

    public final Image loadImage(File aoFile) {
        if (aoFile == null || aoFile != null && !aoFile.exists()) {
            return null;
        }
        Image oImage = Toolkit.getDefaultToolkit().createImage(aoFile.toString());
        try {
            this.moTracker.addImage(oImage, 0);
            this.moTracker.waitForAll();
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
        }
        return oImage;
    }

    public final Image loadImage(URL aoURL) {
        Image oImage = Toolkit.getDefaultToolkit().createImage(aoURL);
        try {
            this.moTracker.addImage(oImage, 0);
            this.moTracker.waitForAll();
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
        }
        return oImage;
    }

    public final Image loadImage(URI aoURI) {
        URL oURL = null;
        try {
            oURL = aoURI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (oURL == null) {
            return null;
        }
        return this.loadImage(oURL);
    }

    public void requestFrameShow() {
        if (this.moSelectedWorkFrame == null) {
            this.moSelectedWorkFrame = this.mvWorkFrames.size() == 0 ? this.createWorkFrame() : (WorkFrame)this.mvWorkFrames.get(0);
        }
        Log.write(5, "Showing work frame...");
        Log.write(6, "Work frame size: " + this.moSelectedWorkFrame.getSize());
        this.moSelectedWorkFrame.show();
        Log.write(5, "Work frame visible.");
    }

    public void updateUI() {
        WorkFrame[] aWorkFrames = this.getWorkFrames();
        for (int iIndex = 0; iIndex < aWorkFrames.length; ++iIndex) {
            new UpdateUI(aWorkFrames[iIndex]);
        }
    }

    public void repaintUI() {
        WorkFrame[] aWorkFrames = this.getWorkFrames();
        for (int iIndex = 0; iIndex < aWorkFrames.length; ++iIndex) {
            aWorkFrames[iIndex].repaint();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof RequestFrameShow) {
                GuiEngine.this.requestFrameShow();
            }
        }
    }

    private class UpdateUI
    implements Runnable {
        Component moComponent;

        public UpdateUI(Component aoComponent) {
            this.moComponent = aoComponent;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            SwingUtilities.updateComponentTreeUI(this.moComponent);
            this.moComponent.repaint();
        }
    }
}

