/*
 * Decompiled with CFR 0.152.
 */
package widex.widgets.rolloverbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class RolloverButtonBorder
implements Border {
    public static final int PAINT_NOTHING = 0;
    public static final int PAINT_ROLLOVER = 1;
    public static final int PAINT_PRESSED = 2;
    protected static Object currentPressedButton = null;
    public Color shadow;
    public Color darkShadow;
    public Color highlight;
    public Color lightHighlight;

    public RolloverButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        this.shadow = table.getColor("Button.shadow");
        this.darkShadow = table.getColor("Button.darkShadow");
        this.highlight = table.getColor("Button.light");
        this.lightHighlight = table.getColor("Button.highlight");
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        AbstractButton button = (AbstractButton)c;
        boolean isArmed = button.getModel().isArmed();
        boolean isPressed = button.getModel().isPressed();
        boolean isRollover = button.getModel().isRollover();
        boolean isSelected = button.getModel().isSelected();
        int paintStyle = 0;
        if (currentPressedButton == null || currentPressedButton != c) {
            // empty if block
        }
        if (isRollover) {
            if (isPressed) {
                currentPressedButton = c;
                paintStyle = 2;
            } else {
                paintStyle = isSelected ? 2 : 1;
            }
        } else if (isPressed) {
            paintStyle = 1;
            if (isSelected) {
                paintStyle = 2;
            }
        } else {
            paintStyle = isSelected ? 2 : (c.isFocusOwner() ? 1 : 0);
        }
        if (paintStyle == 1) {
            this.paintBorderRollover(c, g, x, y, width, height);
        } else if (paintStyle == 2) {
            this.paintBorderPressed(c, g, x, y, width, height);
        }
        if (currentPressedButton == c && !isPressed) {
            currentPressedButton = null;
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public abstract void paintBorderRollover(Component var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract void paintBorderPressed(Component var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract Insets getBorderInsets(Component var1);
}

