/*
 * Decompiled with CFR 0.152.
 */
package widex.widgets.rolloverbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;
import widex.widgets.rolloverbutton.IERolloverBorder;
import widex.widgets.rolloverbutton.RolloverButtonBorder;

public class RolloverButton {
    static RolloverButtonBorder s_rolloverButtonBorder;

    public static void setRolloverButtonBorder(RolloverButtonBorder rolloverButtonBorder) {
        s_rolloverButtonBorder = rolloverButtonBorder;
    }

    public static AbstractButton configure(AbstractButton button) {
        return RolloverButton.configure(button, false);
    }

    public static AbstractButton configure(AbstractButton button, boolean focusable) {
        if (s_rolloverButtonBorder == null) {
            s_rolloverButtonBorder = new IERolloverBorder(null, null, null, Color.white);
        }
        button.setRolloverEnabled(true);
        button.setFocusPainted(false);
        button.setFocusable(focusable);
        button.setBorder(new CompoundBorder(s_rolloverButtonBorder, new MarginBorder()));
        button.setOpaque(false);
        button.setBackground(null);
        button.addFocusListener(new ThisFocusListener());
        return button;
    }

    private static class MarginBorder
    extends AbstractBorder {
        private MarginBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }
    }

    static class ThisFocusListener
    implements FocusListener {
        ThisFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            ((AbstractButton)e.getSource()).getModel().setRollover(true);
        }

        public void focusLost(FocusEvent e) {
            ((AbstractButton)e.getSource()).getModel().setRollover(false);
        }
    }
}

